/*
 * Decompiled with CFR 0.152.
 */
package ui.webview;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.web.WebEngine;
import javafx.stage.Modality;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.download.DownloadThread;
import ui.download.IDownloadListener;
import ui.tuneinfos.TuneInfos;
import ui.webview.WebViewType;

public class WebView
extends Tab
implements UIPart {
    @FXML
    private Button backward;
    @FXML
    private Button forward;
    @FXML
    private javafx.scene.web.WebView webView;
    @FXML
    private TextField urlField;
    @FXML
    private ToggleButton showTuneInfoButton;
    @FXML
    private Slider zoom;
    private Convenience convenience;
    private WebViewType type;
    private WebEngine engine;
    private UIUtil util;
    private ChangeListener<? super Number> progressListener = (observable, oldValue, newValue) -> Platform.runLater(() -> {
        DoubleProperty progressProperty = this.util.progressProperty((Node)this.webView);
        progressProperty.setValue(newValue);
    });
    private ChangeListener<? super String> locationListener = (observable, oldValue, newValue) -> {
        try {
            this.urlField.setText(newValue);
            if (!this.convenience.isSupportedMedia(new File((String)newValue))) {
                return;
            }
            new DownloadThread(this.util.getConfig(), new IDownloadListener(){

                @Override
                public void downloadStop(File downloadedFile) {
                    try {
                        if (downloadedFile != null && WebView.this.convenience.autostart(downloadedFile, Convenience.LEXICALLY_FIRST_MEDIA, null)) {
                            downloadedFile.deleteOnExit();
                            Platform.runLater(() -> WebView.this.util.setPlayingTab(WebView.this));
                        }
                    }
                    catch (IOException | URISyntaxException | SidTuneError exception) {
                        // empty catch block
                    }
                }

                @Override
                public void downloadStep(int step) {
                    DoubleProperty progressProperty = WebView.this.util.progressProperty((Node)WebView.this.webView);
                    progressProperty.setValue((Number)Float.valueOf((float)step / 100.0f));
                }
            }, new URL((String)newValue), false).start();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    };
    private ChangeListener<? super Number> historyListener = (observable, oldValue, newValue) -> {
        this.backward.setDisable(newValue.intValue() <= 0);
        this.forward.setDisable(newValue.intValue() + 1 >= this.engine.getHistory().getEntries().size());
    };
    private boolean showTuneInfos;

    public WebView(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
    }

    public void setType(WebViewType type) {
        this.type = type;
        this.setId(type.name());
        this.setText(this.util.getBundle().getString(this.getId()));
        this.home();
    }

    @FXML
    private void initialize() {
        this.convenience = new Convenience(this.util.getPlayer());
        this.convenience.setAutoStartedFile(file -> {
            if (this.showTuneInfos && PathUtils.getFilenameSuffix(file.getName()).equalsIgnoreCase(".sid")) {
                this.showTuneInfos(this.util.getPlayer().getTune(), (File)file);
            }
        });
        this.engine = this.webView.getEngine();
        this.engine.getHistory().currentIndexProperty().addListener(this.historyListener);
        this.engine.locationProperty().addListener(this.locationListener);
        this.engine.getLoadWorker().progressProperty().addListener(this.progressListener);
        this.zoom.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.util.getConfig().getOnlineSection().setZoom(newValue.doubleValue());
            this.webView.setZoom(newValue.doubleValue());
        });
        this.zoom.setValue(this.util.getConfig().getOnlineSection().getZoom());
    }

    @Override
    public void doClose() {
        this.engine.getHistory().currentIndexProperty().removeListener(this.historyListener);
        this.engine.locationProperty().removeListener(this.locationListener);
        this.engine.getLoadWorker().progressProperty().removeListener(this.progressListener);
    }

    @FXML
    private void backward() {
        this.engine.getHistory().go(-1);
    }

    @FXML
    private void reload() {
        this.engine.reload();
    }

    @FXML
    private void home() {
        this.urlField.setText(this.type.getUrl());
        this.setUrl();
    }

    @FXML
    private void forward() {
        this.engine.getHistory().go(1);
    }

    @FXML
    private void setUrl() {
        this.engine.load(this.urlField.getText());
    }

    @FXML
    private void setShowTuneInfos() {
        this.showTuneInfos = this.showTuneInfoButton.isSelected();
    }

    private void showTuneInfos(SidTune sidTune, File tuneFile) {
        Platform.runLater(() -> {
            TuneInfos tuneInfos = new TuneInfos(this.util.getPlayer());
            tuneInfos.getStage().initModality(Modality.WINDOW_MODAL);
            tuneInfos.getStage().initOwner(this.urlField.getScene().getWindow());
            tuneInfos.open();
            tuneInfos.showTuneInfos(tuneFile, sidTune);
        });
    }
}

