/*
 * Decompiled with CFR 0.152.
 */
package ui.virtualKeyboard;

import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleButton;
import libsidplay.C64;
import libsidplay.common.Event;
import libsidplay.components.keyboard.KeyTableEntry;
import sidplay.Player;
import ui.common.C64Window;

public class Keyboard
extends C64Window {
    @FXML
    private Button arrowLeft;
    @FXML
    private Button one;
    @FXML
    private Button two;
    @FXML
    private Button three;
    @FXML
    private Button four;
    @FXML
    private Button five;
    @FXML
    private Button six;
    @FXML
    private Button seven;
    @FXML
    private Button eight;
    @FXML
    private Button nine;
    @FXML
    private Button zero;
    @FXML
    private Button plus;
    @FXML
    private Button minus;
    @FXML
    private Button pound;
    @FXML
    private Button clrHome;
    @FXML
    private Button insDel;
    @FXML
    private Button q;
    @FXML
    private Button w;
    @FXML
    private Button e;
    @FXML
    private Button r;
    @FXML
    private Button t;
    @FXML
    private Button y;
    @FXML
    private Button u;
    @FXML
    private Button i;
    @FXML
    private Button o;
    @FXML
    private Button p;
    @FXML
    private Button at;
    @FXML
    private Button asterisk;
    @FXML
    private Button arrowUp;
    @FXML
    private Button restore;
    @FXML
    private Button a;
    @FXML
    private Button s;
    @FXML
    private Button d;
    @FXML
    private Button f;
    @FXML
    private Button g;
    @FXML
    private Button h;
    @FXML
    private Button j;
    @FXML
    private Button k;
    @FXML
    private Button l;
    @FXML
    private Button colon;
    @FXML
    private Button semicolon;
    @FXML
    private Button equals;
    @FXML
    private Button ret;
    @FXML
    private Button z;
    @FXML
    private Button x;
    @FXML
    private Button c;
    @FXML
    private Button v;
    @FXML
    private Button b;
    @FXML
    private Button n;
    @FXML
    private Button m;
    @FXML
    private Button comma;
    @FXML
    private Button period;
    @FXML
    private Button slash;
    @FXML
    private Button cursorUpDown;
    @FXML
    private Button cursorLeftRight;
    @FXML
    private Button space;
    @FXML
    private Button f1;
    @FXML
    private Button f3;
    @FXML
    private Button f5;
    @FXML
    private Button f7;
    @FXML
    private ToggleButton runStop;
    @FXML
    private ToggleButton shift;
    @FXML
    private ToggleButton commodore;
    @FXML
    private ToggleButton shiftLock;
    @FXML
    private ToggleButton ctrl;
    @FXML
    private ToggleButton rightShift;

    public Keyboard(Player player) {
        super(player);
        this.getStage().setResizable(false);
    }

    @Override
    public void doClose() {
        this.releaseC64Key(KeyTableEntry.RUN_STOP);
        this.releaseC64Key(KeyTableEntry.SHIFT_LEFT);
        this.releaseC64Key(KeyTableEntry.COMMODORE);
        this.releaseC64Key(KeyTableEntry.CTRL);
        this.releaseC64Key(KeyTableEntry.SHIFT_RIGHT);
    }

    @FXML
    private void arrowLeft() {
        this.pressC64Key(KeyTableEntry.ARROW_LEFT);
        this.releaseC64Key(KeyTableEntry.ARROW_LEFT);
    }

    @FXML
    private void one() {
        this.pressC64Key(KeyTableEntry.ONE);
        this.releaseC64Key(KeyTableEntry.ONE);
    }

    @FXML
    private void two() {
        this.pressC64Key(KeyTableEntry.TWO);
        this.releaseC64Key(KeyTableEntry.TWO);
    }

    @FXML
    private void three() {
        this.pressC64Key(KeyTableEntry.THREE);
        this.releaseC64Key(KeyTableEntry.THREE);
    }

    @FXML
    private void four() {
        this.pressC64Key(KeyTableEntry.FOUR);
        this.releaseC64Key(KeyTableEntry.FOUR);
    }

    @FXML
    private void five() {
        this.pressC64Key(KeyTableEntry.FIVE);
        this.releaseC64Key(KeyTableEntry.FIVE);
    }

    @FXML
    private void six() {
        this.pressC64Key(KeyTableEntry.SIX);
        this.releaseC64Key(KeyTableEntry.SIX);
    }

    @FXML
    private void seven() {
        this.pressC64Key(KeyTableEntry.SEVEN);
        this.releaseC64Key(KeyTableEntry.SEVEN);
    }

    @FXML
    private void eight() {
        this.pressC64Key(KeyTableEntry.EIGHT);
        this.releaseC64Key(KeyTableEntry.EIGHT);
    }

    @FXML
    private void nine() {
        this.pressC64Key(KeyTableEntry.NINE);
        this.releaseC64Key(KeyTableEntry.NINE);
    }

    @FXML
    private void zero() {
        this.pressC64Key(KeyTableEntry.ZERO);
        this.releaseC64Key(KeyTableEntry.ZERO);
    }

    @FXML
    private void plus() {
        this.pressC64Key(KeyTableEntry.PLUS);
        this.releaseC64Key(KeyTableEntry.PLUS);
    }

    @FXML
    private void minus() {
        this.pressC64Key(KeyTableEntry.MINUS);
        this.releaseC64Key(KeyTableEntry.MINUS);
    }

    @FXML
    private void pound() {
        this.pressC64Key(KeyTableEntry.POUND);
        this.releaseC64Key(KeyTableEntry.POUND);
    }

    @FXML
    private void clrHome() {
        this.pressC64Key(KeyTableEntry.CLEAR_HOME);
        this.releaseC64Key(KeyTableEntry.CLEAR_HOME);
    }

    @FXML
    private void insDel() {
        this.pressC64Key(KeyTableEntry.INS_DEL);
        this.releaseC64Key(KeyTableEntry.INS_DEL);
    }

    @FXML
    private void ctrl() {
        if (this.ctrl.isSelected()) {
            this.pressC64Key(KeyTableEntry.CTRL);
        } else {
            this.releaseC64Key(KeyTableEntry.CTRL);
        }
    }

    @FXML
    private void q() {
        this.pressC64Key(KeyTableEntry.Q);
        this.releaseC64Key(KeyTableEntry.Q);
    }

    @FXML
    private void w() {
        this.pressC64Key(KeyTableEntry.W);
        this.releaseC64Key(KeyTableEntry.W);
    }

    @FXML
    private void e() {
        this.pressC64Key(KeyTableEntry.E);
        this.releaseC64Key(KeyTableEntry.E);
    }

    @FXML
    private void r() {
        this.pressC64Key(KeyTableEntry.R);
        this.releaseC64Key(KeyTableEntry.R);
    }

    @FXML
    private void t() {
        this.pressC64Key(KeyTableEntry.T);
        this.releaseC64Key(KeyTableEntry.T);
    }

    @FXML
    private void y() {
        this.pressC64Key(KeyTableEntry.Y);
        this.releaseC64Key(KeyTableEntry.Y);
    }

    @FXML
    private void u() {
        this.pressC64Key(KeyTableEntry.U);
        this.releaseC64Key(KeyTableEntry.U);
    }

    @FXML
    private void i() {
        this.pressC64Key(KeyTableEntry.I);
        this.releaseC64Key(KeyTableEntry.I);
    }

    @FXML
    private void o() {
        this.pressC64Key(KeyTableEntry.O);
        this.releaseC64Key(KeyTableEntry.O);
    }

    @FXML
    private void p() {
        this.pressC64Key(KeyTableEntry.P);
        this.releaseC64Key(KeyTableEntry.P);
    }

    @FXML
    private void at() {
        this.pressC64Key(KeyTableEntry.AT);
        this.releaseC64Key(KeyTableEntry.AT);
    }

    @FXML
    private void asterisk() {
        this.pressC64Key(KeyTableEntry.STAR);
        this.releaseC64Key(KeyTableEntry.STAR);
    }

    @FXML
    private void arrowUp() {
        this.pressC64Key(KeyTableEntry.ARROW_UP);
        this.releaseC64Key(KeyTableEntry.ARROW_UP);
    }

    @FXML
    private void restore() {
        this.util.getPlayer().getC64().getKeyboard().restore();
    }

    @FXML
    private void runStop() {
        if (this.runStop.isSelected()) {
            this.pressC64Key(KeyTableEntry.RUN_STOP);
        } else {
            this.releaseC64Key(KeyTableEntry.RUN_STOP);
        }
    }

    @FXML
    private void shiftLock() {
        if (this.shiftLock.isSelected()) {
            this.pressC64Key(KeyTableEntry.SHIFT_LEFT);
        } else {
            this.releaseC64Key(KeyTableEntry.SHIFT_LEFT);
        }
    }

    @FXML
    private void a() {
        this.pressC64Key(KeyTableEntry.A);
        this.releaseC64Key(KeyTableEntry.A);
    }

    @FXML
    private void s() {
        this.pressC64Key(KeyTableEntry.S);
        this.releaseC64Key(KeyTableEntry.S);
    }

    @FXML
    private void d() {
        this.pressC64Key(KeyTableEntry.D);
        this.releaseC64Key(KeyTableEntry.D);
    }

    @FXML
    private void f() {
        this.pressC64Key(KeyTableEntry.F);
        this.releaseC64Key(KeyTableEntry.F);
    }

    @FXML
    private void g() {
        this.pressC64Key(KeyTableEntry.G);
        this.releaseC64Key(KeyTableEntry.G);
    }

    @FXML
    private void h() {
        this.pressC64Key(KeyTableEntry.H);
        this.releaseC64Key(KeyTableEntry.H);
    }

    @FXML
    private void j() {
        this.pressC64Key(KeyTableEntry.J);
        this.releaseC64Key(KeyTableEntry.J);
    }

    @FXML
    private void k() {
        this.pressC64Key(KeyTableEntry.K);
        this.releaseC64Key(KeyTableEntry.K);
    }

    @FXML
    private void l() {
        this.pressC64Key(KeyTableEntry.L);
        this.releaseC64Key(KeyTableEntry.L);
    }

    @FXML
    private void colon() {
        this.pressC64Key(KeyTableEntry.COLON);
        this.releaseC64Key(KeyTableEntry.COLON);
    }

    @FXML
    private void semicolon() {
        this.pressC64Key(KeyTableEntry.SEMICOLON);
        this.releaseC64Key(KeyTableEntry.SEMICOLON);
    }

    @FXML
    private void equals() {
        this.pressC64Key(KeyTableEntry.EQUALS);
        this.releaseC64Key(KeyTableEntry.EQUALS);
    }

    @FXML
    private void ret() {
        this.pressC64Key(KeyTableEntry.RETURN);
        this.releaseC64Key(KeyTableEntry.RETURN);
    }

    @FXML
    private void commodore() {
        if (this.commodore.isSelected()) {
            this.pressC64Key(KeyTableEntry.COMMODORE);
        } else {
            this.releaseC64Key(KeyTableEntry.COMMODORE);
        }
    }

    @FXML
    private void shift() {
        if (this.shift.isSelected()) {
            this.pressC64Key(KeyTableEntry.SHIFT_LEFT);
        } else {
            this.releaseC64Key(KeyTableEntry.SHIFT_LEFT);
        }
    }

    @FXML
    private void z() {
        this.pressC64Key(KeyTableEntry.Z);
        this.releaseC64Key(KeyTableEntry.Z);
    }

    @FXML
    private void x() {
        this.pressC64Key(KeyTableEntry.X);
        this.releaseC64Key(KeyTableEntry.X);
    }

    @FXML
    private void c() {
        this.pressC64Key(KeyTableEntry.C);
        this.releaseC64Key(KeyTableEntry.C);
    }

    @FXML
    private void v() {
        this.pressC64Key(KeyTableEntry.V);
        this.releaseC64Key(KeyTableEntry.V);
    }

    @FXML
    private void b() {
        this.pressC64Key(KeyTableEntry.B);
        this.releaseC64Key(KeyTableEntry.B);
    }

    @FXML
    private void n() {
        this.pressC64Key(KeyTableEntry.N);
        this.releaseC64Key(KeyTableEntry.N);
    }

    @FXML
    private void m() {
        this.pressC64Key(KeyTableEntry.M);
        this.releaseC64Key(KeyTableEntry.M);
    }

    @FXML
    private void comma() {
        this.pressC64Key(KeyTableEntry.COMMA);
        this.releaseC64Key(KeyTableEntry.COMMA);
    }

    @FXML
    private void period() {
        this.pressC64Key(KeyTableEntry.PERIOD);
        this.releaseC64Key(KeyTableEntry.PERIOD);
    }

    @FXML
    private void slash() {
        this.pressC64Key(KeyTableEntry.SLASH);
        this.releaseC64Key(KeyTableEntry.SLASH);
    }

    @FXML
    private void rightShift() {
        if (this.rightShift.isSelected()) {
            this.pressC64Key(KeyTableEntry.SHIFT_RIGHT);
        } else {
            this.releaseC64Key(KeyTableEntry.SHIFT_RIGHT);
        }
    }

    @FXML
    private void cursorUpDown() {
        this.pressC64Key(KeyTableEntry.CURSOR_UP_DOWN);
        this.releaseC64Key(KeyTableEntry.CURSOR_UP_DOWN);
    }

    @FXML
    private void cursorLeftRight() {
        this.pressC64Key(KeyTableEntry.CURSOR_LEFT_RIGHT);
        this.releaseC64Key(KeyTableEntry.CURSOR_LEFT_RIGHT);
    }

    @FXML
    private void space() {
        this.pressC64Key(KeyTableEntry.SPACE);
        this.releaseC64Key(KeyTableEntry.SPACE);
    }

    @FXML
    private void f1() {
        this.pressC64Key(KeyTableEntry.F1);
        this.releaseC64Key(KeyTableEntry.F1);
    }

    @FXML
    private void f3() {
        this.pressC64Key(KeyTableEntry.F3);
        this.releaseC64Key(KeyTableEntry.F3);
    }

    @FXML
    private void f5() {
        this.pressC64Key(KeyTableEntry.F5);
        this.releaseC64Key(KeyTableEntry.F5);
    }

    @FXML
    private void f7() {
        this.pressC64Key(KeyTableEntry.F7);
        this.releaseC64Key(KeyTableEntry.F7);
    }

    private void pressC64Key(final KeyTableEntry key) {
        this.getC64().getEventScheduler().scheduleThreadSafe(new Event("Virtual Keyboard Key Pressed: " + key.name()){

            @Override
            public void event() throws InterruptedException {
                Keyboard.this.getC64().getKeyboard().keyPressed(key);
            }
        });
    }

    private void releaseC64Key(final KeyTableEntry key) {
        this.getC64().getEventScheduler().scheduleThreadSafe(new Event("Virtual Keyboard Key Released: " + key.name()){

            @Override
            public void event() throws InterruptedException {
                Keyboard.this.getC64().getKeyboard().keyReleased(key);
            }
        });
    }

    @FXML
    private void list() {
        this.util.getPlayer().typeInCommand("LIST\r");
    }

    @FXML
    private void run() {
        this.util.getPlayer().typeInCommand("RUN\r");
    }

    @FXML
    private void sys() {
        this.util.getPlayer().typeInCommand("SYS 49152");
    }

    @FXML
    private void reset() {
        this.util.getPlayer().typeInCommand("SYS 64738\r");
    }

    @FXML
    private void directory() {
        this.util.getPlayer().typeInCommand("LOAD\"$\",8\r");
    }

    @FXML
    private void diskLoad() {
        this.util.getPlayer().typeInCommand("LOAD\"*\",8,1\r");
    }

    @FXML
    private void tapeLoad() {
        this.util.getPlayer().typeInCommand("LOAD\r");
    }

    protected C64 getC64() {
        return this.util.getPlayer().getC64();
    }
}

