/*
 * Decompiled with CFR 0.152.
 */
package ui.videoscreen;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.util.Duration;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.keyboard.KeyTableEntry;
import libsidplay.components.mos656x.VIC;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import sidplay.Player;
import sidplay.ini.IniDefaults;
import sidplay.player.State;
import ui.common.C64Window;
import ui.common.NumberToString;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.entities.config.EmulationSection;
import ui.entities.config.SidPlay2Section;
import ui.filefilter.CartFileExtensions;
import ui.filefilter.DiskFileExtensions;
import ui.filefilter.TapeFileExtensions;
import ui.virtualKeyboard.Keyboard;

public class Video
extends Tab
implements UIPart,
Consumer<int[]> {
    public static final String ID = "VIDEO";
    private static final double PAL_MARGIN_LEFT = 55.0;
    private static final double PAL_MARGIN_RIGHT = 55.0;
    private static final double PAL_MARGIN_TOP = 45.0;
    private static final double PAL_MARGIN_BOTTOM = 55.0;
    private static final double NTSC_MARGIN_LEFT = 55.0;
    private static final double NTSC_MARGIN_RIGHT = 55.0;
    private static final double NTSC_MARGIN_TOP = 38.0;
    private static final double NTSC_MARGIN_BOTTOM = 48.0;
    @FXML
    private TitledPane monitor;
    @FXML
    private Canvas screen;
    @FXML
    private ImageView monitorBorder;
    @FXML
    private ImageView breadbox;
    @FXML
    private ImageView pc64;
    @FXML
    private Slider scaling;
    @FXML
    private Slider brightness;
    @FXML
    private Slider contrast;
    @FXML
    private Slider gamma;
    @FXML
    private Slider saturation;
    @FXML
    private Slider phaseShift;
    @FXML
    private Slider offset;
    @FXML
    private Slider tint;
    @FXML
    private Slider blur;
    @FXML
    private Slider bleed;
    @FXML
    private CheckBox applyImmediately;
    @FXML
    private CheckBox showMonitorBorder;
    @FXML
    private Label scalingValue;
    @FXML
    private Label brightnessValue;
    @FXML
    private Label contrastValue;
    @FXML
    private Label gammaValue;
    @FXML
    private Label saturationValue;
    @FXML
    private Label phaseShiftValue;
    @FXML
    private Label offsetValue;
    @FXML
    private Label tintValue;
    @FXML
    private Label blurValue;
    @FXML
    private Label bleedValue;
    @FXML
    private ImageView datasetteOff;
    @FXML
    private ImageView datasetteLoad;
    @FXML
    private ImageView datasetteSave;
    @FXML
    private ImageView c1541Off;
    @FXML
    private ImageView c1541On;
    @FXML
    private ImageView c1541Load;
    @FXML
    private ImageView c1541IIOff;
    @FXML
    private ImageView c1541IIOn;
    @FXML
    private ImageView c1541IILoad;
    @FXML
    private Label tapeName;
    @FXML
    private Label diskName;
    @FXML
    private Label cartridgeName;
    private Keyboard virtualKeyboard;
    private Timeline timer;
    private Object syncFrame = new Object();
    private Image frame;
    private Image lastFrame;
    private int vicFrames;
    private double marginLeft;
    private double marginRight;
    private double marginTop;
    private double marginBottom;
    private UIUtil util;
    private ScheduledService<Void> screenUpdateService = new ScheduledService<Void>(){

        protected Task<Void> createTask() {
            return new Task<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void call() throws InterruptedException {
                    Object object = Video.this.syncFrame;
                    synchronized (object) {
                        Video.this.lastFrame = Video.this.frame;
                    }
                    Video.this.screen.getGraphicsContext2D().drawImage(Video.this.lastFrame, 0.0, 0.0, Video.this.lastFrame.getWidth(), Video.this.lastFrame.getHeight(), Video.this.marginLeft, Video.this.marginTop, Video.this.screen.getWidth() - (Video.this.marginLeft + Video.this.marginRight), Video.this.screen.getHeight() - (Video.this.marginTop + Video.this.marginBottom));
                    return null;
                }
            };
        }
    };
    private ChangeListener<? super State> stateListener = (obj, oldValue, newValue) -> {
        if (newValue == State.START) {
            Platform.runLater(() -> {
                SidTune tune = this.util.getPlayer().getTune();
                EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
                this.setupVideoScreen(CPUClock.getCPUClock(emulationSection, tune));
                this.setVisibilityBasedOnChipType(tune);
            });
        }
    };

    public Video(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
        this.setId(ID);
        this.setText(this.util.getBundle().getString(this.getId()));
    }

    @FXML
    private void initialize() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        this.util.getPlayer().stateProperty().addListener(this.stateListener);
        this.scaling.setLabelFormatter(new NumberToString(2));
        this.scaling.valueProperty().bindBidirectional((Property)sidplay2Section.videoScalingProperty());
        this.scalingValue.textProperty().bindBidirectional((Property)sidplay2Section.videoScalingProperty(), new NumberToString(2));
        this.scaling.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.applyImmediately.isSelected()) {
                this.updateScaling();
            }
        });
        this.brightness.setLabelFormatter(new NumberToString(2));
        this.brightness.valueProperty().bindBidirectional((Property)sidplay2Section.brightnessProperty());
        this.brightnessValue.textProperty().bindBidirectional((Property)sidplay2Section.brightnessProperty(), new NumberToString(2));
        this.brightness.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setBrightness(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.contrast.setLabelFormatter(new NumberToString(2));
        this.contrast.valueProperty().bindBidirectional((Property)sidplay2Section.contrastProperty());
        this.contrastValue.textProperty().bindBidirectional((Property)sidplay2Section.contrastProperty(), new NumberToString(2));
        this.contrast.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setContrast(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.gamma.setLabelFormatter(new NumberToString(2));
        this.gamma.valueProperty().bindBidirectional((Property)sidplay2Section.gammaProperty());
        this.gammaValue.textProperty().bindBidirectional((Property)sidplay2Section.gammaProperty(), new NumberToString(2));
        this.gamma.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setGamma(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.saturation.setLabelFormatter(new NumberToString(2));
        this.saturation.valueProperty().bindBidirectional((Property)sidplay2Section.saturationProperty());
        this.saturationValue.textProperty().bindBidirectional((Property)sidplay2Section.saturationProperty(), new NumberToString(2));
        this.saturation.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setSaturation(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.phaseShift.setLabelFormatter(new NumberToString(2));
        this.phaseShift.valueProperty().bindBidirectional((Property)sidplay2Section.phaseShiftProperty());
        this.phaseShiftValue.textProperty().bindBidirectional((Property)sidplay2Section.phaseShiftProperty(), new NumberToString(2));
        this.phaseShift.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setPhaseShift(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.offset.setLabelFormatter(new NumberToString(2));
        this.offset.valueProperty().bindBidirectional((Property)sidplay2Section.offsetProperty());
        this.offsetValue.textProperty().bindBidirectional((Property)sidplay2Section.offsetProperty(), new NumberToString(2));
        this.offset.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setOffset(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.tint.setLabelFormatter(new NumberToString(2));
        this.tint.valueProperty().bindBidirectional((Property)sidplay2Section.tintProperty());
        this.tintValue.textProperty().bindBidirectional((Property)sidplay2Section.tintProperty(), new NumberToString(2));
        this.tint.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setTint(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.blur.setLabelFormatter(new NumberToString(2));
        this.blur.valueProperty().bindBidirectional((Property)sidplay2Section.blurProperty());
        this.blurValue.textProperty().bindBidirectional((Property)sidplay2Section.blurProperty(), new NumberToString(2));
        this.blur.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setLuminanceC(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.bleed.setLabelFormatter(new NumberToString(2));
        this.bleed.valueProperty().bindBidirectional((Property)sidplay2Section.bleedProperty());
        this.bleedValue.textProperty().bindBidirectional((Property)sidplay2Section.bleedProperty(), new NumberToString(2));
        this.bleed.valueProperty().addListener((observable, oldValue, newValue) -> this.updateVICChipConfiguration(vic -> vic.getPalette().setDotCreep(newValue.floatValue()), this.applyImmediately.isSelected()));
        this.showMonitorBorder.selectedProperty().bindBidirectional(sidplay2Section.showMonitorProperty());
        SidTune tune = this.util.getPlayer().getTune();
        this.setupVideoScreen(CPUClock.getCPUClock(emulationSection, tune));
        this.setVisibilityBasedOnChipType(tune);
        this.setupKeyboard();
        this.updatePeripheralImages();
        this.screenUpdateService.start();
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.stateListener);
        this.util.getPlayer().configureVICs(vic -> vic.setPixelConsumer(pixels -> {}));
        this.screenUpdateService.cancel();
    }

    @FXML
    private void showVirtualKeyboard() {
        this.virtualKeyboard = new Keyboard(this.util.getPlayer());
        this.virtualKeyboard.getStage().initModality(Modality.WINDOW_MODAL);
        this.virtualKeyboard.getStage().initOwner(this.screen.getScene().getWindow());
        this.virtualKeyboard.open();
    }

    @FXML
    private void insertTape() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Tape Image (TAP, T64, PRG, P00, GZ or ZIP)", TapeFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_TAPE"));
        File file = fileDialog.showOpenDialog(this.screen.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertTape(file);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void insertDisk() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Disk Image (D64, G64, NIB, GZ or ZIP)", DiskFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_DISK"));
        File file = fileDialog.showOpenDialog(this.screen.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertDisk(file);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void insertCartridge() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Cartridges", CartFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_CARTRIDGE"));
        File file = fileDialog.showOpenDialog(this.screen.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertCartridge(CartridgeType.CRT, file);
                this.util.getPlayer().play(SidTune.RESET);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void apply() {
        this.updateScaling();
        this.util.getPlayer().configureVICs(vic -> vic.updatePalette());
    }

    @FXML
    private void showMonitorBorder() {
        this.util.getConfig().getSidplay2Section().setShowMonitor(this.showMonitorBorder.isSelected());
        this.setVisibilityBasedOnChipType(this.util.getPlayer().getTune());
    }

    @FXML
    private void defaultPalette() {
        this.applyImmediately.setSelected(false);
        this.scaling.setValue(2.5);
        this.brightness.setValue((double)IniDefaults.DEFAULT_BRIGHTNESS);
        this.contrast.setValue((double)IniDefaults.DEFAULT_CONTRAST);
        this.gamma.setValue((double)IniDefaults.DEFAULT_GAMMA);
        this.saturation.setValue((double)IniDefaults.DEFAULT_SATURATION);
        this.phaseShift.setValue((double)IniDefaults.DEFAULT_PHASE_SHIFT);
        this.offset.setValue((double)IniDefaults.DEFAULT_OFFSET);
        this.tint.setValue((double)IniDefaults.DEFAULT_TINT);
        this.blur.setValue((double)IniDefaults.DEFAULT_BLUR);
        this.bleed.setValue((double)IniDefaults.DEFAULT_BLEED);
        this.apply();
        this.util.getConfig().getSidplay2Section().setShowMonitor(true);
        this.showMonitorBorder();
        this.applyImmediately.setSelected(true);
    }

    private void setupVideoScreen(CPUClock cpuClock) {
        if (cpuClock == CPUClock.PAL) {
            this.marginLeft = 55.0;
            this.marginRight = 55.0;
            this.marginTop = 45.0;
            this.marginBottom = 55.0;
        } else {
            this.marginLeft = 55.0;
            this.marginRight = 55.0;
            this.marginTop = 38.0;
            this.marginBottom = 48.0;
        }
        this.vicFrames = 0;
        ScheduledExecutorService schdExctr = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = this.defaultThreadFactory.newThread(r);
                t.setDaemon(true);
                t.setPriority(10);
                return t;
            }
        });
        this.screenUpdateService.setExecutor((Executor)schdExctr);
        this.screenUpdateService.setPeriod(Duration.millis((double)(1000.0 / cpuClock.getRefresh())));
        this.screen.getGraphicsContext2D().clearRect(0.0, 0.0, this.screen.widthProperty().get(), this.screen.heightProperty().get());
        this.screen.setWidth((double)this.util.getPlayer().getC64().getVIC().getBorderWidth());
        this.screen.setHeight((double)this.util.getPlayer().getC64().getVIC().getBorderHeight());
        this.updateScaling();
    }

    private void updateScaling() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        double scale = sidplay2Section.getVideoScaling();
        this.screen.setScaleX(scale);
        this.screen.setScaleY(scale);
        this.monitor.setPrefHeight(2.147483647E9);
        for (ImageView imageView : Arrays.asList(this.monitorBorder, this.breadbox, this.pc64)) {
            imageView.setScaleX(scale * this.screen.getWidth() / (imageView.getImage().getWidth() + this.marginLeft + this.marginRight));
            imageView.setScaleY(scale * this.screen.getHeight() / (imageView.getImage().getHeight() + this.marginTop + this.marginBottom));
        }
    }

    private void setupKeyboard() {
        this.monitor.setOnKeyPressed(event -> {
            KeyTableEntry keyTableEntry = this.util.getConfig().getKeyTabEntry(event.getCode().getName());
            if (event.isShiftDown()) {
                this.pressC64Key(KeyTableEntry.SHIFT_LEFT);
            }
            if (event.isControlDown()) {
                this.pressC64Key(KeyTableEntry.COMMODORE);
            }
            if (keyTableEntry != null) {
                this.pressC64Key(keyTableEntry);
                this.releaseC64Key(keyTableEntry);
                event.consume();
            }
            if (event.isShiftDown()) {
                this.releaseC64Key(KeyTableEntry.SHIFT_LEFT);
            }
            if (event.isControlDown()) {
                this.releaseC64Key(KeyTableEntry.COMMODORE);
            }
        });
    }

    private void pressC64Key(final KeyTableEntry key) {
        this.util.getPlayer().getC64().getEventScheduler().scheduleThreadSafe(new Event("Virtual Keyboard Key Pressed: " + key.name()){

            @Override
            public void event() throws InterruptedException {
                Video.this.util.getPlayer().getC64().getKeyboard().keyPressed(key);
            }
        });
    }

    private void releaseC64Key(final KeyTableEntry key) {
        this.util.getPlayer().getC64().getEventScheduler().scheduleThreadSafe(new Event("Virtual Keyboard Key Released: " + key.name()){

            @Override
            public void event() throws InterruptedException {
                Video.this.util.getPlayer().getC64().getKeyboard().keyReleased(key);
            }
        });
    }

    private void updatePeripheralImages() {
        Duration duration = Duration.millis((double)1000.0);
        KeyFrame oneFrame = new KeyFrame(duration, evt -> {
            Datasette.DatasetteStatus datasetteStatus = this.util.getPlayer().getDatasette().getStatus();
            this.tapeName.setText(this.util.getPlayer().getDatasette().getTapeImage().getName());
            switch (datasetteStatus) {
                case OFF: {
                    this.datasetteOff.setVisible(true);
                    for (ImageView imageView : Arrays.asList(this.datasetteLoad, this.datasetteSave)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                case LOAD: {
                    this.datasetteLoad.setVisible(true);
                    for (ImageView imageView : Arrays.asList(this.datasetteOff, this.datasetteSave)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                case SAVE: {
                    this.datasetteSave.setVisible(true);
                    for (ImageView imageView : Arrays.asList(this.datasetteOff, this.datasetteLoad)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected datasette status: " + (Object)((Object)datasetteStatus));
                }
            }
            C1541 firstC1541 = this.util.getPlayer().getFloppies()[0];
            this.diskName.setText(firstC1541.getDiskName());
            C1541.FloppyStatus floppyStatus = firstC1541.getStatus();
            switch (floppyStatus) {
                case OFF: {
                    this.c1541Off.setVisible(firstC1541.getFloppyType() == C1541.FloppyType.C1541);
                    this.c1541IIOff.setVisible(firstC1541.getFloppyType() == C1541.FloppyType.C1541_II);
                    for (ImageView imageView : Arrays.asList(this.c1541On, this.c1541IIOn, this.c1541Load, this.c1541IILoad)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                case ON: {
                    this.c1541On.setVisible(firstC1541.getFloppyType() == C1541.FloppyType.C1541);
                    this.c1541IIOn.setVisible(firstC1541.getFloppyType() == C1541.FloppyType.C1541_II);
                    for (ImageView imageView : Arrays.asList(this.c1541Off, this.c1541IIOff, this.c1541Load, this.c1541IILoad)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                case LOAD: {
                    this.c1541Load.setVisible(firstC1541.getFloppyType() == C1541.FloppyType.C1541);
                    this.c1541IILoad.setVisible(firstC1541.getFloppyType() == C1541.FloppyType.C1541_II);
                    for (ImageView imageView : Arrays.asList(this.c1541Off, this.c1541IIOff, this.c1541On, this.c1541IIOn)) {
                        imageView.setVisible(false);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected floppy status: " + (Object)((Object)floppyStatus));
                }
            }
            this.cartridgeName.setText(this.util.getPlayer().getC64().getCartridge().toString());
        }, new KeyValue[0]);
        this.timer = new Timeline(new KeyFrame[]{oneFrame});
        this.timer.setCycleCount(-1);
        this.timer.playFromStart();
    }

    private void setVisibilityBasedOnChipType(SidTune sidTune) {
        this.util.getPlayer().configureVICs(vic -> vic.setPixelConsumer(pixels -> {}));
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        if (sidTune != SidTune.RESET && sidTune.getInfo().getPlayAddr() != 0) {
            this.screen.setVisible(false);
            this.monitorBorder.setVisible(false);
            if (ChipModel.getChipModel(emulationSection, sidTune, 0) == ChipModel.MOS6581) {
                this.breadbox.setVisible(true);
                this.pc64.setVisible(false);
            } else {
                this.pc64.setVisible(true);
                this.breadbox.setVisible(false);
            }
        } else {
            this.breadbox.setVisible(false);
            this.pc64.setVisible(false);
            this.screen.setVisible(true);
            this.monitorBorder.setVisible(this.showMonitorBorder.isSelected());
            this.util.getPlayer().configureVICs(vic -> vic.setPixelConsumer(this));
        }
    }

    private void updateVICChipConfiguration(Consumer<VIC> action, boolean apply) {
        this.util.getPlayer().configureVICs(action.andThen(vic -> {
            if (apply) {
                vic.updatePalette();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(int[] pixels) {
        int fastForwardBitMask = this.util.getPlayer().getMixerInfo(m -> m.getFastForwardBitMask(), 0);
        if ((this.vicFrames++ & fastForwardBitMask) == fastForwardBitMask) {
            this.vicFrames = 0;
            Image image = this.createImage(Arrays.copyOf(pixels, pixels.length));
            Object object = this.syncFrame;
            synchronized (object) {
                this.frame = image;
            }
        }
    }

    private Image createImage(int[] pixels) {
        VIC vic = this.util.getPlayer().getC64().getVIC();
        WritableImage image = new WritableImage(vic.getBorderWidth(), vic.getBorderHeight());
        image.getPixelWriter().setPixels(0, 0, vic.getBorderWidth(), vic.getBorderHeight(), (PixelFormat)PixelFormat.getIntArgbInstance(), pixels, 0, vic.getBorderWidth());
        return image;
    }

    public Image getVicImage() {
        return this.lastFrame;
    }
}

