/*
 * Decompiled with CFR 0.152.
 */
package ui.update;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextArea;
import libsidutils.WebUtils;
import sidplay.Player;
import ui.JSidPlay2Main;
import ui.common.C64Window;

public class Update
extends C64Window {
    @FXML
    private TextArea update;
    @FXML
    private Hyperlink latestVersionLink;

    public Update(Player player) {
        super(player);
    }

    @FXML
    private void initialize() {
        float currentVersion = 2.1474836E9f;
        try {
            Properties currentProperties = new Properties();
            URL resource = JSidPlay2Main.class.getResource("/META-INF/maven/jsidplay2/jsidplay2/pom.properties");
            currentProperties.load(resource.openConnection().getInputStream());
            currentVersion = Float.parseFloat(currentProperties.getProperty("version"));
        }
        catch (IOException | NullPointerException currentProperties) {
            // empty catch block
        }
        float latestVersion = -2.1474836E9f;
        try {
            Properties latestProperties = new Properties();
            URL resource = new URL("http://sourceforge.net/p/jsidplay2/code/HEAD/tree/trunk/jsidplay2/latest.properties?format=raw");
            latestProperties.load(resource.openConnection().getInputStream());
            latestVersion = Float.parseFloat(latestProperties.getProperty("version"));
        }
        catch (IOException | NullPointerException latestProperties) {
            // empty catch block
        }
        boolean updateAvailable = latestVersion > currentVersion;
        this.latestVersionLink.setVisible(updateAvailable);
        this.update.setText(this.util.getBundle().getString(updateAvailable ? "UPDATE_AVAILABLE" : "NO_UPDATE"));
    }

    @FXML
    private void gotoLatestVersion() {
        WebUtils.browse("http://sourceforge.net/projects/jsidplay2/files/latest/download");
    }

    @FXML
    private void okPressed(ActionEvent event) {
        this.close();
    }
}

