/*
 * Decompiled with CFR 0.152.
 */
package ui.stilview;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import libsidutils.stil.STIL;
import sidplay.Player;
import ui.common.C64Window;
import ui.stilview.STILEntryTreeItem;

public class STILView
extends C64Window {
    private static final String STYLE_NORMAL = "styleNormal";
    private static final String STYLE_FILENAME = "styleFilename";
    private static final String STYLE_COMMENT = "styleComment";
    private static final String STYLE_SUBTUNE = "styleSubtune";
    private static final String STYLE_NAME = "styleName";
    private static final String STYLE_TITLE = "styleTitle";
    private static final String STYLE_AUTHOR = "styleAuthor";
    private static final String STYLE_ARTIST = "styleArtist";
    @FXML
    private TreeView<Object> tree;
    @FXML
    private VBox textArea;
    @FXML
    private SplitPane splitPane;

    public STILView(Player player) {
        super(player);
    }

    @FXML
    private void initialize() {
        this.splitPane.setDividerPosition(0, 0.3);
        this.tree.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.setTextAreaFromTree(newValue.getValue());
            }
        });
    }

    public void setEntry(STIL.STILEntry entry) {
        STILEntryTreeItem root = new STILEntryTreeItem(entry);
        this.tree.setRoot((TreeItem)root);
        this.tree.getSelectionModel().select((Object)root);
    }

    protected void setTextAreaFromTree(Object comp) {
        this.textArea.getChildren().clear();
        this.writeSTIL(comp);
    }

    private void writeSTIL(Object comp) {
        if (comp instanceof STIL.STILEntry) {
            int i;
            STIL.STILEntry entry = (STIL.STILEntry)comp;
            this.writeEntry(entry);
            for (i = 0; i < entry.infos.size(); ++i) {
                this.writeSTIL(entry.infos.get(i));
            }
            for (i = 0; i < entry.subtunes.size(); ++i) {
                this.writeSTIL(entry.subtunes.get(i));
            }
        } else if (comp instanceof STIL.TuneEntry) {
            STIL.TuneEntry tuneEntry = (STIL.TuneEntry)comp;
            this.writeSubTune(tuneEntry);
            for (int i = 0; i < tuneEntry.infos.size(); ++i) {
                this.writeSTIL(tuneEntry.infos.get(i));
            }
        } else if (comp instanceof STIL.Info) {
            STIL.Info info = (STIL.Info)comp;
            this.writeInfo(info);
        }
    }

    private void writeEntry(STIL.STILEntry entry) {
        this.addText(this.util.getBundle().getString("FILENAME"), entry.filename, STYLE_FILENAME);
        if (entry.globalComment != null) {
            this.addText("", entry.globalComment.trim(), STYLE_NORMAL);
        }
    }

    private void writeSubTune(STIL.TuneEntry tuneEntry) {
        this.addNewLine();
        this.addText(this.util.getBundle().getString("SUBTUNE"), String.valueOf(tuneEntry.tuneNo) + " ", STYLE_SUBTUNE);
        if (tuneEntry.globalComment != null) {
            this.addText("", tuneEntry.globalComment.trim(), STYLE_COMMENT);
        }
    }

    private void writeInfo(STIL.Info info) {
        if (info.comment != null) {
            this.addText("", info.comment.trim(), STYLE_NORMAL);
        }
        if (info.name != null) {
            this.addText(this.util.getBundle().getString("NAME"), info.name, STYLE_NAME);
        }
        if (info.author != null) {
            this.addText(this.util.getBundle().getString("AUTHOR"), info.author, STYLE_AUTHOR);
        }
        if (info.title != null) {
            this.addText(this.util.getBundle().getString("TITLE"), info.title, STYLE_TITLE);
        }
        if (info.artist != null) {
            this.addText(this.util.getBundle().getString("ARTIST"), info.artist, STYLE_ARTIST);
        }
    }

    private void addText(String heading, String text, String style) {
        HBox line = new HBox();
        Label headingLabel = new Label(heading);
        headingLabel.setWrapText(true);
        headingLabel.getStyleClass().add((Object)style);
        line.getChildren().add((Object)headingLabel);
        Label textLabel = new Label(text);
        textLabel.setWrapText(true);
        textLabel.getStyleClass().add((Object)STYLE_NORMAL);
        line.getChildren().add((Object)textLabel);
        this.textArea.getChildren().add((Object)line);
    }

    private void addNewLine() {
        HBox line = new HBox();
        Label newline = new Label("\n");
        newline.setWrapText(true);
        newline.getStyleClass().add((Object)STYLE_NORMAL);
        line.getChildren().add((Object)newline);
        this.textArea.getChildren().add((Object)line);
    }
}

