/*
 * Decompiled with CFR 0.152.
 */
package ui.stilview;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import libsidutils.stil.STIL;
import ui.stilview.TuneEntryTreeItem;

public class STILEntryTreeItem
extends TreeItem<Object> {
    private boolean hasLoadedChildren;

    public STILEntryTreeItem(STIL.STILEntry entry) {
        super((Object)entry);
    }

    public boolean isLeaf() {
        STIL.STILEntry stilEntry = (STIL.STILEntry)this.getValue();
        return stilEntry.subtunes.size() == 0;
    }

    public ObservableList<TreeItem<Object>> getChildren() {
        if (!this.hasLoadedChildren) {
            this.hasLoadedChildren = true;
            ArrayList<TuneEntryTreeItem> children = new ArrayList<TuneEntryTreeItem>();
            STIL.STILEntry stilEntry = (STIL.STILEntry)this.getValue();
            for (STIL.TuneEntry tuneEntry : stilEntry.subtunes) {
                children.add(new TuneEntryTreeItem(tuneEntry));
            }
            super.getChildren().setAll(children);
        }
        return super.getChildren();
    }
}

