/*
 * Decompiled with CFR 0.152.
 */
package ui.sidreg;

import java.util.ResourceBundle;
import libsidplay.common.SIDListener;
import ui.sidreg.SidRegWrite;

public abstract class SidRegExtension
implements SIDListener {
    private ResourceBundle bundle;
    private final String[] description = new String[]{"VOICE_1_FREQ_L", "VOICE_1_FREQ_H", "VOICE_1_PULSE_L", "VOICE_1_PULSE_H", "VOICE_1_CTRL", "VOICE_1_AD", "VOICE_1_SR", "VOICE_2_FREQ_L", "VOICE_2_FREQ_H", "VOICE_2_PULSE_L", "VOICE_2_PULSE_H", "VOICE_2_CTRL", "VOICE_2_AD", "VOICE_2_SR", "VOICE_3_FREQ_L", "VOICE_3_FREQ_H", "VOICE_3_PULSE_L", "VOICE_3_PULSE_H", "VOICE_3_CTRL", "VOICE_3_AD", "VOICE_3_SR", "FCUT_L", "FCUT_H", "FRES", "FVOL", "PADDLE1", "PADDLE2", "OSC3", "ENV3"};
    private long fTime;

    public void setbundle(ResourceBundle l) {
        this.bundle = l;
    }

    @Override
    public void write(long time, int addr, byte data) {
        if (this.fTime == 0L) {
            this.fTime = time;
        }
        long relTime = time - this.fTime;
        SidRegWrite row = new SidRegWrite(time, relTime, addr & 0xFFE0, this.bundle.getString(this.description[addr & 0xF]), String.format("$%02X", data & 0xFF));
        this.sidWrite(row);
        this.fTime = time;
    }

    public void init() {
        this.clear();
        this.fTime = 0L;
    }

    public abstract void clear();

    public abstract void sidWrite(SidRegWrite var1);
}

