/*
 * Decompiled with CFR 0.152.
 */
package ui.siddump;

import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import javafx.collections.ObservableList;
import libsidplay.config.IConfig;
import libsidutils.siddump.SIDDumpConfiguration;
import netsiddev.AudioGeneratorThread;
import netsiddev.InvalidCommandException;
import netsiddev.SIDWrite;
import resid_builder.resid.SID;
import sidplay.audio.AudioConfig;
import ui.siddump.SidDumpOutput;

public class SidDumpReplayer {
    private static final int SID_WRITE_DELAY = 6;
    private static final String[] FILTER_NAME = new String[]{"Off", "Low", "Bnd", "L+B", "Hi ", "L+H", "B+H", "LBH"};
    private boolean fAborted;
    private Collection<SIDDumpConfiguration.SIDDumpReg> fRegOrder;
    private int fReplayFreq = 50;
    private float leftVolume;
    private IConfig cfg;
    private AudioGeneratorThread agt;

    public SidDumpReplayer(IConfig cfg) {
        this.cfg = cfg;
    }

    public void setRegOrder(Collection<SIDDumpConfiguration.SIDDumpReg> collection) {
        this.fRegOrder = collection;
    }

    public void setReplayFrequency(int freq) {
        this.fReplayFreq = freq;
    }

    public void setLeftVolume(float f) {
        this.leftVolume = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(ObservableList<SidDumpOutput> sidDumpOutputs) throws InvalidCommandException {
        if (this.fRegOrder == null) {
            return;
        }
        SID sid = new SID();
        this.agt = new AudioGeneratorThread(AudioConfig.getInstance(this.cfg.getAudioSection()));
        this.agt.setSidArray(new SID[]{sid});
        this.agt.setLevelAdjustment(0, this.decibelsToCentibels());
        BlockingQueue<SIDWrite> queue = this.agt.getSidCommandQueue();
        this.agt.start();
        try {
            byte volume = 15;
            for (int rown = 0; rown < sidDumpOutputs.size(); ++rown) {
                SidDumpOutput row = (SidDumpOutput)sidDumpOutputs.get(rown);
                String firstCol = row.getTime();
                if (firstCol.startsWith("=") || firstCol.startsWith("-")) continue;
                Vector<SidDumpOutput> examineRows = new Vector<SidDumpOutput>();
                for (int i = 0; i < 20; ++i) {
                    examineRows.add(row);
                }
                int cmd = 0;
                long time = 0L;
                for (SIDDumpConfiguration.SIDDumpReg aFRegOrder : this.fRegOrder) {
                    byte register = aFRegOrder.getRegister();
                    switch (aFRegOrder) {
                        case ATTACK_DECAY_1: 
                        case SUSTAIN_RELEASE_1: 
                        case ATTACK_DECAY_2: 
                        case SUSTAIN_RELEASE_2: 
                        case ATTACK_DECAY_3: 
                        case SUSTAIN_RELEASE_3: {
                            int coln = register / 7 * 5 + 4;
                            String col = this.getColumnValue((SidDumpOutput)examineRows.get(coln), coln);
                            if (col.startsWith(".")) break;
                            int adsr = Integer.valueOf(col, 16);
                            if ((register + 2) % 7 == 0) {
                                queue.put(new SIDWrite(0, register, (byte)(adsr >> 8), 6));
                            } else {
                                queue.put(new SIDWrite(0, register, (byte)(adsr & 0xFF), 6));
                            }
                            ++cmd;
                            break;
                        }
                        case FREQ_LO_1: 
                        case FREQ_HI_1: 
                        case FREQ_LO_2: 
                        case FREQ_HI_2: 
                        case FREQ_HI_3: 
                        case FREQ_LO_3: {
                            int coln = register / 7 * 5 + 1;
                            String col = this.getColumnValue((SidDumpOutput)examineRows.get(coln), coln);
                            if (col.startsWith(".")) break;
                            int freq = Integer.valueOf(col, 16);
                            if (register % 7 == 0) {
                                queue.put(new SIDWrite(0, register, (byte)freq, 6));
                            } else {
                                queue.put(new SIDWrite(0, register, (byte)(freq >> 8), 6));
                            }
                            ++cmd;
                            break;
                        }
                        case PULSE_LO_1: 
                        case PULSE_HI_1: 
                        case PULSE_LO_2: 
                        case PULSE_HI_2: 
                        case PULSE_LO_3: 
                        case PULSE_HI_3: {
                            int coln = register / 7 * 5 + 5;
                            String col = this.getColumnValue((SidDumpOutput)examineRows.get(coln), coln);
                            if (col.startsWith(".")) break;
                            int pulse = Integer.valueOf(col.trim(), 16);
                            if ((register + 5) % 7 == 0) {
                                queue.put(new SIDWrite(0, register, (byte)pulse, 6));
                            } else {
                                queue.put(new SIDWrite(0, register, (byte)(pulse >> 8), 6));
                            }
                            ++cmd;
                            break;
                        }
                        case WAVEFORM_1: 
                        case WAVEFORM_2: 
                        case WAVEFORM_3: {
                            int coln = register / 7 * 5 + 3;
                            String col = this.getColumnValue((SidDumpOutput)examineRows.get(coln), coln);
                            if (col.startsWith(".")) break;
                            int wf = Integer.valueOf(col.trim(), 16);
                            queue.put(new SIDWrite(0, register, (byte)wf, 6));
                            ++cmd;
                            break;
                        }
                        case FILTERFREQ_LO: 
                        case FILTERFREQ_HI: {
                            int coln = 16;
                            String col = this.getColumnValue((SidDumpOutput)examineRows.get(coln), coln);
                            if (col.startsWith(".")) break;
                            int fcut = Integer.valueOf(col.trim(), 16);
                            if (aFRegOrder == SIDDumpConfiguration.SIDDumpReg.FILTERFREQ_LO) {
                                queue.put(new SIDWrite(0, register, (byte)(fcut >> 5 & 7), 6));
                            } else {
                                queue.put(new SIDWrite(0, register, (byte)(fcut >> 8), 6));
                            }
                            ++cmd;
                            break;
                        }
                        case FILTERCTRL: {
                            int coln = 17;
                            String col = this.getColumnValue((SidDumpOutput)examineRows.get(coln), coln);
                            if (col.startsWith(".")) break;
                            int typ = Integer.valueOf(col.trim(), 16);
                            queue.put(new SIDWrite(0, register, (byte)typ, 6));
                            ++cmd;
                            break;
                        }
                        case VOL: {
                            int coln = 18;
                            String colFilt = this.getColumnValue((SidDumpOutput)examineRows.get(coln), coln);
                            coln = 19;
                            String colMast = this.getColumnValue((SidDumpOutput)examineRows.get(coln), coln);
                            if (colFilt.startsWith(".") && colMast.startsWith(".")) break;
                            if (!colMast.startsWith(".")) {
                                volume = (byte)(volume & 0xF0 | Integer.parseInt(colMast, 16));
                            }
                            if (!colFilt.startsWith(".")) {
                                String cmp = colFilt.trim();
                                for (int j = 0; j < FILTER_NAME.length; ++j) {
                                    if (!FILTER_NAME[j].equals(cmp)) continue;
                                    volume = (byte)(j << 4 | volume & 0xF);
                                    break;
                                }
                            }
                            queue.put(new SIDWrite(0, register, volume, 6));
                            ++cmd;
                            break;
                        }
                    }
                }
                queue.put(SIDWrite.makePureDelay(0, 1000000 / this.fReplayFreq - cmd * 6));
                time += (long)(1000000 / this.fReplayFreq);
                while (this.agt.getPlaybackClock() < time - 100000L) {
                    this.agt.ensureDraining();
                    Thread.sleep(10L);
                }
                if (!this.fAborted) continue;
                throw new InterruptedException();
            }
            queue.put(SIDWrite.makeEnd());
            do {
                this.agt.ensureDraining();
                this.agt.join(1000L);
            } while (this.agt.isAlive());
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.agt.interrupt();
            this.fAborted = false;
        }
    }

    private String getColumnValue(SidDumpOutput row, int coli) {
        switch (coli) {
            case 0: {
                return row.getTime();
            }
            case 1: {
                return row.getFreq(0);
            }
            case 2: {
                return row.getNote(0);
            }
            case 3: {
                return row.getWf(0);
            }
            case 4: {
                return row.getAdsr(0);
            }
            case 5: {
                return row.getPul(0);
            }
            case 6: {
                return row.getFreq(1);
            }
            case 7: {
                return row.getNote(1);
            }
            case 8: {
                return row.getWf(1);
            }
            case 9: {
                return row.getAdsr(1);
            }
            case 10: {
                return row.getPul(1);
            }
            case 11: {
                return row.getFreq(2);
            }
            case 12: {
                return row.getNote(2);
            }
            case 13: {
                return row.getWf(2);
            }
            case 14: {
                return row.getAdsr(2);
            }
            case 15: {
                return row.getPul(2);
            }
            case 16: {
                return row.getFcut();
            }
            case 17: {
                return row.getRc();
            }
            case 18: {
                return row.getTyp();
            }
            case 19: {
                return row.getV();
            }
        }
        return null;
    }

    private int decibelsToCentibels() {
        return (int)this.leftVolume * 10;
    }

    public void stopReplay() {
        try {
            while (this.agt != null && this.agt.isAlive()) {
                this.fAborted = true;
                BlockingQueue<SIDWrite> queue = this.agt.getSidCommandQueue();
                queue.clear();
                queue.put(SIDWrite.makeEnd());
                do {
                    this.agt.ensureDraining();
                    this.agt.join(1000L);
                } while (this.agt.isAlive());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

