/*
 * Decompiled with CFR 0.152.
 */
package ui.siddump;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Scanner;
import java.util.regex.MatchResult;
import javafx.collections.ObservableList;
import libsidplay.common.SIDEmu;
import libsidplay.components.mos6510.IMOS6510Extension;
import libsidutils.siddump.SIDDumpConfiguration;
import netsiddev.InvalidCommandException;
import sidplay.Player;
import ui.entities.config.Configuration;
import ui.siddump.SidDumpOutput;
import ui.siddump.SidDumpReplayer;

public abstract class SidDumpExtension
implements IMOS6510Extension {
    private static final String[] NOTE_NAME = new String[]{"C-0", "C#0", "D-0", "D#0", "E-0", "F-0", "F#0", "G-0", "G#0", "A-0", "A#0", "B-0", "C-1", "C#1", "D-1", "D#1", "E-1", "F-1", "F#1", "G-1", "G#1", "A-1", "A#1", "B-1", "C-2", "C#2", "D-2", "D#2", "E-2", "F-2", "F#2", "G-2", "G#2", "A-2", "A#2", "B-2", "C-3", "C#3", "D-3", "D#3", "E-3", "F-3", "F#3", "G-3", "G#3", "A-3", "A#3", "B-3", "C-4", "C#4", "D-4", "D#4", "E-4", "F-4", "F#4", "G-4", "G#4", "A-4", "A#4", "B-4", "C-5", "C#5", "D-5", "D#5", "E-5", "F-5", "F#5", "G-5", "G#5", "A-5", "A#5", "B-5", "C-6", "C#6", "D-6", "D#6", "E-6", "F-6", "F#6", "G-6", "G#6", "A-6", "A#6", "B-6", "C-7", "C#7", "D-7", "D#7", "E-7", "F-7", "F#7", "G-7", "G#7", "A-7", "A#7", "B-7"};
    private static final String[] FILTER_NAME = new String[]{"Off", "Low", "Bnd", "L+B", "Hi ", "L+H", "B+H", "LBH"};
    private static final char[] FREQ_TBL_LO = new char[]{'\u0017', '\'', '9', 'K', '_', 't', '\u008a', '\u00a1', '\u00ba', '\u00d4', '\u00f0', '\u000e', '-', 'N', 'q', '\u0096', '\u00be', '\u00e8', '\u0014', 'C', 't', '\u00a9', '\u00e1', '\u001c', 'Z', '\u009c', '\u00e2', '-', '|', '\u00cf', '(', '\u0085', '\u00e8', 'R', '\u00c1', '7', '\u00b4', '9', '\u00c5', 'Z', '\u00f7', '\u009e', 'O', '\n', '\u00d1', '\u00a3', '\u0082', 'n', 'h', 'q', '\u008a', '\u00b3', '\u00ee', '<', '\u009e', '\u0015', '\u00a2', 'F', '\u0004', '\u00dc', '\u00d0', '\u00e2', '\u0014', 'g', '\u00dd', 'y', '<', ')', 'D', '\u008d', '\b', '\u00b8', '\u00a1', '\u00c5', '(', '\u00cd', '\u00ba', '\u00f1', 'x', 'S', '\u0087', '\u001a', '\u0010', 'q', 'B', '\u0089', 'O', '\u009b', 't', '\u00e2', '\u00f0', '\u00a6', '\u000e', '3', ' ', '\u00ff'};
    private static final char[] FREQ_TBL_HI = new char[]{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0002', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0004', '\u0004', '\u0004', '\u0004', '\u0005', '\u0005', '\u0005', '\u0006', '\u0006', '\u0006', '\u0007', '\u0007', '\b', '\b', '\t', '\t', '\n', '\n', '\u000b', '\f', '\r', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0017', '\u0018', '\u001a', '\u001b', '\u001d', '\u001f', ' ', '\"', '$', '\'', ')', '+', '.', '1', '4', '7', ':', '>', 'A', 'E', 'I', 'N', 'R', 'W', '\\', 'b', 'h', 'n', 'u', '|', '\u0083', '\u008b', '\u0093', '\u009c', '\u00a5', '\u00af', '\u00b9', '\u00c4', '\u00d0', '\u00dd', '\u00ea', '\u00f8', '\u00ff'};
    private static final char[] FREQ_TBL_LO_USE = new char[FREQ_TBL_LO.length];
    private static final char[] FREQ_TBL_HI_USE = new char[FREQ_TBL_HI.length];
    private static final int TUNE_SPEED = 50;
    private final Channel[] fChannel = new Channel[3];
    private final Channel[] fPrevChannel = new Channel[3];
    private final Channel[] fPrevChannel2 = new Channel[3];
    private Player player;
    private SIDEmu fSid;
    private Filter fFilter;
    private Filter fPrevFilter;
    private int fLoadAddress;
    private int fInitAddress;
    private int fPlayerAddress;
    private int fCurrentSong;
    private int fSeconds;
    private long fFrames;
    private long fFirstframe;
    private float fOldNoteFactor = 1.0f;
    private int fBaseFreq = 0;
    private int fBaseNote = 176;
    private boolean fLowRes = false;
    private int fNoteSpacing = 0;
    private int fPatternSpacing = 0;
    private boolean fTimeInSeconds = true;
    private boolean fFirstTime;
    private int fCounter;
    private int fRows;
    private Collection<SIDDumpConfiguration.SIDDumpReg> fRegOrder = null;
    private int fReplayFreq = 50;
    private int fFetchedRow;
    private int fPatternNum;
    private int fNoteNum;
    private float leftVolume;
    private SidDumpReplayer replayer;

    private String getTime(long time, boolean timeInSeconds) {
        if (!timeInSeconds) {
            return String.format("%5d", time);
        }
        return String.format("%01d:%02d.%02d", time / 3000L, time / 50L % 60L, time % 50L);
    }

    public SidDumpExtension(Player pl, Configuration cfg) {
        this.player = pl;
    }

    public int getLoadAddress() {
        return this.fLoadAddress;
    }

    public void setLoadAddress(int loadAddr) {
        this.fLoadAddress = loadAddr;
    }

    public int getInitAddress() {
        return this.fInitAddress;
    }

    public void setInitAddress(int initAddr) {
        this.fInitAddress = initAddr;
    }

    public int getPlayerAddress() {
        return this.fPlayerAddress;
    }

    public void setPayerAddress(int playAddr) {
        this.fPlayerAddress = playAddr;
    }

    public int getCurrentSong() {
        return this.fCurrentSong;
    }

    public void setCurrentSong(int currentSong) {
        this.fCurrentSong = currentSong;
    }

    public long getFirstFrame() {
        return this.fFirstframe;
    }

    public void setFirstFrame(long firstFrame) {
        this.fFirstframe = firstFrame;
    }

    public void setRecordLength(int seconds) {
        this.fSeconds = seconds;
    }

    public boolean getTimeInSeconds() {
        return this.fTimeInSeconds;
    }

    public void setTimeInSeconds(boolean selected) {
        this.fTimeInSeconds = selected;
    }

    public void setOldNoteFactor(float oldNoteFactor) {
        this.fOldNoteFactor = oldNoteFactor;
    }

    public void setBaseFreq(int baseFreq) {
        this.fBaseFreq = baseFreq;
    }

    public void setBaseNote(int baseNote) {
        this.fBaseNote = baseNote;
    }

    public int getPatternSpacing() {
        return this.fPatternSpacing;
    }

    public void setPatternSpacing(int patternSpacing) {
        this.fPatternSpacing = patternSpacing;
    }

    public int getNoteSpacing() {
        return this.fNoteSpacing;
    }

    public void setNoteSpacing(int noteSpacing) {
        this.fNoteSpacing = noteSpacing;
    }

    public void setLowRes(boolean lowResolution) {
        this.fLowRes = lowResolution;
    }

    public boolean getLowRes() {
        return this.fLowRes;
    }

    public void setRegOrder(Collection<SIDDumpConfiguration.SIDDumpReg> collection) {
        this.fRegOrder = collection;
    }

    public void setReplayFrequency(int freq) {
        this.fReplayFreq = freq;
    }

    public void setLeftVolume(float f) {
        this.leftVolume = f;
    }

    public void init() {
        this.clear();
        this.clearChannelStructures();
        this.recalibrateFreqTable();
        this.fFirstTime = true;
        this.fFetchedRow = 0;
        this.fPatternNum = 1;
        this.fNoteNum = 1;
        this.player.configureSID(0, sid -> {
            this.fSid = sid;
        });
    }

    private void clearChannelStructures() {
        for (int ch = 0; ch < 3; ++ch) {
            this.fChannel[ch] = new Channel();
            this.fPrevChannel[ch] = new Channel();
            this.fPrevChannel2[ch] = new Channel();
        }
        this.fFilter = new Filter();
        this.fPrevFilter = new Filter();
        this.fFrames = 0L;
        this.fCounter = 0;
        this.fRows = 0;
        if (this.fLowRes && 0 == this.fNoteSpacing) {
            this.fLowRes = false;
        }
    }

    private void recalibrateFreqTable() {
        System.arraycopy(FREQ_TBL_LO, 0, FREQ_TBL_LO_USE, 0, FREQ_TBL_LO.length);
        System.arraycopy(FREQ_TBL_HI, 0, FREQ_TBL_HI_USE, 0, FREQ_TBL_HI.length);
        if (this.fBaseFreq != 0) {
            this.fBaseNote &= 0x7F;
            if (this.fBaseNote < 0 || this.fBaseNote > 96) {
                System.err.println("Warning: Calibration note out of range. Aborting recalibration.");
            } else {
                for (int c = 0; c < 96; ++c) {
                    double note = c - this.fBaseNote;
                    double freq = (double)this.fBaseFreq * Math.pow(2.0, note / 12.0);
                    int f = (int)freq;
                    if (freq > 65535.0) {
                        freq = 65535.0;
                    }
                    SidDumpExtension.FREQ_TBL_LO_USE[c] = (char)(f & 0xFF);
                    SidDumpExtension.FREQ_TBL_HI_USE[c] = (char)(f >> 8);
                }
            }
        }
    }

    @Override
    public void fetch(long cpuTime) {
        if (this.fFirstTime) {
            this.fFirstTime = false;
            return;
        }
        if (this.fSid == null) {
            return;
        }
        if (this.fFrames < this.fFirstframe + (long)(this.fSeconds * 50)) {
            for (int channel = 0; channel < 3; ++channel) {
                this.fChannel[channel].read(this.fSid, channel);
            }
            this.fFilter.read(this.fSid);
            if (this.fFrames >= this.fFirstframe) {
                int channel;
                SidDumpOutput output = new SidDumpOutput();
                long time = this.fFrames - this.fFirstframe;
                output.setTime(this.getTime(time, this.fTimeInSeconds));
                for (int c = 0; c < 3; ++c) {
                    boolean newnote = false;
                    if (this.fChannel[c].wave >= 16 && 0 != (this.fChannel[c].wave & 1) && (0 == (this.fPrevChannel2[c].wave & 1) || this.fPrevChannel2[c].wave < 16)) {
                        this.fPrevChannel[c].note = -1;
                    }
                    if (this.fFrames == this.fFirstframe || this.fPrevChannel[c].note == -1 || this.fChannel[c].freq != this.fPrevChannel[c].freq) {
                        int dist = Integer.MAX_VALUE;
                        int delta = this.fChannel[c].freq - this.fPrevChannel2[c].freq;
                        output.setFreq(this.fChannel[c].getFreq(), c);
                        if (this.fChannel[c].wave >= 16) {
                            for (int d = 0; d < 96; ++d) {
                                int cmpfreq = FREQ_TBL_LO_USE[d] | FREQ_TBL_HI_USE[d] << 8;
                                int freq = this.fChannel[c].freq;
                                if (Math.abs(freq - cmpfreq) >= dist) continue;
                                dist = Math.abs(freq - cmpfreq);
                                if (d == this.fPrevChannel[c].note) {
                                    dist = (int)((float)dist / this.fOldNoteFactor);
                                }
                                this.fChannel[c].note = d;
                            }
                            if (this.fChannel[c].note != this.fPrevChannel[c].note) {
                                if (this.fPrevChannel[c].note == -1) {
                                    if (this.fLowRes) {
                                        newnote = true;
                                    }
                                    output.setNote(this.fChannel[c].getNote(false), c);
                                } else {
                                    output.setNote(this.fChannel[c].getNote(true), c);
                                }
                            } else if (delta != 0) {
                                if (delta > 0) {
                                    output.setNote(String.format("(+ %04X)", delta), c);
                                } else {
                                    output.setNote(String.format("(- %04X)", -delta), c);
                                }
                            } else {
                                output.setNote(" ... .. ", c);
                            }
                        } else {
                            output.setNote(" ... .. ", c);
                        }
                    } else {
                        output.setFreq("....", c);
                        output.setNote(" ... .. ", c);
                    }
                    if (this.fFrames == this.fFirstframe || newnote || this.fChannel[c].wave != this.fPrevChannel[c].wave) {
                        output.setWf(this.fChannel[c].getWf(), c);
                    } else {
                        output.setWf("..", c);
                    }
                    if (this.fFrames == this.fFirstframe || newnote || this.fChannel[c].adsr != this.fPrevChannel[c].adsr) {
                        output.setAdsr(this.fChannel[c].getADSR(), c);
                    } else {
                        output.setAdsr("....", c);
                    }
                    if (this.fFrames == this.fFirstframe || newnote || this.fChannel[c].pulse != this.fPrevChannel[c].pulse) {
                        output.setPul(this.fChannel[c].getPul(), c);
                        continue;
                    }
                    output.setPul("...", c);
                }
                if (this.fFrames == this.fFirstframe || this.fFilter.cutoff != this.fPrevFilter.cutoff) {
                    output.setFcut(this.fFilter.getCutoff());
                } else {
                    output.setFcut("....");
                }
                if (this.fFrames == this.fFirstframe || this.fFilter.ctrl != this.fPrevFilter.ctrl) {
                    output.setRc(this.fFilter.getCtrl());
                } else {
                    output.setRc("..");
                }
                if (this.fFrames == this.fFirstframe || (this.fFilter.type & 0x70) != (this.fPrevFilter.type & 0x70)) {
                    output.setTyp(this.fFilter.getTyp());
                } else {
                    output.setTyp("...");
                }
                if (this.fFrames == this.fFirstframe || (this.fFilter.type & 0xF) != (this.fPrevFilter.type & 0xF)) {
                    output.setV(this.fFilter.getV());
                } else {
                    output.setV(".");
                }
                if (!this.fLowRes || 0L == (this.fFrames - this.fFirstframe) % (long)this.fNoteSpacing) {
                    ++this.fFetchedRow;
                    this.add(output);
                    for (channel = 0; channel < 3; ++channel) {
                        this.fPrevChannel[channel].assign(this.fChannel[channel]);
                    }
                    this.fPrevFilter.assign(this.fFilter);
                }
                for (channel = 0; channel < 3; ++channel) {
                    this.fPrevChannel2[channel].assign(this.fChannel[channel]);
                }
                if (this.fNoteSpacing != 0) {
                    ++this.fCounter;
                    if (this.fCounter >= this.fNoteSpacing) {
                        this.fCounter = 0;
                        if (this.fPatternSpacing != 0) {
                            ++this.fRows;
                            if (this.fRows >= this.fPatternSpacing) {
                                this.fRows = 0;
                                this.addPatternSpacing();
                            } else if (!this.fLowRes) {
                                this.addNoteSpacing();
                            }
                        } else if (!this.fLowRes) {
                            this.addNoteSpacing();
                        }
                    }
                }
            }
        }
        ++this.fFrames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(String filename) {
        this.clear();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));){
            block47: for (int i = 0; i < 7; ++i) {
                String lineContents = br.readLine();
                if (lineContents == null) {
                    System.err.println("unexpected end of file!");
                    return;
                }
                switch (i) {
                    case 0: {
                        String group;
                        int j;
                        Scanner sc = new Scanner(lineContents);
                        sc.useDelimiter("\n");
                        sc.findInLine("Load address: \\$(\\p{XDigit}+) Init address: \\$(\\p{XDigit}+) Play address: \\$(\\p{XDigit}+)");
                        MatchResult result = sc.match();
                        block48: for (j = 0; j < result.groupCount(); ++j) {
                            group = result.group(j + 1);
                            switch (j) {
                                case 0: {
                                    this.fLoadAddress = this.readNumber(group, 16);
                                    continue block48;
                                }
                                case 1: {
                                    this.fInitAddress = this.readNumber(group, 16);
                                    continue block48;
                                }
                                case 2: {
                                    this.fPlayerAddress = this.readNumber(group, 16);
                                    continue block48;
                                }
                            }
                        }
                        continue block47;
                    }
                    case 1: {
                        String group;
                        int j;
                        Scanner sc = new Scanner(lineContents);
                        sc.useDelimiter("\n");
                        sc.findInLine("Calling initroutine with subtune (\\d+)");
                        MatchResult result = sc.match();
                        block49: for (j = 0; j < result.groupCount(); ++j) {
                            group = result.group(j + 1);
                            switch (j) {
                                case 0: {
                                    this.fCurrentSong = this.readNumber(group, 10) + 1;
                                    continue block49;
                                }
                            }
                        }
                        continue block47;
                    }
                    case 2: {
                        String group;
                        int j;
                        Scanner sc = new Scanner(lineContents);
                        sc.useDelimiter("\n");
                        sc.findInLine("Calling playroutine for (\\d+) frames\\, starting from frame (\\d+)");
                        MatchResult result = sc.match();
                        block50: for (j = 0; j < result.groupCount(); ++j) {
                            group = result.group(j + 1);
                            switch (j) {
                                case 0: {
                                    continue block50;
                                }
                                case 1: {
                                    this.fFirstframe = this.readNumber(group, 10);
                                    continue block50;
                                }
                            }
                        }
                        continue block47;
                    }
                    case 3: {
                        int j;
                        Scanner sc = new Scanner(lineContents);
                        sc.useDelimiter("\n");
                        sc.findInLine("Middle C frequency is \\$(\\d+)");
                        MatchResult result = sc.match();
                        for (j = 0; j < result.groupCount(); ++j) {
                        }
                        continue block47;
                    }
                }
            }
            try (Scanner sc = new Scanner(br);){
                sc.useDelimiter(" ?\\| ?");
                this.fNoteSpacing = 0;
                this.fPatternSpacing = 0;
                this.fLowRes = false;
                this.fFetchedRow = 0;
                this.fPatternNum = 1;
                this.fNoteNum = 1;
                int lastFrame = 0;
                block52: do {
                    String next;
                    SidDumpOutput output = new SidDumpOutput();
                    int col = 0;
                    while (sc.hasNext() && (next = sc.next()).trim().length() != 0) {
                        switch (col) {
                            case 0: {
                                int lowresdist;
                                if (next.startsWith("-") || next.startsWith("=")) {
                                    output.setTime(next);
                                    break;
                                }
                                lastFrame = Integer.parseInt(next.trim());
                                if (this.fFetchedRow == 1 && (lowresdist = lastFrame) != 1) {
                                    this.fLowRes = true;
                                    this.fNoteSpacing = lowresdist;
                                }
                                output.setTime(next);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                output.setFreq(next.substring(0, 4), col - 1);
                                output.setNote(next.substring(5, 13), col - 1);
                                output.setWf(next.substring(14, 16), col - 1);
                                output.setAdsr(next.substring(17, 21), col - 1);
                                output.setPul(next.substring(22, 25), col - 1);
                                break;
                            }
                            case 4: {
                                output.setFcut(next.substring(0, 4));
                                output.setRc(next.substring(5, 7));
                                output.setTyp(next.substring(8, 11));
                                output.setV(next.substring(12, 13));
                                break;
                            }
                            case 5: {
                                this.add(output);
                                if (next.trim().startsWith("+=")) {
                                    if (this.fPatternSpacing == 0) {
                                        int nextFrame = lastFrame + this.fNoteSpacing;
                                        this.fPatternSpacing = nextFrame / this.fNoteSpacing;
                                    }
                                    this.addPatternSpacing();
                                    continue block52;
                                }
                                if (!next.trim().startsWith("+-")) continue block52;
                                if (this.fNoteSpacing == 0 && !this.fLowRes) {
                                    this.fNoteSpacing = this.fFetchedRow;
                                }
                                this.addNoteSpacing();
                                continue block52;
                            }
                        }
                        ++col;
                    }
                    this.add(output);
                } while (sc.hasNext());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.stopRecording();
    }

    private int readNumber(String number, int radix) {
        try {
            return Integer.parseInt(number, radix);
        }
        catch (NumberFormatException e) {
            System.err.println(e.getMessage());
            return 0;
        }
    }

    private void addNoteSpacing() {
        SidDumpOutput noteSep = new SidDumpOutput();
        noteSep.setTime(String.format("-N%03X", this.fNoteNum++));
        for (int c = 0; c < 3; ++c) {
            noteSep.setFreq("----", c);
            noteSep.setNote("--------", c);
            noteSep.setWf("--", c);
            noteSep.setAdsr("----", c);
            noteSep.setPul("---", c);
        }
        noteSep.setFcut("----");
        noteSep.setRc("--");
        noteSep.setTyp("---");
        noteSep.setV("-");
        this.add(noteSep);
    }

    private void addPatternSpacing() {
        this.fNoteNum = 1;
        SidDumpOutput patternSep = new SidDumpOutput();
        patternSep.setTime(String.format("=P%03X", this.fPatternNum++));
        for (int c = 0; c < 3; ++c) {
            patternSep.setFreq("====", c);
            patternSep.setNote("========", c);
            patternSep.setWf("==", c);
            patternSep.setAdsr("====", c);
            patternSep.setPul("===", c);
        }
        patternSep.setFcut("====");
        patternSep.setRc("==");
        patternSep.setTyp("===");
        patternSep.setV("=");
        this.add(patternSep);
    }

    public void save(String filename, ObservableList<SidDumpOutput> sidDumpOutputs) {
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(filename)));){
            out.println(String.format("Load address: $%04X Init address: $%04X Play address: $%04X", this.fLoadAddress, this.fInitAddress, this.fPlayerAddress));
            out.println("Calling initroutine with subtune " + (this.fCurrentSong - 1));
            out.println("Calling playroutine for " + this.fSeconds * 50 + " frames, starting from frame " + this.fFirstframe);
            out.println(String.format("Middle C frequency is $%04X", FREQ_TBL_LO_USE[48] | FREQ_TBL_HI_USE[48] << 8));
            out.println();
            out.println("| Frame | Freq Note/Abs WF ADSR Pul | Freq Note/Abs WF ADSR Pul | Freq Note/Abs WF ADSR Pul | FCut RC Typ V |");
            out.println("+-------+---------------------------+---------------------------+---------------------------+---------------+");
            for (SidDumpOutput putput : sidDumpOutputs) {
                out.print("| ");
                out.print(putput.getTime());
                out.print(" | ");
                out.print(putput.getFreq(0));
                out.print(" ");
                out.print(putput.getNote(0));
                out.print(" ");
                out.print(putput.getWf(0));
                out.print(" ");
                out.print(putput.getAdsr(0));
                out.print(" ");
                out.print(putput.getPul(0));
                out.print(" | ");
                out.print(putput.getFreq(1));
                out.print(" ");
                out.print(putput.getNote(1));
                out.print(" ");
                out.print(putput.getWf(1));
                out.print(" ");
                out.print(putput.getAdsr(1));
                out.print(" ");
                out.print(putput.getPul(1));
                out.print(" | ");
                out.print(putput.getFreq(2));
                out.print(" ");
                out.print(putput.getNote(2));
                out.print(" ");
                out.print(putput.getWf(2));
                out.print(" ");
                out.print(putput.getAdsr(2));
                out.print(" ");
                out.print(putput.getPul(2));
                out.print(" | ");
                out.print(putput.getFcut());
                out.print(" ");
                out.print(putput.getRc());
                out.print(" ");
                out.print(putput.getTyp());
                out.print(" ");
                out.print(putput.getV());
                out.println(" |");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void stopRecording() {
        this.fFrames = this.fFirstframe + (long)(this.fSeconds * 50);
    }

    public void replay(ObservableList<SidDumpOutput> sidDumpOutputs) throws InvalidCommandException {
        this.replayer = new SidDumpReplayer(this.player.getConfig());
        this.replayer.setLeftVolume(this.leftVolume);
        this.replayer.setRegOrder(this.fRegOrder);
        this.replayer.setReplayFrequency(this.fReplayFreq);
        this.replayer.replay(sidDumpOutputs);
    }

    public void stopReplay() {
        this.replayer.stopReplay();
    }

    public abstract void clear();

    public abstract void add(SidDumpOutput var1);

    protected static class Filter {
        private int cutoff;
        private int ctrl;
        private int type;

        protected Filter() {
        }

        public void read(SIDEmu fSid) {
            this.cutoff = (fSid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.FILTERFREQ_LO.getRegister()) & 0xFF) << 5 | (fSid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.FILTERFREQ_HI.getRegister()) & 0xFF) << 8;
            this.ctrl = fSid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.FILTERCTRL.getRegister()) & 0xFF;
            this.type = fSid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.VOL.getRegister()) & 0xFF;
        }

        public void assign(Filter filter) {
            this.ctrl = filter.ctrl;
            this.cutoff = filter.cutoff;
            this.type = filter.type;
        }

        public String getCutoff() {
            return String.format("%04X", this.cutoff);
        }

        public String getCtrl() {
            return String.format("%02X", this.ctrl);
        }

        public String getTyp() {
            return FILTER_NAME[this.type >> 4 & 7];
        }

        public String getV() {
            return String.format("%01X", this.type & 0xF);
        }
    }

    protected static class Channel {
        private int freq;
        private int pulse;
        private int adsr;
        private int wave;
        private int note;

        protected Channel() {
        }

        public void read(SIDEmu sid, int channel) {
            this.freq = sid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.FREQ_LO_1.getRegister() + 7 * channel) & 0xFF | (sid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.FREQ_HI_1.getRegister() + 7 * channel) & 0xFF) << 8;
            this.pulse = (sid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.PULSE_LO_1.getRegister() + 7 * channel) & 0xFF | (sid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.PULSE_HI_1.getRegister() + 7 * channel) & 0xFF) << 8) & 0xFFF;
            this.wave = sid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.WAVEFORM_1.getRegister() + 7 * channel) & 0xFF;
            this.adsr = sid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.SUSTAIN_RELEASE_1.getRegister() + 7 * channel) & 0xFF | (sid.readInternalRegister(SIDDumpConfiguration.SIDDumpReg.ATTACK_DECAY_1.getRegister() + 7 * channel) & 0xFF) << 8;
        }

        public void assign(Channel channel) {
            this.adsr = channel.adsr;
            this.freq = channel.freq;
            this.note = channel.note;
            this.pulse = channel.pulse;
            this.wave = channel.wave;
        }

        public String getFreq() {
            return String.format("%04X", this.freq);
        }

        public String getNote(boolean prevChannelNote) {
            if (prevChannelNote) {
                return String.format("(%s %02X)", NOTE_NAME[this.note], this.note | 0x80);
            }
            return String.format(" %s %02X ", NOTE_NAME[this.note], this.note | 0x80);
        }

        public String getWf() {
            return String.format("%02X", this.wave);
        }

        public String getADSR() {
            return String.format("%04X", this.adsr);
        }

        public String getPul() {
            return String.format("%03X", this.pulse);
        }
    }
}

