/*
 * Decompiled with CFR 0.152.
 */
package ui.siddump;

import java.io.File;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.stage.FileChooser;
import javax.xml.parsers.ParserConfigurationException;
import libsidplay.sidtune.SidTune;
import libsidutils.siddump.SIDDumpConfiguration;
import netsiddev.InvalidCommandException;
import org.xml.sax.SAXException;
import sidplay.Player;
import sidplay.player.State;
import ui.common.C64Window;
import ui.common.TimeToStringConverter;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.siddump.SidDumpExtension;
import ui.siddump.SidDumpOutput;

public class SidDump
extends Tab
implements UIPart {
    public static final String ID = "SIDDUMP";
    private static final String CELL_VALUE_OK = "cellValueOk";
    private static final String CELL_VALUE_ERROR = "cellValueError";
    @FXML
    private Button loadDump;
    @FXML
    private Button saveDump;
    @FXML
    private Button stop;
    @FXML
    protected ToggleButton replayAll;
    @FXML
    protected ToggleButton startStopRecording;
    @FXML
    private CheckBox timeInSeconds;
    @FXML
    private CheckBox lowResolutionMode;
    @FXML
    private TextField firstFrame;
    @FXML
    private TextField noteSpacing;
    @FXML
    private TextField maxRecordLength;
    @FXML
    private TextField patternSpacing;
    @FXML
    private TextField oldNoteFactor;
    @FXML
    private TextField tableFontSize;
    @FXML
    private TextField baseFreq;
    @FXML
    private TextField baseNote;
    @FXML
    private TextField callsPerFrame;
    @FXML
    private ComboBox<SIDDumpConfiguration.SIDDumpPlayer> regPlayer;
    @FXML
    private TableView<SidDumpOutput> dumpTable;
    protected ObservableList<SidDumpOutput> sidDumpOutputs;
    private ObservableList<SIDDumpConfiguration.SIDDumpPlayer> sidDumpPlayers;
    protected SidDumpExtension sidDumpExtension;
    private int loadAddress;
    private int initAddress;
    private int playerAddress;
    private int subTune;
    private int seconds;
    private Thread fPlayerThread;
    private UIUtil util;
    private ChangeListener<State> changeListener = (observable, oldValue, newValue) -> {
        if (newValue == State.START) {
            Platform.runLater(() -> this.setTune(this.util.getPlayer().getTune()));
        }
        if (newValue == State.END) {
            Platform.runLater(() -> {
                this.startStopRecording.setSelected(false);
                this.replayAll.setDisable(false);
                this.sidDumpExtension.stopRecording();
            });
        }
    };

    public SidDump(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
        this.setId(ID);
        this.setText(this.util.getBundle().getString(this.getId()));
    }

    @FXML
    private void initialize() {
        this.sidDumpExtension = new SidDumpExtension(this.util.getPlayer(), this.util.getConfig()){

            @Override
            public void add(SidDumpOutput output) {
                Platform.runLater(() -> SidDump.this.sidDumpOutputs.add((Object)output));
            }

            @Override
            public void clear() {
                Platform.runLater(() -> SidDump.this.sidDumpOutputs.clear());
            }
        };
        this.util.getPlayer().stateProperty().addListener(this.changeListener);
        this.maxRecordLength.textProperty().addListener((obj, o, n) -> {
            Tooltip tooltip = new Tooltip();
            this.maxRecordLength.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            this.seconds = new TimeToStringConverter().fromString(this.maxRecordLength.getText()).intValue();
            if (this.seconds != -1) {
                this.sidDumpExtension.setRecordLength(this.seconds);
                tooltip.setText(this.util.getBundle().getString("MAX_RECORD_LENGTH_TIP"));
                this.maxRecordLength.setTooltip(tooltip);
                this.maxRecordLength.getStyleClass().add((Object)CELL_VALUE_OK);
            } else {
                tooltip.setText(this.util.getBundle().getString("MAX_RECORD_LENGTH_FORMAT"));
                this.maxRecordLength.setTooltip(tooltip);
                this.maxRecordLength.getStyleClass().add((Object)CELL_VALUE_ERROR);
            }
        });
        this.sidDumpOutputs = FXCollections.observableArrayList();
        this.dumpTable.setItems(this.sidDumpOutputs);
        this.sidDumpPlayers = FXCollections.observableArrayList();
        this.regPlayer.setItems(this.sidDumpPlayers);
        try {
            SIDDumpConfiguration sidDump = new SIDDumpConfiguration();
            this.sidDumpPlayers.addAll(sidDump.getPlayers());
            this.regPlayer.getSelectionModel().select(0);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.doSetTableFontSize();
        this.setTune(this.util.getPlayer().getTune());
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.changeListener);
    }

    @FXML
    private void doLoadDump() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        File file = fileDialog.showOpenDialog(this.loadDump.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParent());
            this.sidDumpExtension.load(file.getAbsolutePath());
            this.noteSpacing.setText(String.valueOf(this.sidDumpExtension.getNoteSpacing()));
            this.patternSpacing.setText(String.valueOf(this.sidDumpExtension.getPatternSpacing()));
            this.firstFrame.setText(String.valueOf(this.sidDumpExtension.getFirstFrame()));
            this.lowResolutionMode.setSelected(this.sidDumpExtension.getLowRes());
            this.loadAddress = this.sidDumpExtension.getLoadAddress();
            this.initAddress = this.sidDumpExtension.getInitAddress();
            this.playerAddress = this.sidDumpExtension.getPlayerAddress();
            this.subTune = this.sidDumpExtension.getCurrentSong();
            this.timeInSeconds.setSelected(this.sidDumpExtension.getTimeInSeconds());
        }
    }

    @FXML
    private void doSaveDump() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        File file = fileDialog.showSaveDialog(this.saveDump.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParent());
            this.sidDumpExtension.save(file.getAbsolutePath(), this.sidDumpOutputs);
        }
    }

    @FXML
    private void doReplayAll() {
        try {
            while (this.fPlayerThread != null && this.fPlayerThread.isAlive()) {
                this.sidDumpExtension.stopReplay();
                this.fPlayerThread.join(1000L);
                this.fPlayerThread.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.replayAll.isSelected()) {
            this.fPlayerThread = new Thread(() -> {
                try {
                    this.sidDumpExtension.replay(this.sidDumpOutputs);
                }
                catch (InvalidCommandException e) {
                    e.printStackTrace();
                }
            });
            this.fPlayerThread.start();
        }
    }

    @FXML
    private void doStartStopRecording() {
        if (this.startStopRecording.isSelected()) {
            this.util.setPlayingTab(this);
            this.util.getPlayer().play(this.util.getPlayer().getTune());
            this.setTune(this.util.getPlayer().getTune());
            this.util.getPlayer().getC64().setPlayRoutineObserver(this.sidDumpExtension);
        } else {
            this.util.getPlayer().pauseContinue();
            this.util.getPlayer().getC64().setPlayRoutineObserver(null);
            this.sidDumpExtension.stopRecording();
        }
    }

    @FXML
    private void doSetPlayer() {
        this.sidDumpExtension.setRegOrder(((SIDDumpConfiguration.SIDDumpPlayer)this.regPlayer.getSelectionModel().getSelectedItem()).getRegs());
    }

    @FXML
    private void doSetNoteSpacing() {
        Tooltip tooltip = new Tooltip();
        try {
            this.noteSpacing.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (Integer.parseInt(this.noteSpacing.getText()) < 0) {
                throw new NumberFormatException();
            }
            tooltip.setText(this.util.getBundle().getString("NOTE_SPACING_TIP"));
            this.noteSpacing.setTooltip(tooltip);
            this.noteSpacing.getStyleClass().add((Object)CELL_VALUE_OK);
        }
        catch (NumberFormatException e) {
            tooltip.setText(this.util.getBundle().getString("NOTE_SPACING_NEG"));
            this.noteSpacing.setTooltip(tooltip);
            this.noteSpacing.getStyleClass().add((Object)CELL_VALUE_ERROR);
        }
    }

    @FXML
    private void doSetPatternSpacing() {
        Tooltip tooltip = new Tooltip();
        try {
            this.patternSpacing.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (Integer.parseInt(this.patternSpacing.getText()) < 0) {
                throw new NumberFormatException();
            }
            tooltip.setText(this.util.getBundle().getString("PATTERN_SPACING_TIP"));
            this.patternSpacing.setTooltip(tooltip);
            this.patternSpacing.getStyleClass().add((Object)CELL_VALUE_OK);
        }
        catch (NumberFormatException e) {
            tooltip.setText(this.util.getBundle().getString("PATTERN_SPACING_NEG"));
            this.patternSpacing.setTooltip(tooltip);
            this.patternSpacing.getStyleClass().add((Object)CELL_VALUE_ERROR);
        }
    }

    @FXML
    private void doSetOldNoteFactor() {
        Tooltip tooltip = new Tooltip();
        try {
            this.oldNoteFactor.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (!(Float.parseFloat(this.oldNoteFactor.getText()) >= 1.0f)) {
                throw new NumberFormatException();
            }
            tooltip.setText(this.util.getBundle().getString("OLD_NOTE_FACTOR_TIP"));
            this.oldNoteFactor.setTooltip(tooltip);
            this.oldNoteFactor.getStyleClass().add((Object)CELL_VALUE_OK);
        }
        catch (NumberFormatException e) {
            tooltip.setText(this.util.getBundle().getString("OLD_NOTE_FACTOR_NEG"));
            this.oldNoteFactor.setTooltip(tooltip);
            this.oldNoteFactor.getStyleClass().add((Object)CELL_VALUE_ERROR);
        }
    }

    @FXML
    private void doSetBaseFreq() {
        Tooltip tooltip = new Tooltip();
        try {
            this.baseFreq.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (Integer.decode(this.baseFreq.getText()) < 0) {
                throw new NumberFormatException();
            }
            tooltip.setText(this.util.getBundle().getString("BASE_FREQ_TIP"));
            this.baseFreq.setTooltip(tooltip);
            this.baseFreq.getStyleClass().add((Object)CELL_VALUE_OK);
        }
        catch (NumberFormatException e) {
            tooltip.setText(this.util.getBundle().getString("BASE_FREQ_HEX"));
            this.baseFreq.setTooltip(tooltip);
            this.baseFreq.getStyleClass().add((Object)CELL_VALUE_ERROR);
        }
    }

    @FXML
    private void doSetTableFontSize() {
        block4: {
            Tooltip tooltip = new Tooltip();
            try {
                this.tableFontSize.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
                int fontSizeVal = Integer.parseInt(this.tableFontSize.getText());
                if (fontSizeVal > 0 && fontSizeVal <= 24) {
                    tooltip.setText(this.util.getBundle().getString("TABLE_FONT_SIZE_TIP"));
                    this.tableFontSize.setTooltip(tooltip);
                    this.tableFontSize.getStyleClass().add((Object)CELL_VALUE_OK);
                    this.dumpTable.setStyle(String.format("-fx-font-size:%d.0px;}", fontSizeVal));
                    for (TableColumn column : this.dumpTable.getColumns()) {
                        column.setStyle(String.format("-fx-font-size:%d.0px;", fontSizeVal));
                    }
                    break block4;
                }
                throw new NumberFormatException();
            }
            catch (NumberFormatException e) {
                tooltip.setText(this.util.getBundle().getString("TABLE_FONT_SIZE_NEG"));
                this.tableFontSize.setTooltip(tooltip);
                this.tableFontSize.getStyleClass().add((Object)CELL_VALUE_ERROR);
            }
        }
    }

    @FXML
    private void doSetBaseNote() {
        Tooltip tooltip = new Tooltip();
        try {
            this.baseNote.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            int baseNoteVal = Integer.decode(this.baseNote.getText());
            if (baseNoteVal < 128 || baseNoteVal > 223) {
                throw new NumberFormatException();
            }
            tooltip.setText(this.util.getBundle().getString("BASE_NOTE_TIP"));
            this.baseNote.setTooltip(tooltip);
            this.baseNote.getStyleClass().add((Object)CELL_VALUE_OK);
        }
        catch (NumberFormatException e) {
            tooltip.setText(this.util.getBundle().getString("BASE_NOTE_HEX"));
            this.baseNote.setTooltip(tooltip);
            this.baseNote.getStyleClass().add((Object)CELL_VALUE_ERROR);
        }
    }

    @FXML
    private void doSetCallsPerFrame() {
        Tooltip tooltip = new Tooltip();
        try {
            this.callsPerFrame.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            int speed = Integer.parseInt(this.callsPerFrame.getText());
            if (speed < 1) {
                throw new NumberFormatException();
            }
            tooltip.setText(this.util.getBundle().getString("CALLS_PER_FRAME_TIP"));
            this.callsPerFrame.setTooltip(tooltip);
            this.callsPerFrame.getStyleClass().add((Object)CELL_VALUE_OK);
            this.sidDumpExtension.setReplayFrequency(speed * 50);
        }
        catch (NumberFormatException e) {
            tooltip.setText(this.util.getBundle().getString("CALLS_PER_FRAME_NEG"));
            this.callsPerFrame.setTooltip(tooltip);
            this.callsPerFrame.getStyleClass().add((Object)CELL_VALUE_ERROR);
        }
    }

    @FXML
    private void doSetFirstFrame() {
        Tooltip tooltip = new Tooltip();
        try {
            this.firstFrame.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (Long.parseLong(this.firstFrame.getText()) < 0L) {
                throw new NumberFormatException();
            }
            tooltip.setText(this.util.getBundle().getString("FIRST_FRAME_TIP"));
            this.firstFrame.setTooltip(tooltip);
            this.firstFrame.getStyleClass().add((Object)CELL_VALUE_OK);
        }
        catch (NumberFormatException e) {
            tooltip.setText(this.util.getBundle().getString("FIRST_FRAME_NEG"));
            this.firstFrame.setTooltip(tooltip);
            this.firstFrame.getStyleClass().add((Object)CELL_VALUE_ERROR);
        }
    }

    private void setTune(SidTune tune) {
        if (tune == null) {
            this.startStopRecording.setDisable(true);
            return;
        }
        this.startStopRecording.setDisable(tune.getInfo().getPlayAddr() == 0);
        this.loadAddress = tune.getInfo().getLoadAddr();
        this.sidDumpExtension.setLoadAddress(this.loadAddress);
        this.initAddress = tune.getInfo().getInitAddr();
        this.sidDumpExtension.setInitAddress(this.initAddress);
        this.playerAddress = tune.getInfo().getPlayAddr();
        this.sidDumpExtension.setPayerAddress(this.playerAddress);
        this.subTune = tune.getInfo().getCurrentSong();
        this.sidDumpExtension.setCurrentSong(this.subTune);
        this.sidDumpExtension.setFirstFrame(Long.valueOf(this.firstFrame.getText()));
        if (this.seconds == 0) {
            int length = this.util.getPlayer().getSidDatabaseInfo(db -> db.getSongLength(tune), 0);
            if (length == 0 && (length = this.util.getConfig().getSidplay2Section().getDefaultPlayLength()) <= 0) {
                length = 60;
            }
            this.maxRecordLength.setText(new TimeToStringConverter().toString(length));
            this.sidDumpExtension.setRecordLength(length);
        } else {
            this.sidDumpExtension.setRecordLength(this.seconds);
        }
        this.sidDumpExtension.setTimeInSeconds(this.timeInSeconds.isSelected());
        this.sidDumpExtension.setOldNoteFactor(Float.parseFloat(this.oldNoteFactor.getText()));
        this.sidDumpExtension.setBaseFreq(Integer.decode(this.baseFreq.getText()));
        this.sidDumpExtension.setBaseNote(Integer.decode(this.baseNote.getText()));
        this.sidDumpExtension.setPatternSpacing(Integer.valueOf(this.patternSpacing.getText()));
        this.sidDumpExtension.setNoteSpacing(Integer.parseInt(this.noteSpacing.getText()));
        this.sidDumpExtension.setLowRes(this.lowResolutionMode.isSelected());
        if (tune.getInfo().getPlayAddr() == 0) {
            this.startStopRecording.setSelected(false);
            this.startStopRecording.setTooltip(new Tooltip(this.util.getBundle().getString("NOT_AVAILABLE")));
        } else {
            this.startStopRecording.setTooltip(new Tooltip(null));
        }
        this.sidDumpExtension.setLeftVolume(this.util.getConfig().getAudioSection().getMainVolume());
        this.sidDumpExtension.setRegOrder(((SIDDumpConfiguration.SIDDumpPlayer)this.regPlayer.getSelectionModel().getSelectedItem()).getRegs());
        this.sidDumpExtension.init();
    }
}

