/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.TitledPane;
import libsidplay.common.SIDEmu;
import resid_builder.ReSIDBase;
import sidplay.Player;
import ui.common.C64Window;
import ui.oscilloscope.SIDGauge;

public final class WaveGauge
extends SIDGauge {
    @FXML
    private TitledPane border;
    @FXML
    private Canvas area;

    @Override
    protected Canvas getArea() {
        return this.area;
    }

    public WaveGauge(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    protected TitledPane getTitledPane() {
        return this.border;
    }

    @Override
    public SIDGauge sample(SIDEmu sidemu) {
        if (sidemu instanceof ReSIDBase) {
            this.accumulate((float)(((ReSIDBase)sidemu).readOSC(this.getVoice()) & 0xFF) / 255.0f);
        } else {
            this.accumulate(0.0f);
        }
        return this;
    }

    @Override
    public void updateGauge(SIDEmu sidemu) {
        super.updateGauge(sidemu);
        if (sidemu != null) {
            byte wf = sidemu.readInternalRegister(4 + 7 * this.getVoice());
            byte filt = sidemu.readInternalRegister(23);
            this.setText(String.format(this.localizer.getString("WAVE") + " %X %s%s%s%s", wf >> 4 & 0xF, (wf & 2) != 0 ? "S" : "", (wf & 4) != 0 ? "R" : "", (wf & 8) != 0 ? "T" : "", (filt & 1 << this.getVoice()) != 0 ? "F" : ""));
        }
    }
}

