/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import java.net.URL;
import java.util.Arrays;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import libsidplay.common.SIDEmu;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.UIUtil;

public class Gauge
extends VBox
implements UIPart {
    protected static final Color[] gaugeColors = new Color[256];
    private UIUtil util;
    private String text;
    private int voice;
    private float[] dataMin = new float[256];
    private float[] dataMax = new float[256];
    private int dataPos = 0;

    public Gauge(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.getChildren().add((Object)((Node)this.util.parse()));
    }

    @Override
    public String getBundleName() {
        return Gauge.class.getName();
    }

    @Override
    public URL getFxml() {
        return this.getClass().getResource(Gauge.class.getSimpleName() + ".fxml");
    }

    public int getVoice() {
        return this.voice;
    }

    public void setVoice(int voice) {
        this.voice = voice;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected void accumulate(float value) {
        if (value < this.dataMin[this.dataPos]) {
            this.dataMin[this.dataPos] = value;
        }
        if (value > this.dataMax[this.dataPos]) {
            this.dataMax[this.dataPos] = value;
        }
    }

    protected void advance() {
        float min = this.dataMin[this.dataPos];
        float max = this.dataMax[this.dataPos];
        this.dataPos = this.dataPos + 1 & this.dataMin.length - 1;
        this.dataMin[this.dataPos] = max;
        this.dataMax[this.dataPos] = min;
    }

    public void reset() {
        Arrays.fill(this.dataMin, 0.0f);
        Arrays.fill(this.dataMax, 0.0f);
        this.dataPos = 0;
        this.updateGauge(null);
    }

    public void updateGauge(SIDEmu sidemu) {
        this.getTitledPane().setText(this.text);
        GraphicsContext g = this.getArea().getGraphicsContext2D();
        int width = (int)this.getArea().getWidth();
        int height = (int)this.getArea().getHeight();
        g.setStroke((Paint)Color.BLACK);
        g.fillRect(0.0, 0.0, (double)width, (double)height);
        int shade = 255;
        for (int x = 0; x < width; ++x) {
            int intEndPos;
            int intStartPos;
            float endPos;
            int readPos = this.dataPos - width + x & this.dataMin.length - 1;
            float startPos = (1.0f - this.dataMax[readPos]) * (float)(height - 1);
            if (startPos < 0.0f) {
                startPos = 0.0f;
            }
            if ((endPos = (1.0f - this.dataMin[readPos]) * (float)(height - 1)) > (float)(height - 1)) {
                endPos = height - 1;
            }
            if ((intStartPos = (int)Math.floor(startPos)) == (intEndPos = (int)Math.ceil(endPos))) {
                g.setStroke((Paint)gaugeColors[shade]);
                g.strokeLine((double)x, (double)intStartPos, (double)x, (double)intStartPos);
                continue;
            }
            float firstPixel = startPos - (float)intStartPos;
            if ((firstPixel = 1.0f - firstPixel) < 0.0f) {
                firstPixel = 0.0f;
            }
            if (firstPixel > 1.0f) {
                firstPixel = 1.0f;
            }
            float lastPixel = (float)intEndPos - endPos;
            if ((lastPixel = 1.0f - lastPixel) < 0.0f) {
                lastPixel = 0.0f;
            }
            if (lastPixel > 1.0f) {
                lastPixel = 1.0f;
            }
            g.setStroke((Paint)gaugeColors[(int)((float)shade * firstPixel)]);
            g.strokeLine((double)x, (double)intStartPos, (double)x, (double)intStartPos);
            g.setStroke((Paint)gaugeColors[(int)((float)shade * lastPixel)]);
            g.strokeLine((double)x, (double)intEndPos, (double)x, (double)intEndPos);
            if (++intStartPos > --intEndPos) continue;
            g.setStroke((Paint)gaugeColors[shade]);
            g.strokeLine((double)x, (double)intStartPos, (double)x, (double)intEndPos);
        }
    }

    protected void sample() {
    }

    protected TitledPane getTitledPane() {
        return null;
    }

    protected Canvas getArea() {
        return null;
    }

    static {
        for (int i = 0; i < gaugeColors.length; ++i) {
            int color = Math.round((float)Math.sqrt((float)i / 255.0f) * 255.0f);
            Gauge.gaugeColors[i] = new Color((double)(color >> 8) / 255.0, (double)(color & 0xFF) / 255.0, 0.0, 1.0);
        }
    }
}

