/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.TitledPane;
import libsidplay.common.SIDEmu;
import sidplay.Player;
import ui.common.C64Window;
import ui.oscilloscope.SIDGauge;

public final class FrequencyGauge
extends SIDGauge {
    @FXML
    private TitledPane border;
    @FXML
    private Canvas area;

    public FrequencyGauge(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    protected Canvas getArea() {
        return this.area;
    }

    @Override
    protected TitledPane getTitledPane() {
        return this.border;
    }

    @Override
    public SIDGauge sample(SIDEmu sidemu) {
        int frqValue = (sidemu.readInternalRegister(1 + this.getVoice() * 7) & 0xFF) << 8 | sidemu.readInternalRegister(0 + this.getVoice() * 7) & 0xFF;
        float frq = 84.0f;
        if (frqValue != 0) {
            frq = (float)(Math.log((float)frqValue / 65535.0f) / Math.log(2.0) * 12.0);
        }
        this.accumulate(1.0f + frq / 84.0f);
        return this;
    }
}

