/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.TitledPane;
import libsidplay.common.SIDEmu;
import sidplay.Player;
import ui.common.C64Window;
import ui.oscilloscope.SIDGauge;

public final class FilterGauge
extends SIDGauge {
    @FXML
    private TitledPane border;
    @FXML
    private Canvas area;

    public FilterGauge(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    protected Canvas getArea() {
        return this.area;
    }

    @Override
    protected TitledPane getTitledPane() {
        return this.border;
    }

    @Override
    public SIDGauge sample(SIDEmu sidemu) {
        int fc = sidemu.readInternalRegister(21) & 7;
        this.accumulate((float)(fc |= (sidemu.readInternalRegister(22) & 0xFF) << 3) / 2047.0f);
        return this;
    }

    @Override
    public void updateGauge(SIDEmu sidemu) {
        super.updateGauge(sidemu);
        if (sidemu != null) {
            byte vol = sidemu.readInternalRegister(24);
            this.setText((this.localizer != null ? this.localizer.getString("FILTER") : "") + " " + ((vol & 0x10) != 0 ? "L" : "") + ((vol & 0x20) != 0 ? "B" : "") + ((vol & 0x40) != 0 ? "H" : ""));
        }
    }
}

