/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.TitledPane;
import libsidplay.common.SIDEmu;
import resid_builder.ReSIDBase;
import sidplay.Player;
import ui.common.C64Window;
import ui.oscilloscope.SIDGauge;

public final class EnvelopeGauge
extends SIDGauge {
    @FXML
    private TitledPane border;
    @FXML
    private Canvas area;

    public EnvelopeGauge(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    protected Canvas getArea() {
        return this.area;
    }

    @Override
    protected TitledPane getTitledPane() {
        return this.border;
    }

    @Override
    public SIDGauge sample(SIDEmu sidemu) {
        if (sidemu instanceof ReSIDBase) {
            this.accumulate(this.getValue(((ReSIDBase)sidemu).readENV(this.getVoice())));
        } else {
            this.accumulate(0.0f);
        }
        return this;
    }

    private float getValue(byte envOutput) {
        float value = -48.0f;
        if (envOutput != 0) {
            value = (float)(Math.log((float)(envOutput & 0xFF) / 255.0f) / Math.log(10.0) * 20.0);
        }
        return 1.0f + value / 48.0f;
    }
}

