/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection.search;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import ui.filefilter.TuneFileFilter;
import ui.musiccollection.search.SearchThread;

public class SearchIndexerThread
extends SearchThread {
    protected FileFilter fFileFilter = new TuneFileFilter();
    protected Queue<File> fQueue = new LinkedList<File>();

    public SearchIndexerThread(File root, Consumer<Void> searchStart, Consumer<File> searchHit, Consumer<Boolean> searchStop) {
        super(true, searchStart, searchHit, searchStop);
        this.fQueue.add(root);
    }

    @Override
    public void run() {
        this.searchStart.accept(null);
        while (!this.fAborted && !this.fQueue.isEmpty()) {
            File tmp = this.fQueue.remove();
            this.searchHit.accept(tmp);
            File[] childs = tmp.listFiles(this.fFileFilter);
            if (childs == null) continue;
            for (File child : childs) {
                this.fQueue.add(child);
            }
        }
        this.searchStop.accept(this.fAborted);
    }

    @Override
    public Object getSearchState() {
        return this.fQueue;
    }

    @Override
    public void setSearchState(Object state) {
        if (state != null && state instanceof Queue) {
            this.fQueue = (Queue)state;
        }
    }
}

