/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection.search;

import java.io.File;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import libsidutils.PathUtils;
import sidplay.Player;
import ui.entities.collection.service.HVSCEntryService;
import ui.entities.collection.service.STILService;
import ui.entities.collection.service.VersionService;

public final class SearchIndexCreator {
    private EntityManager em;
    private HVSCEntryService hvscEntryService;
    private STILService stilService;
    private VersionService versionService;
    private Player player;
    private File root;

    public SearchIndexCreator(File root, Player player, EntityManager em) {
        this.root = root;
        this.player = player;
        this.em = em;
        this.hvscEntryService = new HVSCEntryService(em);
        this.stilService = new STILService(em);
        this.versionService = new VersionService(em);
    }

    private void clearPreviousSearchIndex() {
        this.em.getTransaction().begin();
        try {
            this.versionService.clear();
            this.stilService.clear();
            this.hvscEntryService.clear();
            this.em.getTransaction().commit();
            this.em.clear();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.em.getTransaction().rollback();
        }
    }

    public Consumer<Void> getSearchStart() {
        return x -> {
            this.clearPreviousSearchIndex();
            this.em.getTransaction().begin();
        };
    }

    public Consumer<File> getSearchHit() {
        return file -> {
            if (!file.isFile()) {
                return;
            }
            try {
                String collectionRelName = PathUtils.getCollectionName(this.root, file);
                if (collectionRelName != null) {
                    this.hvscEntryService.add(this.player, collectionRelName, (File)file);
                }
            }
            catch (Exception e) {
                System.err.println("Indexing failure on: " + file.getAbsolutePath() + ": " + e.getMessage());
            }
        };
    }

    public Consumer<Boolean> getSearchStop() {
        return cancelled -> {
            this.versionService.setExpectedVersion();
            this.em.getTransaction().commit();
        };
    }
}

