/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection.createhvsc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class Split {
    public static void main(String[] args) {
        new Split().doSplit(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSplit(String[] args) {
        String filename = null;
        int totalBytes = -1;
        for (String paramValue : args) {
            int idx = paramValue.indexOf("=");
            if (idx == -1) continue;
            String name = paramValue.substring(0, idx);
            String value = paramValue.substring(idx + 1);
            if ("file".equals(name)) {
                filename = value;
                continue;
            }
            if (!"bytes".equals(name)) continue;
            totalBytes = Integer.valueOf(value);
        }
        if (filename == null || !filename.endsWith(".zip") || totalBytes == -1) {
            System.err.println("Usage: file=<filename> bytes=<byteCount>");
            System.exit(1);
        }
        int partNum = 1;
        String output = this.createOutputFilename(filename, partNum);
        byte[] buffer = new byte[0x100000];
        FilterOutputStream os = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(filename)), 0x100000);){
            int bytesRead = 0;
            int totalBytesRead = 0;
            os = this.createOutputStream(output);
            int len = Math.min(buffer.length, totalBytes - totalBytesRead);
            while ((bytesRead = is.read(buffer, 0, len)) >= 0) {
                ((BufferedOutputStream)os).write(buffer, 0, bytesRead);
                len = Math.min(buffer.length, totalBytes - (totalBytesRead += bytesRead));
                if (totalBytesRead != totalBytes) continue;
                os.close();
                output = this.createOutputFilename(filename, ++partNum);
                os = this.createOutputStream(output);
                totalBytesRead = 0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String createOutputFilename(String filename, int partNum) {
        return filename.substring(0, filename.lastIndexOf(".zip")) + String.format(".%03d", partNum);
    }

    private BufferedOutputStream createOutputStream(String filename) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(new File(filename)), 0x100000);
    }
}

