/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import libsidutils.PathUtils;
import libsidutils.stil.STIL;
import sidplay.Player;
import ui.JSidPlay2Main;
import ui.entities.config.SidPlay2Section;
import ui.filefilter.TuneFileFilter;

public class MusicCollectionTreeItem
extends TreeItem<File> {
    private static final Image stilIcon = new Image(JSidPlay2Main.class.getResource("icons/stil.png").toString());
    private static final Image noStilIcon = new Image(JSidPlay2Main.class.getResource("icons/stil_no.png").toString());
    private final FileFilter fFileFilter = new TuneFileFilter();
    private boolean hasLoadedChildren;
    private boolean isLeaf;
    private boolean hasSTIL;
    private Player player;
    private STIL.STILEntry stilEntry;

    public MusicCollectionTreeItem(Player player, File file) {
        super((Object)file);
        this.player = player;
        this.isLeaf = file.isFile();
        if (this.isLeaf && player != null) {
            SidPlay2Section sidPlay2Section = (SidPlay2Section)player.getConfig().getSidplay2Section();
            String collectionName = PathUtils.getCollectionName(sidPlay2Section.getHvscFile(), file);
            this.stilEntry = player.getStilEntry(collectionName);
            this.hasSTIL = this.stilEntry != null;
        }
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public ObservableList<TreeItem<File>> getChildren() {
        if (!this.hasLoadedChildren) {
            this.loadChildren();
        }
        return super.getChildren();
    }

    public boolean hasSTIL() {
        return this.hasSTIL;
    }

    public STIL.STILEntry getStilEntry() {
        return this.stilEntry;
    }

    private void loadChildren() {
        this.hasLoadedChildren = true;
        ArrayList children = new ArrayList();
        File[] listFiles = ((File)this.getValue()).listFiles(this.fFileFilter);
        if (listFiles != null) {
            Arrays.stream(listFiles).sorted((a, b) -> {
                Integer bw;
                Integer aw = a.isFile() ? 1 : 0;
                if (aw.equals(bw = Integer.valueOf(b.isFile() ? 1 : 0))) {
                    return a.getName().toLowerCase(Locale.ENGLISH).compareTo(b.getName().toLowerCase(Locale.ENGLISH));
                }
                return aw.compareTo(bw);
            }).forEach(file -> {
                MusicCollectionTreeItem childItem = new MusicCollectionTreeItem(this.player, (File)file);
                children.add(childItem);
                if (childItem.hasSTIL()) {
                    childItem.setGraphic((Node)new ImageView(stilIcon));
                } else {
                    childItem.setGraphic((Node)new ImageView(noStilIcon));
                }
            });
        }
        super.getChildren().setAll(children);
    }
}

