/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection;

import java.io.File;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.util.Callback;

public class MusicCollectionCellFactory
implements Callback<TreeView<File>, TreeCell<File>> {
    private static final String CURRENTLY_PLAYED_FILE_ROW = "currentlyPlayedRow";
    private ObservableList<TreeItem<File>> currentlyPlayedTreeItems;

    public void setCurrentlyPlayedTreeItems(ObservableList<TreeItem<File>> currentlyPlayedTreeItems) {
        this.currentlyPlayedTreeItems = currentlyPlayedTreeItems;
    }

    public TreeCell<File> call(TreeView<File> treeView) {
        return new TextFieldTreeCellImpl();
    }

    public class TextFieldTreeCellImpl
    extends TreeCell<File> {
        private ListChangeListener<TreeItem<File>> listChangeListener = c -> this.setCellStyle();

        public TextFieldTreeCellImpl() {
            MusicCollectionCellFactory.this.currentlyPlayedTreeItems.addListener(this.listChangeListener);
        }

        protected void updateItem(File file, boolean empty) {
            super.updateItem((Object)file, empty);
            if (!empty && file != null) {
                this.setText(file.getName());
                this.setGraphic(this.getTreeItem().getGraphic());
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
            this.setCellStyle();
        }

        private void setCellStyle() {
            this.getStyleClass().remove((Object)MusicCollectionCellFactory.CURRENTLY_PLAYED_FILE_ROW);
            if (!this.isEmpty() && this.isCurrentlyPlayed()) {
                this.getStyleClass().add((Object)MusicCollectionCellFactory.CURRENTLY_PLAYED_FILE_ROW);
            }
        }

        private boolean isCurrentlyPlayed() {
            return MusicCollectionCellFactory.this.currentlyPlayedTreeItems.stream().filter(treeItem -> ((File)treeItem.getValue()).equals(this.getItem())).findFirst().isPresent();
        }
    }
}

