/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.stage.DirectoryChooser;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.SingularAttribute;
import libpsid64.Psid64;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.PathUtils;
import libsidutils.WebUtils;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import sidplay.Player;
import sidplay.player.State;
import ui.common.C64Window;
import ui.common.EnumToString;
import ui.common.TypeTextField;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.common.dialog.AlertDialog;
import ui.common.dialog.YesNoDialog;
import ui.download.DownloadThread;
import ui.download.ProgressListener;
import ui.entities.Database;
import ui.entities.PersistenceProperties;
import ui.entities.collection.HVSCEntry;
import ui.entities.collection.service.VersionService;
import ui.entities.config.FavoritesSection;
import ui.entities.config.SidPlay2Section;
import ui.filefilter.TuneFileFilter;
import ui.musiccollection.FileTreeCell;
import ui.musiccollection.MusicCollectionCellFactory;
import ui.musiccollection.MusicCollectionTreeItem;
import ui.musiccollection.MusicCollectionType;
import ui.musiccollection.SearchCriteria;
import ui.musiccollection.SearchCriteriaToString;
import ui.musiccollection.SearchResult;
import ui.musiccollection.SearchScope;
import ui.musiccollection.SidAuthors;
import ui.musiccollection.TuneInfo;
import ui.musiccollection.search.SearchInIndexThread;
import ui.musiccollection.search.SearchIndexCreator;
import ui.musiccollection.search.SearchIndexerThread;
import ui.musiccollection.search.SearchThread;
import ui.stilview.STILView;

public class MusicCollection
extends Tab
implements UIPart {
    public static final String HVSC_ID = "HVSC";
    public static final String CGSC_ID = "CGSC";
    private static final String HVSC_URL = "http://www.hvsc.de/";
    private static final String CGSC_URL = "http://www.c64music.co.uk/";
    private static final String HVSC_DS = "hvsc-ds";
    private static final String CGSC_DS = "cgsc-ds";
    @FXML
    private CheckBox autoConfiguration;
    @FXML
    private TableView<TuneInfo> tuneInfoTable;
    @FXML
    private TableColumn<TuneInfo, String> nameColumn;
    @FXML
    private TableColumn<TuneInfo, String> valueColumn;
    @FXML
    private TitledPane photographPane;
    @FXML
    private ImageView photograph;
    @FXML
    private TreeView<File> fileBrowser;
    @FXML
    private ComboBox<SearchCriteria<?, ?>> searchCriteria;
    @FXML
    private ComboBox<SearchScope> searchScope;
    @FXML
    private ComboBox<SearchResult> searchResult;
    @FXML
    private Button startSearch;
    @FXML
    private Button stopSearch;
    @FXML
    private Button resetSearch;
    @FXML
    private Button createSearchIndex;
    @FXML
    private TextField collectionDir;
    @FXML
    private TypeTextField stringTextField;
    @FXML
    private TypeTextField integerTextField;
    @FXML
    private TypeTextField longTextField;
    @FXML
    private TypeTextField shortTextField;
    @FXML
    private ComboBox<Enum<?>> combo;
    @FXML
    private ContextMenu contextMenu;
    @FXML
    private MenuItem showStil;
    @FXML
    private MenuItem convertToPSID64;
    @FXML
    private MenuItem soasc6581R2;
    @FXML
    private MenuItem soasc6581R4;
    @FXML
    private MenuItem soasc8580R5;
    @FXML
    private Menu addToFavoritesMenu;
    private final FileFilter tuneFilter = new TuneFileFilter();
    private UIUtil util;
    private ObjectProperty<MusicCollectionType> type;
    private ObservableList<TuneInfo> tuneInfos;
    private ObservableList<Enum<?>> comboItems;
    private ObservableList<TreeItem<File>> currentlyPlayedTreeItems;
    private String collectionURL;
    private String collectionDS;
    private EntityManager em;
    private VersionService versionService;
    private SearchThread searchThread;
    private Object savedState;
    private Object searchForValue;
    private Object recentlySearchedForValue;
    private SearchCriteria<?, ?> recentlySearchedCriteria;
    private boolean searchOptionsChanged;
    private String hvscName;
    private int selectedSong;
    private FavoritesSection favoritesToAddSearchResult;
    private ChangeListener<? super State> tuneMatcherListener = (observable, oldValue, newValue) -> Platform.runLater(() -> this.showCurrentTune());
    private ChangeListener<? super TreeItem<File>> tuneInfoListener = (observable, oldValue, newValue) -> {
        if (newValue != null && ((File)newValue.getValue()).isFile()) {
            File tuneFile = (File)newValue.getValue();
            try {
                SidTune sidTune = SidTune.load(tuneFile);
                if (this.getType() == MusicCollectionType.HVSC) {
                    this.enableSOASC(sidTune.getInfo(), tuneFile);
                    this.showPhoto(sidTune.getInfo());
                }
                this.showTuneInfos(tuneFile, sidTune, (MusicCollectionTreeItem)((Object)newValue));
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()), this.getType());
            }
        }
    };
    private EventHandler<WindowEvent> contextMenuEvent = event -> {
        TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
        this.showStil.setDisable(selectedItem == null || !((MusicCollectionTreeItem)selectedItem).hasSTIL());
        this.convertToPSID64.setDisable(selectedItem == null);
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        List<FavoritesSection> favorites = this.util.getConfig().getFavorites();
        this.addToFavoritesMenu.getItems().clear();
        for (FavoritesSection section : favorites) {
            MenuItem item = new MenuItem(section.getName());
            item.setOnAction(event2 -> this.addFavorites(sidplay2Section, section, Collections.singletonList(selectedItem.getValue())));
            this.addToFavoritesMenu.getItems().add((Object)item);
        }
        this.addToFavoritesMenu.setDisable(this.addToFavoritesMenu.getItems().isEmpty());
    };

    public MusicCollection(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
    }

    public MusicCollectionType getType() {
        return (MusicCollectionType)((Object)this.type.get());
    }

    public void setType(MusicCollectionType type) {
        switch (type) {
            case HVSC: {
                this.setId(HVSC_ID);
                this.collectionURL = HVSC_URL;
                this.collectionDS = HVSC_DS;
                break;
            }
            case CGSC: {
                this.setId(CGSC_ID);
                this.collectionURL = CGSC_URL;
                this.collectionDS = CGSC_DS;
                break;
            }
        }
        this.setText(this.util.getBundle().getString(this.getId()));
        this.type.set((Object)type);
    }

    @FXML
    private void initialize() {
        this.util.getPlayer().stateProperty().addListener(this.tuneMatcherListener);
        this.tuneInfos = FXCollections.observableArrayList();
        this.tuneInfoTable.setItems(this.tuneInfos);
        this.tuneInfoTable.setPrefHeight(Double.MAX_VALUE);
        this.photographPane.setPrefHeight(Double.MAX_VALUE);
        this.nameColumn.prefWidthProperty().bind((ObservableValue)this.tuneInfoTable.widthProperty().multiply(0.4));
        this.valueColumn.prefWidthProperty().bind((ObservableValue)this.tuneInfoTable.widthProperty().multiply(0.6));
        this.searchScope.setConverter(new EnumToString(this.util.getBundle()));
        this.searchScope.setItems(FXCollections.observableArrayList((Object[])SearchScope.values()));
        this.searchScope.getSelectionModel().select((Object)SearchScope.FORWARD);
        this.searchResult.setConverter(new EnumToString(this.util.getBundle()));
        this.searchResult.setItems(FXCollections.observableArrayList((Object[])SearchResult.values()));
        this.searchResult.getSelectionModel().select((Object)SearchResult.SHOW_NEXT_MATCH);
        this.searchCriteria.setConverter((StringConverter)new SearchCriteriaToString(this.util.getBundle()));
        this.searchCriteria.setItems(FXCollections.observableArrayList(SearchCriteria.getSearchableAttributes()));
        this.searchCriteria.getSelectionModel().select(0);
        this.comboItems = FXCollections.observableArrayList();
        this.combo.setItems(this.comboItems);
        this.currentlyPlayedTreeItems = FXCollections.observableArrayList();
        this.contextMenu.setOnShown(this.contextMenuEvent);
        this.fileBrowser.setCellFactory(treeView -> new FileTreeCell());
        this.fileBrowser.getSelectionModel().selectedItemProperty().addListener(this.tuneInfoListener);
        this.fileBrowser.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.playSelected();
            }
        });
        this.fileBrowser.setOnMousePressed(event -> {
            if (event.isPrimaryButtonDown() && event.getClickCount() > 1) {
                this.playSelected();
            }
        });
        this.type = new SimpleObjectProperty();
        this.type.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            File initialRoot;
            switch (this.getType()) {
                case HVSC: {
                    initialRoot = this.util.getConfig().getSidplay2Section().getHvscFile();
                    break;
                }
                case CGSC: {
                    initialRoot = this.util.getConfig().getSidplay2Section().getCgscFile();
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal music collection type: " + this.type);
                }
            }
            if (initialRoot != null) {
                this.setRoot(initialRoot);
                this.showCurrentTune();
            }
        }));
    }

    private void showCurrentTune() {
        if (this.util.getPlayer().getTune() != SidTune.RESET && this.fileBrowser.getRoot() != null) {
            SidTune tune = this.util.getPlayer().getTune();
            String collectionName = this.util.getPlayer().getSidDatabaseInfo(db -> db.getPath(tune), "");
            this.showNextHit((File)new TFile((File)this.fileBrowser.getRoot().getValue(), collectionName));
        }
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.tuneMatcherListener);
        if (this.em != null && this.em.isOpen()) {
            this.em.getEntityManagerFactory().close();
        }
    }

    @FXML
    private void showSTIL() {
        MusicCollectionTreeItem selectedItem = (MusicCollectionTreeItem)((Object)this.fileBrowser.getSelectionModel().getSelectedItem());
        if (selectedItem != null && selectedItem.hasSTIL()) {
            STILView stilInfo = new STILView(this.util.getPlayer());
            stilInfo.setEntry(selectedItem.getStilEntry());
            stilInfo.open();
        }
    }

    @FXML
    private void convertToPSID64() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(sidPlay2Section.getLastDirectoryFolder());
        File directory = fileDialog.showDialog(this.fileBrowser.getScene().getWindow());
        if (directory != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(directory.getAbsolutePath());
            Psid64 c = new Psid64();
            c.setTmpDir(this.util.getConfig().getSidplay2Section().getTmpDir());
            c.setVerbose(true);
            try {
                c.convertFiles(this.util.getPlayer(), new File[]{(File)selectedItem.getValue()}, directory, sidPlay2Section.getHvscFile());
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()), this.getType());
            }
        }
    }

    @FXML
    private void startDownload6581R2() {
        String url = this.util.getConfig().getOnlineSection().getSoasc6581R2();
        this.downloadStart(MessageFormat.format(url, this.hvscName, this.selectedSong).trim());
    }

    @FXML
    private void startDownload6581R4() {
        String url = this.util.getConfig().getOnlineSection().getSoasc6581R4();
        this.downloadStart(MessageFormat.format(url, this.hvscName, this.selectedSong).trim());
    }

    @FXML
    private void startDownload8580R5() {
        String url = this.util.getConfig().getOnlineSection().getSoasc8580R5();
        this.downloadStart(MessageFormat.format(url, this.hvscName, this.selectedSong).trim());
    }

    @FXML
    private void doAutoConfiguration() {
        String url;
        switch (this.getType()) {
            case HVSC: {
                url = this.util.getConfig().getOnlineSection().getHvscUrl();
                break;
            }
            case CGSC: {
                url = this.util.getConfig().getOnlineSection().getCgscUrl();
                break;
            }
            default: {
                throw new RuntimeException("Illegal music collection type: " + this.type);
            }
        }
        if (this.autoConfiguration.isSelected()) {
            this.autoConfiguration.setDisable(true);
            try {
                DownloadThread downloadThread = new DownloadThread(this.util.getConfig(), new ProgressListener(this.util, (Node)this.fileBrowser){

                    @Override
                    public void downloaded(File downloadedFile) {
                        Platform.runLater(() -> {
                            MusicCollection.this.autoConfiguration.setDisable(false);
                            if (downloadedFile != null) {
                                MusicCollection.this.setRoot(downloadedFile);
                            }
                        });
                    }
                }, new URL(url));
                downloadThread.start();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void searchCategory() {
        if (this.searchCriteria.getSelectionModel().getSelectedItem() != this.recentlySearchedCriteria) {
            this.searchOptionsChanged = true;
            this.recentlySearchedCriteria = (SearchCriteria)this.searchCriteria.getSelectionModel().getSelectedItem();
        }
        this.setSearchEditorVisible();
    }

    @FXML
    private void doStartSearch() {
        this.startSearch(false);
    }

    @FXML
    private void doStopSearch() {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.searchThread.setAborted(true);
        }
    }

    @FXML
    private void doResetSearch() {
        this.savedState = null;
    }

    @FXML
    private void doCreateSearchIndex() {
        YesNoDialog dialog = new YesNoDialog(this.util.getPlayer());
        dialog.getStage().setTitle(this.util.getBundle().getString("CREATE_SEARCH_DATABASE"));
        dialog.setText(String.format(this.util.getBundle().getString("RECREATE_DATABASE"), ((MusicCollectionType)((Object)this.type.get())).toString()));
        dialog.getConfirmed().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.startSearch(true);
            }
        });
        dialog.open();
    }

    @FXML
    private void doBrowse() {
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        File directory = fileDialog.showDialog(this.autoConfiguration.getScene().getWindow());
        if (directory != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(directory.getAbsolutePath());
            this.setRoot(directory);
        }
    }

    @FXML
    private void gotoURL() {
        WebUtils.browse(this.collectionURL);
    }

    @FXML
    private void doSetValue() {
        this.setSearchValue();
        if (this.searchForValue != null && !this.searchForValue.equals(this.recentlySearchedForValue)) {
            this.searchOptionsChanged = true;
            this.recentlySearchedForValue = this.searchForValue;
        }
        this.startSearch(false);
    }

    private void setSearchEditorVisible() {
        for (Node node : Arrays.asList(new Control[]{this.stringTextField, this.integerTextField, this.longTextField, this.shortTextField, this.combo})) {
            node.setVisible(false);
        }
        SearchCriteria selectedItem = (SearchCriteria)this.searchCriteria.getSelectionModel().getSelectedItem();
        Class clazz = selectedItem.getAttribute().getJavaType();
        if (clazz == Long.class) {
            this.longTextField.setVisible(true);
        } else if (clazz == Integer.class || clazz == Date.class) {
            this.integerTextField.setVisible(true);
        } else if (clazz == Short.class) {
            this.shortTextField.setVisible(true);
        } else if (clazz == String.class) {
            this.stringTextField.setVisible(true);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            this.comboItems.clear();
            Class en = clazz;
            for (Enum val : (Enum[])en.getEnumConstants()) {
                this.comboItems.add((Object)val);
            }
            this.combo.setVisible(true);
            this.combo.getSelectionModel().select(0);
        }
    }

    private void setSearchValue() {
        SearchCriteria selectedItem = (SearchCriteria)this.searchCriteria.getSelectionModel().getSelectedItem();
        Class type = selectedItem.getAttribute().getJavaType();
        if (type == Integer.class) {
            this.searchForValue = this.integerTextField.getValue();
        } else if (type == Long.class) {
            this.searchForValue = this.longTextField.getValue();
        } else if (type == Short.class) {
            this.searchForValue = this.shortTextField.getValue();
        } else if (type == String.class) {
            this.searchForValue = this.stringTextField.getValue();
        } else if (Enum.class.isAssignableFrom(type)) {
            this.searchForValue = this.combo.getSelectionModel().getSelectedItem();
        } else if (type == Date.class) {
            Calendar cal = Calendar.getInstance();
            cal.set((Integer)this.integerTextField.getValue(), 1, 1);
            this.searchForValue = cal.getTime();
        }
    }

    private void setRoot(File rootFile) {
        try {
            File theRootFile = null;
            SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
            if (this.getType() == MusicCollectionType.HVSC) {
                this.setSongLengthDatabase(rootFile.getAbsolutePath());
                this.setSTIL(rootFile.getAbsolutePath());
                sidPlay2Section.setHvsc(rootFile.getAbsolutePath());
                theRootFile = sidPlay2Section.getHvscFile();
            } else if (this.getType() == MusicCollectionType.CGSC) {
                sidPlay2Section.setCgsc(rootFile.getAbsolutePath());
                theRootFile = sidPlay2Section.getCgscFile();
            }
            this.setViewRoot(theRootFile);
            if (this.em != null && this.em.getEntityManagerFactory().isOpen()) {
                this.em.getEntityManagerFactory().close();
            }
            File dbFilename = new File(rootFile.getParentFile(), ((MusicCollectionType)((Object)this.type.get())).toString());
            PersistenceProperties pp = new PersistenceProperties(dbFilename.getAbsolutePath(), Database.HSQL_FILE);
            EntityManagerFactory emFactory = Persistence.createEntityManagerFactory((String)this.collectionDS, (Map)pp);
            this.em = emFactory.createEntityManager();
            this.versionService = new VersionService(this.em);
        }
        catch (FileNotFoundException e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_FILE_NOT_FOUND"), e.getMessage()), this.getType());
        }
        catch (IOException | IllegalAccessException | IllegalStateException | NoSuchFieldException | PersistenceException e) {
            this.openErrorDialog(e.getMessage(), this.getType());
        }
    }

    private void openErrorDialog(String msg, MusicCollectionType type) {
        AlertDialog alertDialog = new AlertDialog(this.util.getPlayer());
        alertDialog.getStage().setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        alertDialog.setText(String.format(this.util.getBundle().getString("ERR_CANNOT_CONFIGURE"), new Object[]{type}) + msg);
        alertDialog.setWait(true);
        alertDialog.open();
    }

    private void setViewRoot(File theRootFile) {
        MusicCollectionCellFactory cellFactory = new MusicCollectionCellFactory();
        cellFactory.setCurrentlyPlayedTreeItems(this.currentlyPlayedTreeItems);
        this.fileBrowser.setRoot((TreeItem)new MusicCollectionTreeItem(this.util.getPlayer(), theRootFile));
        this.fileBrowser.setCellFactory((Callback)cellFactory);
        this.collectionDir.setText(theRootFile.getAbsolutePath());
        this.doResetSearch();
    }

    private void setSTIL(String hvscRoot) throws IOException, NoSuchFieldException, IllegalAccessException {
        try (TFileInputStream input = new TFileInputStream((File)new TFile(hvscRoot, "DOCUMENTS/STIL.txt"));){
            this.util.getPlayer().setSTIL(new STIL((InputStream)input));
        }
    }

    private void setSongLengthDatabase(String hvscRoot) throws IOException {
        try (TFileInputStream input = new TFileInputStream((File)new TFile(hvscRoot, "DOCUMENTS/Songlengths.txt"));){
            this.util.getPlayer().setSidDatabase(new SidDatabase((InputStream)input));
        }
    }

    private void startSearch(boolean forceRecreate) {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            return;
        }
        if (!new File(this.collectionDir.getText()).exists()) {
            return;
        }
        if (!forceRecreate && !this.versionService.isExpectedVersion()) {
            forceRecreate = true;
        }
        if (forceRecreate) {
            if (!this.em.isOpen()) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_DATABASE"), new Object[0]), this.getType());
                return;
            }
            SearchIndexCreator searchIndexCreator = new SearchIndexCreator((File)this.fileBrowser.getRoot().getValue(), this.util.getPlayer(), this.em);
            Consumer<Void> searchStart = x -> {
                Platform.runLater(() -> {
                    this.disableSearch();
                    this.util.progressProperty((Node)this.fileBrowser).set(-1.0);
                });
                searchIndexCreator.getSearchStart().accept((Void)x);
            };
            Consumer<File> searchHit = searchIndexCreator.getSearchHit();
            Consumer<Boolean> searchStop = cancelled -> {
                Platform.runLater(() -> {
                    this.enableSearch();
                    this.util.progressProperty((Node)this.fileBrowser).set(0.0);
                });
                searchIndexCreator.getSearchStop().accept((Boolean)cancelled);
            };
            this.searchThread = new SearchIndexerThread((File)this.fileBrowser.getRoot().getValue(), searchStart, searchHit, searchStop);
            this.searchThread.start();
        } else {
            Consumer<Boolean> searchStop;
            Consumer<File> searchHit;
            Consumer<Void> searchStart;
            SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
            switch ((SearchResult)((Object)this.searchResult.getSelectionModel().getSelectedItem())) {
                case ADD_TO_A_NEW_PLAYLIST: {
                    searchStart = file -> Platform.runLater(() -> {
                        this.disableSearch();
                        this.createNewFavoritesTab();
                    });
                    searchHit = file -> {
                        while (this.favoritesToAddSearchResult == null) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        this.addFavorite(sidplay2Section, this.favoritesToAddSearchResult, (File)file);
                    };
                    searchStop = cancelled -> Platform.runLater(() -> this.enableSearch());
                    break;
                }
                default: {
                    searchStart = x -> Platform.runLater(() -> this.disableSearch());
                    searchHit = file -> {
                        if (file.isFile()) {
                            this.searchThread.setAborted(true);
                            Platform.runLater(() -> {
                                this.enableSearch();
                                this.showNextHit((File)file);
                            });
                        }
                    };
                    searchStop = cancelled -> Platform.runLater(() -> this.enableSearch());
                }
            }
            this.setSearchValue();
            SearchInIndexThread t = new SearchInIndexThread(this.em, this.searchScope.getSelectionModel().getSelectedItem() == SearchScope.FORWARD, searchStart, searchHit, searchStop){

                @Override
                public List<File> getFiles(String filePath) {
                    return PathUtils.getFiles(filePath, (File)MusicCollection.this.fileBrowser.getRoot().getValue(), MusicCollection.this.tuneFilter);
                }
            };
            t.setField(((SearchCriteria)this.searchCriteria.getSelectionModel().getSelectedItem()).getAttribute());
            t.setFieldValue(this.searchForValue);
            t.setCaseSensitive(false);
            if (this.searchOptionsChanged) {
                this.doResetSearch();
                this.searchOptionsChanged = false;
            }
            this.searchThread = t;
            this.searchThread.setSearchState(this.savedState);
            this.searchThread.start();
        }
    }

    private void disableSearch() {
        this.startSearch.setDisable(true);
        this.stopSearch.setDisable(false);
        this.resetSearch.setDisable(true);
        this.createSearchIndex.setDisable(true);
    }

    private void enableSearch() {
        this.savedState = this.searchThread.getSearchState();
        this.startSearch.setDisable(false);
        this.stopSearch.setDisable(true);
        this.resetSearch.setDisable(false);
        this.createSearchIndex.setDisable(false);
    }

    private void showNextHit(File matchFile) {
        if (!matchFile.isFile()) {
            return;
        }
        TreeItem rootItem = this.fileBrowser.getRoot();
        if (rootItem == null || matchFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".mp3")) {
            return;
        }
        ArrayList<TreeItem> pathSegs = new ArrayList<TreeItem>();
        pathSegs.add(rootItem);
        File rootFile = (File)rootItem.getValue();
        String filePath = matchFile.getPath();
        TreeItem curItem = rootItem;
        block0: for (File file : PathUtils.getFiles(filePath, rootFile, this.tuneFilter)) {
            for (TreeItem childItem : curItem.getChildren()) {
                if (!file.equals(childItem.getValue())) continue;
                curItem = childItem;
                pathSegs.add(curItem);
                childItem.setExpanded(true);
                continue block0;
            }
        }
        if (pathSegs.size() > 0) {
            this.currentlyPlayedTreeItems.setAll(pathSegs);
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            TreeItem treeItem = (TreeItem)pathSegs.get(pathSegs.size() - 1);
            if (selectedItem == null || !((File)treeItem.getValue()).equals(selectedItem.getValue())) {
                this.fileBrowser.getSelectionModel().select((Object)treeItem);
                this.fileBrowser.scrollTo(this.fileBrowser.getRow(treeItem));
            }
        }
    }

    private void createNewFavoritesTab() {
        FavoritesSection newFavorites = new FavoritesSection();
        newFavorites.setName(this.util.getBundle().getString("NEW_TAB"));
        this.favoritesToAddSearchResult = newFavorites;
        this.util.getConfig().getFavorites().add(newFavorites);
    }

    private void downloadStart(String url) {
        System.out.println("Download URL: <" + url + ">");
        try {
            new DownloadThread(this.util.getConfig(), new ProgressListener(this.util, (Node)this.fileBrowser){

                @Override
                public void downloaded(File downloadedFile) {
                    if (downloadedFile != null) {
                        downloadedFile.deleteOnExit();
                        Platform.runLater(() -> MusicCollection.this.playTune(downloadedFile));
                    }
                }
            }, new URL(url)).start();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void enableSOASC(SidTuneInfo tuneInfo, File tuneFile) {
        this.soasc6581R2.setDisable(true);
        this.soasc6581R4.setDisable(true);
        this.soasc8580R5.setDisable(true);
        File hvscFile = this.util.getConfig().getSidplay2Section().getHvscFile();
        this.hvscName = PathUtils.getCollectionName(hvscFile, tuneFile);
        if (this.hvscName != null) {
            this.hvscName = this.hvscName.replace(".sid", "");
            this.selectedSong = tuneInfo.getSelectedSong();
            this.soasc6581R2.setDisable(false);
            this.soasc6581R4.setDisable(false);
            this.soasc8580R5.setDisable(false);
        }
    }

    private void showPhoto(SidTuneInfo info) {
        Collection<String> infoString = info.getInfoString();
        if (infoString.size() > 1) {
            Iterator<String> it = infoString.iterator();
            it.next();
            String author = it.next();
            this.photograph.setImage(SidAuthors.getImage(author));
        }
    }

    private void showTuneInfos(File tuneFile, SidTune tune, MusicCollectionTreeItem treeItem) {
        String collectionName = PathUtils.getCollectionName((File)this.fileBrowser.getRoot().getValue(), tuneFile);
        HVSCEntry entry = new HVSCEntry(() -> this.util.getPlayer().getSidDatabaseInfo(db -> db.getTuneLength(tune), 0), collectionName, tuneFile, tune);
        this.tuneInfos.clear();
        for (SearchCriteria field : this.searchCriteria.getItems()) {
            SingularAttribute singleAttribute = field.getAttribute();
            String name = this.searchCriteria.getConverter().toString((Object)field);
            Object value = "";
            try {
                value = ((Method)singleAttribute.getJavaMember()).invoke((Object)entry, new Object[0]);
                TuneInfo tuneInfo = new TuneInfo();
                tuneInfo.setName(name);
                tuneInfo.setValue(String.valueOf(value != null ? value : ""));
                this.tuneInfos.add((Object)tuneInfo);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
        }
    }

    private void addFavorites(SidPlay2Section sidplay2Section, FavoritesSection section, List<File> files) {
        for (File file : files) {
            File[] listFiles = file.listFiles();
            if (file.isDirectory() && listFiles != null) {
                this.addFavorites(sidplay2Section, section, Arrays.asList(listFiles));
                continue;
            }
            if (!file.isFile() || !this.tuneFilter.accept(file)) continue;
            this.addFavorite(sidplay2Section, section, file);
        }
    }

    private void addFavorite(SidPlay2Section sidPlay2Section, FavoritesSection section, File file) {
        try {
            SidTune tune = SidTune.load(file);
            String collectionName = this.getType() == MusicCollectionType.HVSC ? PathUtils.getCollectionName(sidPlay2Section.getHvscFile(), file) : PathUtils.getCollectionName(sidPlay2Section.getCgscFile(), file);
            HVSCEntry entry = new HVSCEntry(() -> this.util.getPlayer().getSidDatabaseInfo(db -> db.getTuneLength(tune), 0), collectionName, file, tune);
            section.getFavorites().add(entry);
        }
        catch (IOException | SidTuneError e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()), this.getType());
        }
    }

    private void playSelected() {
        TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
        if (selectedItem != null && !selectedItem.equals(this.fileBrowser.getRoot()) && ((File)selectedItem.getValue()).isFile()) {
            this.playTune((File)selectedItem.getValue());
        }
    }

    private void playTune(File file) {
        this.util.setPlayingTab(this);
        try {
            this.util.getPlayer().play(SidTune.load(file));
        }
        catch (IOException | SidTuneError e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()), this.getType());
        }
    }
}

