/*
 * Decompiled with CFR 0.152.
 */
package ui.gamebase;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.function.BiPredicate;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import libsidplay.sidtune.SidTuneError;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.download.DownloadThread;
import ui.download.IDownloadListener;
import ui.entities.gamebase.Games;

public class GameBasePage
extends Tab
implements UIPart {
    private static final String GB64_SCREENSHOT_DOWNLOAD_URL = "http://www.gb64.com/Screenshots/";
    private static final String GB64_GAMES_DOWNLOAD_URL = "http://gamebase64.hardabasht.com/games/";
    @FXML
    private TableView<Games> gamebaseTable;
    private Convenience convenience;
    private ImageView screenshot;
    private String fileToRun;
    private final BiPredicate<File, File> FILE_TO_RUN_DETECTOR = (file, toAttach) -> this.fileToRun.length() == 0 && Convenience.LEXICALLY_FIRST_MEDIA.test((File)file, (File)toAttach) || this.fileToRun.equals(file.getName());
    private ObservableList<Games> allGames;
    private ObservableList<Games> filteredGames;
    private UIUtil util;

    public GameBasePage(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
    }

    @FXML
    private void initialize() {
        this.convenience = new Convenience(this.util.getPlayer());
        this.allGames = FXCollections.observableArrayList();
        this.filteredGames = FXCollections.observableArrayList();
        this.gamebaseTable.setItems(this.filteredGames);
        this.gamebaseTable.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                Games game = (Games)this.gamebaseTable.getSelectionModel().getSelectedItem();
                this.startGame(game);
            }
        });
        this.gamebaseTable.setOnMousePressed(event -> {
            if (event.isPrimaryButtonDown() && event.getClickCount() > 1) {
                Games game = (Games)this.gamebaseTable.getSelectionModel().getSelectedItem();
                this.startGame(game);
            }
        });
        this.gamebaseTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                if (newValue.getScreenshotFilename().isEmpty()) {
                    System.out.println("Screenshot is not available on GameBase64: " + newValue.getName());
                } else {
                    try {
                        URL url = new URL(GB64_SCREENSHOT_DOWNLOAD_URL + newValue.getScreenshotFilename().replace('\\', '/'));
                        if (this.screenshot == null) {
                            this.screenshot = (ImageView)this.gamebaseTable.getScene().lookup("#screenshot");
                        }
                        if (this.screenshot != null) {
                            Platform.runLater(() -> this.screenshot.setImage(new Image(url.toString())));
                        }
                    }
                    catch (MalformedURLException e) {
                        System.err.println(e.getMessage());
                    }
                }
            }
        });
    }

    protected void startGame(Games game) {
        if (game.getFilename().isEmpty()) {
            System.out.println("Game is not available on GameBase64: " + game.getName());
            return;
        }
        try {
            this.fileToRun = game.getFileToRun();
            new DownloadThread(this.util.getConfig(), new IDownloadListener(){

                @Override
                public void downloadStop(File downloadedFile) {
                    try {
                        if (downloadedFile != null && GameBasePage.this.convenience.autostart(downloadedFile, GameBasePage.this.FILE_TO_RUN_DETECTOR, null)) {
                            downloadedFile.deleteOnExit();
                            Platform.runLater(() -> GameBasePage.this.util.setPlayingTab(GameBasePage.this));
                        }
                    }
                    catch (IOException | URISyntaxException | SidTuneError exception) {
                        // empty catch block
                    }
                }

                @Override
                public void downloadStep(int step) {
                    DoubleProperty progressProperty = GameBasePage.this.util.progressProperty((Node)GameBasePage.this.gamebaseTable);
                    progressProperty.setValue((Number)Float.valueOf((float)step / 100.0f));
                }
            }, new URL(GB64_GAMES_DOWNLOAD_URL + game.getFilename().replace('\\', '/')), false).start();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    void setGames(List<Games> games) {
        this.allGames.setAll(games);
        this.filteredGames.setAll(this.allGames);
    }

    void filter(String filterText) {
        this.filteredGames.clear();
        if (filterText.trim().length() == 0) {
            this.filteredGames.addAll(this.allGames);
        } else {
            for (Games game : this.allGames) {
                if (!game.getName().contains(filterText)) continue;
                this.filteredGames.add((Object)game);
            }
        }
    }

    public TableView<Games> getGamebaseTable() {
        return this.gamebaseTable;
    }
}

