/*
 * Decompiled with CFR 0.152.
 */
package ui.gamebase;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import libsidutils.WebUtils;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.download.DownloadThread;
import ui.download.ProgressListener;
import ui.entities.Database;
import ui.entities.PersistenceProperties;
import ui.entities.config.SidPlay2Section;
import ui.entities.gamebase.service.GamesService;
import ui.filefilter.MDBFileExtensions;
import ui.gamebase.GameBasePage;

public class GameBase
extends Tab
implements UIPart {
    public static final String ID = "GAMEBASE";
    private static final String EXT_MDB = ".mdb";
    private static final String GB64_URL = "http://www.gb64.com";
    private static final String GB64_MUSIC_DOWNLOAD_URL = "http://www.se2a1.net/soasc/SID/";
    @FXML
    protected CheckBox enableGameBase;
    @FXML
    protected TextField dbFileField;
    @FXML
    protected TextField filterField;
    @FXML
    protected TitledPane contents;
    @FXML
    protected TabPane letter;
    @FXML
    protected TextField infos;
    @FXML
    protected TextField programmer;
    @FXML
    protected TextField category;
    @FXML
    protected TextField musician;
    @FXML
    protected TextArea comment;
    @FXML
    protected Button linkMusic;
    @FXML
    protected TextField gameBaseFile;
    private EntityManager em;
    private GamesService gamesService;
    private UIUtil util;

    public GameBase(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
        this.setId(ID);
        this.setText(this.util.getBundle().getString(this.getId()));
    }

    @FXML
    private void initialize() {
        this.filterField.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                GameBasePage page = (GameBasePage)GameBase.this.letter.getSelectionModel().getSelectedItem();
                if (GameBase.this.filterField.getText().trim().length() == 0) {
                    page.filter("");
                } else {
                    page.filter(GameBase.this.filterField.getText());
                }
            }
        });
        this.contents.setPrefHeight(Double.MAX_VALUE);
        for (Tab tab : this.letter.getTabs()) {
            GameBasePage page = (GameBasePage)tab;
            page.getGamebaseTable().getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    this.comment.setText(newValue.getComment());
                    String genre = newValue.getGenres().getGenre();
                    String pGenre = newValue.getGenres().getParentGenres().getParentGenre();
                    if (pGenre != null && pGenre.length() != 0) {
                        this.category.setText(pGenre + "-" + genre);
                    } else {
                        this.category.setText(genre);
                    }
                    this.infos.setText(String.format(this.util.getBundle().getString("PUBLISHER"), newValue.getYears().getYear(), newValue.getPublishers().getPublisher()));
                    this.musician.setText(newValue.getMusicians().getMusician());
                    this.programmer.setText(newValue.getProgrammers().getProgrammer());
                    String sidFilename = newValue.getSidFilename();
                    this.linkMusic.setText(sidFilename != null ? sidFilename : "");
                    this.linkMusic.setVisible(sidFilename != null && sidFilename.length() > 0);
                }
            });
        }
        this.letter.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.selectTab((GameBasePage)newValue));
        Platform.runLater(() -> {
            SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
            String initialRoot = sidPlay2Section.getGameBase64();
            if (initialRoot != null && new File(initialRoot).exists()) {
                this.gameBaseFile.setText(initialRoot);
                this.setRoot(new File(initialRoot));
            }
        });
    }

    @FXML
    private void doEnableGameBase() {
        if (this.enableGameBase.isSelected()) {
            File dbFile = new File(this.util.getConfig().getSidplay2Section().getTmpDir(), "GameBase64.mdb");
            if (dbFile.exists()) {
                SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
                sidPlay2Section.setGameBase64(dbFile.getAbsolutePath());
                this.gameBaseFile.setText(dbFile.getAbsolutePath());
                this.setRoot(dbFile);
            } else {
                this.enableGameBase.setDisable(true);
                try {
                    URL url = new URL(this.util.getConfig().getOnlineSection().getGamebaseUrl());
                    DownloadThread downloadThread = new DownloadThread(this.util.getConfig(), new GameBaseListener(this.util, (Node)this.letter), url);
                    downloadThread.start();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @FXML
    private void downloadMusic() {
        try {
            URL url = new URL(GB64_MUSIC_DOWNLOAD_URL + this.linkMusic.getText().replace('\\', '/'));
            try (InputStream is = url.openStream();){
                this.util.getPlayer().play(SidTune.load(this.linkMusic.getText(), is));
                this.util.setPlayingTab(this);
            }
        }
        catch (IOException | SidTuneError e) {
            System.err.println(e.getMessage());
            SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
            File file = PathUtils.getFile(this.linkMusic.getText().replace('\\', '/'), sidPlay2Section.getHvscFile(), sidPlay2Section.getCgscFile());
            try {
                this.util.getPlayer().play(SidTune.load(file));
                this.util.setPlayingTab(this);
            }
            catch (IOException | SidTuneError e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    private void doBrowse() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("GameBase64 Database (MDB)", MDBFileExtensions.EXTENSIONS));
        File file = fileDialog.showOpenDialog(this.letter.getScene().getWindow());
        if (file != null) {
            this.gameBaseFile.setText(file.getAbsolutePath());
            SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
            sidPlay2Section.setGameBase64(file.getAbsolutePath());
            File theRootFile = sidPlay2Section.getGameBase64File();
            this.gameBaseFile.setText(file.getAbsolutePath());
            this.setRoot(theRootFile);
        }
    }

    @FXML
    private void gotoURL() {
        WebUtils.browse(GB64_URL);
    }

    private void setRoot(File file) {
        this.connect(file);
        this.enableGameBaseUI();
    }

    private void enableGameBaseUI() {
        this.enableGameBase.setDisable(false);
        this.setLettersDisable(false);
        this.letter.getSelectionModel().selectFirst();
        this.selectTab((GameBasePage)this.letter.getSelectionModel().getSelectedItem());
    }

    protected void setLettersDisable(boolean b) {
        for (Tab tab : this.letter.getTabs()) {
            tab.setDisable(b);
        }
    }

    protected void connect(File dbFile) {
        if (this.em != null) {
            this.em.getEntityManagerFactory().close();
        }
        this.em = Persistence.createEntityManagerFactory((String)"gamebase-ds", (Map)new PersistenceProperties(dbFile.getAbsolutePath(), Database.MSACCESS)).createEntityManager();
        this.gamesService = new GamesService(this.em);
    }

    @Override
    public void doClose() {
        if (this.em != null) {
            this.em.getEntityManagerFactory().close();
        }
    }

    protected void selectTab(GameBasePage page) {
        if (this.gamesService != null) {
            page.setGames(this.gamesService.select(page.getText().charAt(0)));
        }
        this.filterField.setText("");
    }

    protected final class GameBaseListener
    extends ProgressListener {
        protected GameBaseListener(UIUtil util, Node node) {
            super(util, node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloaded(File downloadedFile) {
            try {
                if (downloadedFile == null) {
                    return;
                }
                SidPlay2Section sidplay2 = this.util.getConfig().getSidplay2Section();
                String tmpDir = sidplay2.getTmpDir();
                TFile zip = new TFile(downloadedFile);
                TFile.cp_rp((File)zip, (File)new File(tmpDir), (TArchiveDetector)TArchiveDetector.ALL);
                Platform.runLater(() -> {
                    GameBase.this.enableGameBase.setDisable(true);
                    GameBase.this.setLettersDisable(true);
                });
                File dbFile = new File(tmpDir, zip.listFiles((dir, name) -> name.endsWith(GameBase.EXT_MDB))[0].getName());
                sidplay2.setGameBase64(dbFile.getAbsolutePath());
                GameBase.this.connect(dbFile);
                Platform.runLater(() -> {
                    GameBase.this.gameBaseFile.setText(dbFile.getAbsolutePath());
                    GameBase.this.enableGameBaseUI();
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Platform.runLater(() -> GameBase.this.enableGameBase.setDisable(false));
            }
        }
    }
}

