/*
 * Decompiled with CFR 0.152.
 */
package ui.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.util.Locale;

public class DiskFileFilter
implements FileFilter {
    public static final String[] DEFAULT_FILE_NAME_EXT = new String[]{".d64", ".g64", ".nib", ".zip", ".d64.gz", ".g64.gz", ".nib.gz"};

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.accept(null, file.getName().toLowerCase(Locale.US));
    }

    public boolean accept(File dir, String name) {
        String[] exts;
        for (String ext : exts = DEFAULT_FILE_NAME_EXT) {
            if (!name.toLowerCase(Locale.US).endsWith(ext)) continue;
            return true;
        }
        return false;
    }
}

