/*
 * Decompiled with CFR 0.152.
 */
package ui.favorites;

import com.sun.javafx.scene.control.skin.TableColumnHeader;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.DirectoryChooser;
import javafx.util.Callback;
import javax.persistence.metamodel.SingularAttribute;
import libpsid64.Psid64;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.common.dialog.AlertDialog;
import ui.entities.collection.HVSCEntry;
import ui.entities.collection.HVSCEntry_;
import ui.entities.config.FavoriteColumn;
import ui.entities.config.FavoritesSection;
import ui.entities.config.SidPlay2Section;
import ui.favorites.Favorites;
import ui.favorites.FavoritesCellFactory;
import ui.filefilter.TuneFileFilter;
import ui.stilview.STILView;

public class FavoritesTab
extends Tab
implements UIPart {
    @FXML
    private TextField filterField;
    @FXML
    private TableView<HVSCEntry> favoritesTable;
    @FXML
    private Menu addColumnMenu;
    @FXML
    private Menu moveToTab;
    @FXML
    private Menu copyToTab;
    @FXML
    private MenuItem showStil;
    @FXML
    private MenuItem removeColumn;
    @FXML
    private Button moveUp;
    @FXML
    private Button moveDown;
    @FXML
    private ContextMenu contextMenuHeader;
    @FXML
    private ContextMenu contextMenu;
    private UIUtil util;
    private ObservableList<HVSCEntry> filteredFavorites;
    private FileFilter tuneFilter = new TuneFileFilter();
    private FavoritesSection favoritesSection;
    private ObjectProperty<HVSCEntry> currentlyPlayedHVSCEntryProperty;
    private Favorites favorites;

    public FavoritesTab(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
    }

    @FXML
    private void initialize() {
        this.filteredFavorites = FXCollections.observableArrayList();
        this.favoritesTable.setItems(this.filteredFavorites);
        this.favoritesTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.favoritesTable.getColumns().addListener(change -> {
            while (change.next()) {
                if (!change.wasReplaced()) continue;
                this.moveColumn();
            }
        });
        this.favoritesTable.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && newValue.intValue() != -1) {
                this.favoritesSection.setSelectedRowFrom(newValue.intValue());
                this.favoritesSection.setSelectedRowTo(newValue.intValue());
            }
            this.moveUp.setDisable(newValue == null || newValue.intValue() == 0 || this.favoritesTable.getSortOrder().size() > 0);
            this.moveDown.setDisable(newValue == null || newValue.intValue() == this.favoritesSection.getFavorites().size() - 1 || this.favoritesTable.getSortOrder().size() > 0);
        });
        this.favoritesTable.setOnMousePressed(event -> {
            HVSCEntry hvscEntry;
            if (event.isPrimaryButtonDown() && event.getClickCount() > 1 && this.getHVSCFile(hvscEntry = (HVSCEntry)this.favoritesTable.getSelectionModel().getSelectedItem()) != null) {
                this.playTune(hvscEntry);
                this.favoritesTable.scrollTo((Object)hvscEntry);
            }
        });
        this.favoritesTable.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                HVSCEntry hvscEntry = (HVSCEntry)this.favoritesTable.getSelectionModel().getSelectedItem();
                if (this.getHVSCFile(hvscEntry) != null) {
                    this.playTune(hvscEntry);
                }
            } else if (event.getCode() == KeyCode.DELETE) {
                this.removeSelectedFavorites();
            }
        });
        this.filterField.setOnKeyReleased(event -> this.filter(this.filterField.getText()));
        for (Field field : HVSCEntry_.class.getDeclaredFields()) {
            if (field.getName().equals(HVSCEntry_.id.getName()) || !SingularAttribute.class.isAssignableFrom(field.getType())) continue;
            try {
                SingularAttribute singleAttribute = (SingularAttribute)field.get(null);
                this.addAddColumnHeaderMenuItem(this.addColumnMenu, singleAttribute);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.contextMenuHeader.setOnShown(event -> {
            TableColumnBase<?, ?> tableColumn = this.getContextMenuColumn();
            this.removeColumn.setDisable(this.favoritesTable.getColumns().indexOf(tableColumn) == 0);
        });
        this.contextMenu.setOnShown(event -> {
            HVSCEntry hvscEntry = (HVSCEntry)this.favoritesTable.getSelectionModel().getSelectedItem();
            this.showStil.setDisable(hvscEntry == null || this.util.getPlayer().getStilEntry(hvscEntry.getPath()) == null);
            ObservableList<Tab> tabs = this.favorites.getFavoriteTabs();
            this.moveToTab.getItems().clear();
            this.copyToTab.getItems().clear();
            for (Tab tab : tabs) {
                if (tab.equals(this)) continue;
                String name = tab.getText();
                MenuItem moveToTabItem = new MenuItem(name);
                moveToTabItem.setOnAction(event2 -> {
                    ObservableList selectedItems = this.favoritesTable.getSelectionModel().getSelectedItems();
                    this.copyToTab((List<HVSCEntry>)selectedItems, (FavoritesTab)tab);
                    this.removeFavorites((ObservableList<HVSCEntry>)selectedItems);
                });
                this.moveToTab.getItems().add((Object)moveToTabItem);
                MenuItem copyToTabItem = new MenuItem(name);
                copyToTabItem.setOnAction(event2 -> {
                    ObservableList selectedItems = this.favoritesTable.getSelectionModel().getSelectedItems();
                    this.copyToTab((List<HVSCEntry>)selectedItems, (FavoritesTab)tab);
                });
                this.copyToTab.getItems().add((Object)copyToTabItem);
            }
            this.moveToTab.setDisable(this.moveToTab.getItems().isEmpty());
            this.copyToTab.setDisable(this.copyToTab.getItems().isEmpty());
        });
        this.currentlyPlayedHVSCEntryProperty = new SimpleObjectProperty();
        for (TableColumn column : this.favoritesTable.getColumns()) {
            FavoritesCellFactory cellFactory = (FavoritesCellFactory)column.getCellFactory();
            cellFactory.setPlayer(this.util.getPlayer());
            cellFactory.setCurrentlyPlayedHVSCEntryProperty(this.currentlyPlayedHVSCEntryProperty);
        }
    }

    private File getHVSCFile(HVSCEntry hvscEntry) {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        return hvscEntry != null ? PathUtils.getFile(hvscEntry.getPath(), sidPlay2Section.getHvscFile(), sidPlay2Section.getCgscFile()) : null;
    }

    @FXML
    private void doMoveUp() {
        int from = this.favoritesTable.getSelectionModel().getSelectedIndex();
        if (from == -1) {
            return;
        }
        this.moveRow(from, from - 1);
    }

    @FXML
    private void doMoveDown() {
        int from = this.favoritesTable.getSelectionModel().getSelectedIndex();
        if (from == -1) {
            return;
        }
        this.moveRow(from, from + 1);
    }

    @FXML
    private void removeColumn() {
        TableColumnBase<?, ?> tableColumn = this.getContextMenuColumn();
        FavoriteColumn favoriteColumn = (FavoriteColumn)tableColumn.getUserData();
        this.favoritesTable.getColumns().remove(tableColumn);
        this.favoritesSection.getColumns().remove(favoriteColumn);
    }

    @FXML
    private void exportToDir() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(sidplay2Section.getLastDirectoryFolder());
        File directory = fileDialog.showDialog(this.favoritesTable.getScene().getWindow());
        if (directory != null) {
            sidplay2Section.setLastDirectory(directory.getAbsolutePath());
            for (HVSCEntry hvscEntry : this.favoritesTable.getSelectionModel().getSelectedItems()) {
                File file = this.getHVSCFile(hvscEntry);
                this.copyToUniqueName(file, directory, file.getName(), 1);
            }
        }
    }

    private void copyToUniqueName(File file, File directory, String name, int number) {
        File newFile;
        String newName = name;
        if (number > 1) {
            newName = PathUtils.getFilenameWithoutSuffix(name) + "_" + number + PathUtils.getFilenameSuffix(name);
        }
        if ((newFile = new File(directory, newName)).exists()) {
            this.copyToUniqueName(file, directory, name, ++number);
        } else {
            try {
                TFile.cp((File)file, (File)newFile);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    private void showStil() {
        HVSCEntry hvscEntry = (HVSCEntry)this.favoritesTable.getSelectionModel().getSelectedItem();
        if (hvscEntry == null) {
            return;
        }
        STILView stilInfo = new STILView(this.util.getPlayer());
        stilInfo.setEntry(this.util.getPlayer().getStilEntry(hvscEntry.getPath()));
        stilInfo.open();
    }

    @FXML
    private void convertToPsid64() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(sidPlay2Section.getLastDirectoryFolder());
        File directory = fileDialog.showDialog(this.favoritesTable.getScene().getWindow());
        if (directory != null) {
            sidPlay2Section.setLastDirectory(directory.getAbsolutePath());
            ArrayList<File> files = new ArrayList<File>();
            for (HVSCEntry hvscEntry : this.favoritesTable.getSelectionModel().getSelectedItems()) {
                files.add(this.getHVSCFile(hvscEntry));
            }
            Psid64 c = new Psid64();
            c.setTmpDir(sidPlay2Section.getTmpDir());
            c.setVerbose(false);
            try {
                c.convertFiles(this.util.getPlayer(), files.toArray(new File[0]), directory, sidPlay2Section.getHvscFile());
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    FavoritesSection getFavoritesSection() {
        return this.favoritesSection;
    }

    void addFavorites(List<File> files) {
        for (int i = 0; files != null && i < files.size(); ++i) {
            File file = files.get(i);
            File[] listFiles = file.listFiles();
            if (file.isDirectory() && listFiles != null) {
                this.addFavorites(Arrays.asList(listFiles));
                continue;
            }
            if (!this.tuneFilter.accept(file)) continue;
            this.addFavorite(file);
        }
    }

    void restoreColumns(FavoritesSection favoritesSection) {
        this.favoritesSection = favoritesSection;
        this.setText(favoritesSection.getName());
        this.filteredFavorites.addAll(favoritesSection.getFavorites());
        for (FavoriteColumn favoriteColumn : favoritesSection.getColumns()) {
            try {
                SingularAttribute<?, ?> attribute = this.getAttribute(favoriteColumn.getColumnProperty());
                this.addColumn(attribute, favoriteColumn);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Iterator columnsIt = this.favoritesTable.getColumns().iterator();
        TableColumn pathColumn = (TableColumn)columnsIt.next();
        pathColumn.widthProperty().addListener((observable, oldValue, newValue) -> favoritesSection.setWidth(newValue.doubleValue()));
        Double width = favoritesSection.getWidth();
        if (width != null) {
            pathColumn.setPrefWidth(width.doubleValue());
        }
        for (FavoriteColumn favoriteColumn : favoritesSection.getColumns()) {
            TableColumn column = (TableColumn)columnsIt.next();
            width = favoriteColumn.getWidth();
            if (width == null) continue;
            column.setPrefWidth(width.doubleValue());
        }
        favoritesSection.getObservableFavorites().addListener(change -> {
            while (change.next()) {
                if (change.wasPermutated() || change.wasUpdated()) continue;
                if (change.wasAdded()) {
                    this.filteredFavorites.addAll((Collection)change.getAddedSubList());
                    continue;
                }
                if (!change.wasRemoved()) continue;
                this.filteredFavorites.removeAll((Collection)change.getRemoved());
            }
        });
        Integer from = favoritesSection.getSelectedRowFrom();
        if (from != null && from != -1) {
            this.favoritesTable.getSelectionModel().select(from.intValue());
            HVSCEntry hvscEntry = favoritesSection.getFavorites().get(from);
            this.favoritesTable.scrollTo((Object)hvscEntry);
        }
    }

    void removeSelectedFavorites() {
        this.removeFavorites((ObservableList<HVSCEntry>)this.favoritesTable.getSelectionModel().getSelectedItems());
    }

    void removeAllFavorites() {
        this.favoritesSection.getFavorites().clear();
        this.util.getConfig().getFavorites().remove(this.favoritesSection);
    }

    void filter(String filterText) {
        this.filteredFavorites.clear();
        if (filterText.trim().length() == 0) {
            this.filteredFavorites.addAll(this.favoritesSection.getFavorites());
        } else {
            block2: for (HVSCEntry hvscEntry : this.favoritesSection.getFavorites()) {
                for (TableColumn tableColumn : this.favoritesTable.getColumns()) {
                    FavoriteColumn favoriteColumn = (FavoriteColumn)tableColumn.getUserData();
                    String name = favoriteColumn != null ? favoriteColumn.getColumnProperty() : HVSCEntry_.path.getName();
                    try {
                        Object value = ((Method)this.getAttribute(name).getJavaMember()).invoke((Object)hvscEntry, new Object[0]);
                        String text = value != null ? value.toString() : "";
                        if (!text.contains(filterText)) continue;
                        this.filteredFavorites.add((Object)hvscEntry);
                        continue block2;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    void selectAllFavorites() {
        this.favoritesTable.getSelectionModel().selectAll();
    }

    void clearSelection() {
        this.favoritesTable.getSelectionModel().clearSelection();
    }

    void loadFavorites(File favoritesFile) throws IOException {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        favoritesFile = this.addFileExtension(favoritesFile);
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(favoritesFile), "ISO-8859-1"));){
            String line;
            while ((line = r.readLine()) != null) {
                File file;
                if (line.startsWith("<HVSC>/") || line.startsWith("<CGSC>/")) {
                    line = line.substring(7);
                }
                if ((file = PathUtils.getFile(line, sidPlay2Section.getHvscFile(), sidPlay2Section.getCgscFile())) == null) continue;
                this.addFavorite(file);
            }
        }
    }

    void saveFavorites(File favoritesFile) throws IOException {
        favoritesFile = this.addFileExtension(favoritesFile);
        try (PrintStream p = new PrintStream(favoritesFile);){
            for (HVSCEntry hvscEntry : this.favoritesTable.getItems()) {
                p.println(new TFile(hvscEntry.getPath()).getPath());
            }
        }
    }

    void playNext() {
        boolean recentlyPlayedFound = false;
        for (HVSCEntry hvscEntry : this.favoritesSection.getFavorites()) {
            if (recentlyPlayedFound) {
                this.playTune(hvscEntry);
                break;
            }
            if (hvscEntry != this.currentlyPlayedHVSCEntryProperty.get()) continue;
            recentlyPlayedFound = true;
        }
    }

    void playNextRandom() {
        if (this.favoritesSection.getFavorites().isEmpty()) {
            return;
        }
        HVSCEntry hvscEntry = this.favoritesSection.getFavorites().get(Math.abs(new Random().nextInt(Integer.MAX_VALUE)) % this.favoritesSection.getFavorites().size());
        this.playTune(hvscEntry);
    }

    private File addFileExtension(File favoritesFile) {
        String extension = "*.js2";
        if (extension.startsWith("*")) {
            extension = extension.substring(1);
        }
        if (!favoritesFile.getName().endsWith(extension)) {
            favoritesFile = new File(favoritesFile.getParentFile(), favoritesFile.getName() + extension);
        }
        return favoritesFile;
    }

    private void addFavorite(File file) {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        try {
            SidTune tune = SidTune.load(file);
            String collectionName = PathUtils.getCollectionName(sidPlay2Section.getHvscFile(), file);
            HVSCEntry entry = new HVSCEntry(() -> this.util.getPlayer().getSidDatabaseInfo(db -> db.getTuneLength(tune), 0), collectionName, file, tune);
            this.favoritesSection.getFavorites().add(entry);
        }
        catch (IOException | SidTuneError e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
        }
    }

    void removeFavorites(ObservableList<HVSCEntry> selectedItems) {
        this.favoritesSection.getFavorites().removeAll((Collection<?>)selectedItems);
        this.filter(this.filterField.getText());
    }

    private SingularAttribute<?, ?> getAttribute(String columnProperty) throws NoSuchFieldException, IllegalAccessException {
        for (Field field : HVSCEntry_.class.getDeclaredFields()) {
            if (field.getName().equals(HVSCEntry_.id.getName()) || !SingularAttribute.class.isAssignableFrom(field.getType()) || !columnProperty.equals(field.getName())) continue;
            return (SingularAttribute)field.get(null);
        }
        return null;
    }

    TableColumnBase<?, ?> getContextMenuColumn() {
        TableColumnHeader columnHeader = (TableColumnHeader)this.contextMenuHeader.getOwnerNode();
        return columnHeader.getTableColumn();
    }

    private void addAddColumnHeaderMenuItem(Menu addColumnMenu, SingularAttribute<?, ?> attribute) {
        MenuItem menuItem = new MenuItem();
        menuItem.setText(attribute.getName());
        menuItem.setOnAction(event -> {
            FavoriteColumn favoriteColumn = new FavoriteColumn();
            favoriteColumn.setColumnProperty(attribute.getName());
            this.favoritesSection.getColumns().add(favoriteColumn);
            this.addColumn(attribute, favoriteColumn);
        });
        addColumnMenu.getItems().add((Object)menuItem);
    }

    void addColumn(SingularAttribute<?, ?> attribute, FavoriteColumn favoriteColumn) {
        String text = this.util.getBundle().getString(attribute.getDeclaringType().getJavaType().getSimpleName() + "." + attribute.getName());
        TableColumn tableColumn = new TableColumn();
        tableColumn.setUserData((Object)favoriteColumn);
        tableColumn.setText(text);
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory(attribute.getName()));
        FavoritesCellFactory cellFactory = new FavoritesCellFactory();
        cellFactory.setPlayer(this.util.getPlayer());
        cellFactory.setCurrentlyPlayedHVSCEntryProperty(this.currentlyPlayedHVSCEntryProperty);
        tableColumn.setCellFactory((Callback)cellFactory);
        tableColumn.setContextMenu(this.contextMenuHeader);
        tableColumn.widthProperty().addListener((observable, oldValue, newValue) -> favoriteColumn.setWidth(newValue.doubleValue()));
        this.favoritesTable.getColumns().add((Object)tableColumn);
    }

    void moveColumn() {
        ArrayList<FavoriteColumn> newOrderList = new ArrayList<FavoriteColumn>();
        for (TableColumn tableColumn : this.favoritesTable.getColumns()) {
            FavoriteColumn favoriteColumn = (FavoriteColumn)tableColumn.getUserData();
            if (favoriteColumn == null) continue;
            newOrderList.add(favoriteColumn);
        }
        this.favoritesSection.getColumns().clear();
        this.favoritesSection.getColumns().addAll(newOrderList);
    }

    void moveRow(int from, int to) {
        Collections.swap(this.favoritesSection.getFavorites(), from, to);
        this.filter(this.filterField.getText());
        this.favoritesTable.getSelectionModel().select(to);
    }

    void copyToTab(List<HVSCEntry> toCopy, FavoritesTab tab) {
        for (HVSCEntry hvscEntry : toCopy) {
            tab.addFavorite(this.getHVSCFile(hvscEntry));
        }
    }

    void deselectCurrentlyPlayedHVSCEntry() {
        this.currentlyPlayedHVSCEntryProperty.set(null);
    }

    void playTune(HVSCEntry hvscEntry) {
        this.favorites.setCurrentlyPlayedFavorites(this);
        this.util.setPlayingTab(this);
        try {
            this.util.getPlayer().play(SidTune.load(this.getHVSCFile(hvscEntry)));
            this.currentlyPlayedHVSCEntryProperty.set((Object)hvscEntry);
            this.favoritesTable.scrollTo((Object)hvscEntry);
        }
        catch (IOException | SidTuneError e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
        }
    }

    private void openErrorDialog(String msg) {
        AlertDialog alertDialog = new AlertDialog(this.util.getPlayer());
        alertDialog.getStage().setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        alertDialog.setText(msg);
        alertDialog.setWait(true);
        alertDialog.open();
    }

    public void setFavorites(Favorites favorites) {
        this.favorites = favorites;
    }
}

