/*
 * Decompiled with CFR 0.152.
 */
package ui.favorites;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import libsidutils.PathUtils;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import sidplay.Player;
import sidplay.player.State;
import ui.common.C64Window;
import ui.common.TimeToStringConverter;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.entities.config.FavoritesSection;
import ui.entities.config.SidPlay2Section;
import ui.favorites.FavoritesTab;
import ui.favorites.PlaybackType;
import ui.filefilter.TuneFileExtensions;

public class Favorites
extends Tab
implements UIPart {
    public static final String ID = "FAVORITES";
    private static final String CELL_VALUE_OK = "cellValueOk";
    private static final String CELL_VALUE_ERROR = "cellValueError";
    @FXML
    private Button add;
    @FXML
    private Button remove;
    @FXML
    private Button selectAll;
    @FXML
    private Button deselectAll;
    @FXML
    private Button load;
    @FXML
    private Button save;
    @FXML
    private Button saveAs;
    @FXML
    private TabPane favoritesList;
    @FXML
    protected TextField renameTab;
    @FXML
    protected TextField fadeInTime;
    @FXML
    protected TextField fadeOutTime;
    @FXML
    private RadioButton off;
    @FXML
    private RadioButton normal;
    @FXML
    private RadioButton randomOne;
    @FXML
    private RadioButton randomAll;
    @FXML
    private RadioButton randomHVSC;
    @FXML
    private RadioButton repeatOff;
    @FXML
    private RadioButton repeatOne;
    private UIUtil util;
    private FavoritesTab currentlyPlayedFavorites;
    protected Random random = new Random();
    private C64Window window;
    private ChangeListener<? super State> nextTuneListener = (observable, oldValue, newValue) -> {
        if (newValue == State.END) {
            Platform.runLater(() -> this.playNextTune());
        }
    };

    public Favorites(C64Window window, Player player) {
        this.window = window;
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
        this.setId(ID);
        this.setText(this.util.getBundle().getString(this.getId()));
    }

    @FXML
    private void initialize() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        if (sidplay2Section.getHvsc() != null) {
            this.setSongLengthDatabase(sidplay2Section.getHvsc());
            this.setSTIL(sidplay2Section.getHvsc());
        }
        Bindings.bindBidirectional((Property)this.fadeInTime.textProperty(), (Property)sidplay2Section.fadeInTimeProperty(), (StringConverter)new TimeToStringConverter());
        sidplay2Section.fadeInTimeProperty().addListener((obj, o, n) -> {
            Tooltip tooltip = new Tooltip();
            this.fadeInTime.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (n.intValue() != -1) {
                this.util.getPlayer().getTimer().updateEnd();
                tooltip.setText(this.util.getBundle().getString("FADE_IN_LENGTH_TIP"));
                this.fadeInTime.setTooltip(tooltip);
                this.fadeInTime.getStyleClass().add((Object)CELL_VALUE_OK);
            } else {
                tooltip.setText(this.util.getBundle().getString("FADE_IN_LENGTH_FORMAT"));
                this.fadeInTime.setTooltip(tooltip);
                this.fadeInTime.getStyleClass().add((Object)CELL_VALUE_ERROR);
            }
        });
        Bindings.bindBidirectional((Property)this.fadeOutTime.textProperty(), (Property)sidplay2Section.fadeOutTimeProperty(), (StringConverter)new TimeToStringConverter());
        sidplay2Section.fadeOutTimeProperty().addListener((obj, o, n) -> {
            Tooltip tooltip = new Tooltip();
            this.fadeOutTime.getStyleClass().removeAll((Object[])new String[]{CELL_VALUE_OK, CELL_VALUE_ERROR});
            if (n.intValue() != -1) {
                this.util.getPlayer().getTimer().updateEnd();
                tooltip.setText(this.util.getBundle().getString("FADE_OUT_LENGTH_TIP"));
                this.fadeOutTime.setTooltip(tooltip);
                this.fadeOutTime.getStyleClass().add((Object)CELL_VALUE_OK);
            } else {
                tooltip.setText(this.util.getBundle().getString("FADE_OUT_LENGTH_FORMAT"));
                this.fadeOutTime.setTooltip(tooltip);
                this.fadeOutTime.getStyleClass().add((Object)CELL_VALUE_ERROR);
            }
        });
        PlaybackType pt = sidplay2Section.getPlaybackType();
        switch (pt) {
            case PLAYBACK_OFF: {
                this.off.setSelected(true);
                break;
            }
            case NORMAL: {
                this.normal.setSelected(true);
                break;
            }
            case RANDOM_ONE: {
                this.randomOne.setSelected(true);
                break;
            }
            case RANDOM_ALL: {
                this.randomAll.setSelected(true);
                break;
            }
            case RANDOM_HVSC: {
                this.randomHVSC.setSelected(true);
                break;
            }
            default: {
                this.off.setSelected(true);
            }
        }
        if (this.util.getConfig().getSidplay2Section().isLoop()) {
            this.repeatOne.setSelected(true);
        } else {
            this.repeatOff.setSelected(true);
        }
        this.util.getPlayer().stateProperty().addListener(this.nextTuneListener);
        List<FavoritesSection> favorites = this.util.getConfig().getFavorites();
        this.util.getConfig().getObservableFavorites().addListener(change -> {
            while (change.next()) {
                if (change.wasPermutated() || change.wasUpdated() || !change.wasAdded()) continue;
                List addedSubList = change.getAddedSubList();
                for (FavoritesSection favoritesSection : addedSubList) {
                    this.addTab(favoritesSection);
                }
            }
        });
        this.favoritesList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.util.getConfig().setCurrentFavorite(newValue.getText());
            }
        });
        Platform.runLater(() -> {
            String currentFavorite = this.util.getConfig().getCurrentFavorite();
            for (FavoritesSection favorite : favorites) {
                this.addTab(favorite);
            }
            if (currentFavorite != null) {
                for (Tab tab : this.favoritesList.getTabs()) {
                    if (!tab.getText().equals(currentFavorite)) continue;
                    this.favoritesList.getSelectionModel().select((Object)tab);
                    this.currentlyPlayedFavorites = this.getSelectedTab();
                    break;
                }
            }
        });
        Platform.runLater(() -> {
            this.favoritesList.setOnDragOver(event -> {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            });
            this.favoritesList.setOnDragDropped(event -> {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    List files = db.getFiles();
                    FavoritesTab selectedTab = this.getSelectedTab();
                    selectedTab.addFavorites(files);
                }
                event.setDropCompleted(success);
                event.consume();
            });
        });
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.nextTuneListener);
    }

    @FXML
    private void addFavorites() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Tunes", TuneFileExtensions.EXTENSIONS));
        List files = fileDialog.showOpenMultipleDialog(this.favoritesList.getScene().getWindow());
        if (files != null && files.size() > 0) {
            File file = (File)files.get(0);
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParent());
            FavoritesTab selectedTab = this.getSelectedTab();
            selectedTab.addFavorites(files);
            this.renameTab(selectedTab, PathUtils.getFilenameWithoutSuffix(file.getParentFile().getName()));
        }
    }

    @FXML
    private void removeFavorites() {
        this.getSelectedTab().removeSelectedFavorites();
    }

    @FXML
    private void selectAllFavorites() {
        this.getSelectedTab().selectAllFavorites();
    }

    @FXML
    private void clearSelection() {
        this.getSelectedTab().clearSelection();
    }

    @FXML
    private void loadFavorites() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Favorite Tunes", new String[]{"*.js2"}));
        File file = fileDialog.showOpenDialog(this.favoritesList.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParent());
            try {
                this.getSelectedTab().loadFavorites(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    private void saveFavoritesAs() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectoryFolder());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Favorite Tunes", new String[]{"*.js2"}));
        File file = fileDialog.showSaveDialog(this.favoritesList.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParent());
            File target = new File(file.getParentFile(), PathUtils.getFilenameWithoutSuffix(file.getName()) + ".js2");
            try {
                this.getSelectedTab().saveFavorites(target);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    private void addTab() {
        List<FavoritesSection> favorites = this.util.getConfig().getFavorites();
        FavoritesSection favoritesSection = new FavoritesSection();
        favoritesSection.setName(this.util.getBundle().getString("NEW_TAB"));
        favorites.add(favoritesSection);
    }

    @FXML
    private void renameTab() {
        this.renameTab(this.getSelectedTab(), this.renameTab.getText());
    }

    @FXML
    private void off() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.PLAYBACK_OFF);
    }

    @FXML
    private void normal() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.NORMAL);
    }

    @FXML
    private void randomOne() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.RANDOM_ONE);
    }

    @FXML
    private void randomAll() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.RANDOM_ALL);
    }

    @FXML
    private void randomHVSC() {
        this.util.getConfig().getSidplay2Section().setPlaybackType(PlaybackType.RANDOM_HVSC);
    }

    @FXML
    private void repeatOff() {
        this.util.getConfig().getSidplay2Section().setLoop(false);
    }

    @FXML
    private void repeatOne() {
        this.util.getConfig().getSidplay2Section().setLoop(true);
    }

    private void setSongLengthDatabase(String hvscRoot) {
        try (TFileInputStream input = new TFileInputStream((File)new TFile(hvscRoot, "DOCUMENTS/Songlengths.txt"));){
            this.util.getPlayer().setSidDatabase(new SidDatabase((InputStream)input));
        }
        catch (FileNotFoundException e) {
            System.err.println(String.format(this.util.getBundle().getString("ERR_FILE_NOT_FOUND"), e.getMessage()));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private void setSTIL(String hvscRoot) {
        try (TFileInputStream input = new TFileInputStream((File)new TFile(hvscRoot, "DOCUMENTS/STIL.txt"));){
            this.util.getPlayer().setSTIL(new STIL((InputStream)input));
        }
        catch (FileNotFoundException e) {
            System.err.println(String.format(this.util.getBundle().getString("ERR_FILE_NOT_FOUND"), e.getMessage()));
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException e) {
            System.err.println(e.getMessage());
        }
    }

    private FavoritesTab getSelectedTab() {
        return (FavoritesTab)this.favoritesList.getSelectionModel().getSelectedItem();
    }

    protected void addTab(FavoritesSection favoritesSection) {
        final FavoritesTab newTab = new FavoritesTab(this.window, this.util.getPlayer());
        if (favoritesSection.getName() == null) {
            favoritesSection.setName(this.util.getBundle().getString("NEW_TAB"));
        }
        newTab.setText(favoritesSection.getName());
        newTab.restoreColumns(favoritesSection);
        newTab.setClosable(this.favoritesList.getTabs().size() != 0);
        newTab.setOnClosed((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                newTab.removeAllFavorites();
            }
        });
        newTab.setFavorites(this);
        this.favoritesList.getTabs().add((Object)newTab);
        this.favoritesList.getSelectionModel().select((Object)newTab);
    }

    private void renameTab(FavoritesTab selectedTab, String name) {
        selectedTab.setText(name);
        selectedTab.getFavoritesSection().setName(name);
    }

    protected void playNextTune() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        PlaybackType pt = sidPlay2Section.getPlaybackType();
        if (!sidPlay2Section.isLoop()) {
            if (pt == PlaybackType.RANDOM_ALL) {
                this.favoritesList.getSelectionModel().select(Math.abs(this.random.nextInt(Integer.MAX_VALUE)) % this.favoritesList.getTabs().size());
                this.currentlyPlayedFavorites = this.getSelectedTab();
                this.currentlyPlayedFavorites.playNextRandom();
            } else if (pt == PlaybackType.RANDOM_ONE && this.currentlyPlayedFavorites != null) {
                this.currentlyPlayedFavorites.playNextRandom();
            } else if (pt == PlaybackType.NORMAL && this.currentlyPlayedFavorites != null && this.util.getPlayer().getTune() != null) {
                this.currentlyPlayedFavorites.playNext();
            } else if (this.currentlyPlayedFavorites != null) {
                this.currentlyPlayedFavorites.deselectCurrentlyPlayedHVSCEntry();
                this.currentlyPlayedFavorites = null;
            }
        }
    }

    void setCurrentlyPlayedFavorites(FavoritesTab currentlyPlayedFavorites) {
        this.currentlyPlayedFavorites = currentlyPlayedFavorites;
    }

    ObservableList<Tab> getFavoriteTabs() {
        return this.favoritesList.getTabs();
    }
}

