/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config.service;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import libsidutils.PathUtils;
import org.hsqldb.DatabaseManager;
import ui.entities.Database;
import ui.entities.PersistenceProperties;
import ui.entities.config.Configuration;

public class ConfigService {
    public static final String CONFIG_FILE = "jsidplay2";
    private EntityManager em;
    private ConfigurationType configurationType;

    public ConfigService(ConfigurationType configurationType) {
        this.configurationType = configurationType;
        Logger.getLogger("org.hibernate").setLevel(Level.SEVERE);
    }

    public Configuration load() {
        switch (this.configurationType) {
            case DATABASE: {
                this.em = Persistence.createEntityManagerFactory((String)"configuration-ds", (Map)new PersistenceProperties(PathUtils.getFilenameWithoutSuffix(this.getConfigPath().getAbsolutePath()), Database.HSQL_FILE)).createEntityManager();
                return this.get();
            }
        }
        this.em = Persistence.createEntityManagerFactory((String)"configuration-ds", (Map)new PersistenceProperties(CONFIG_FILE, Database.HSQL_MEM)).createEntityManager();
        return this.importCfg(this.getConfigPath());
    }

    public void save(Configuration configuration) {
        switch (this.configurationType) {
            case DATABASE: {
                this.persist(configuration);
                break;
            }
            default: {
                this.exportCfg(configuration, this.getConfigPath());
            }
        }
    }

    private Configuration get() {
        Configuration configuration = null;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Configuration.class);
        Root h = q.from(Configuration.class);
        q.select((Selection)h);
        Optional first = this.em.createQuery(q).getResultList().stream().findFirst();
        if (first.isPresent()) {
            configuration = (Configuration)first.get();
            if (configuration.getSidplay2Section().getVersion() == 20) {
                return configuration;
            }
            File configPath = this.getConfigPath();
            this.createBackup(configuration, configPath);
        }
        if (configuration != null) {
            this.remove(configuration);
        }
        return this.create();
    }

    private Configuration create() {
        Configuration configuration = new Configuration();
        configuration.getSidplay2Section().setVersion(20);
        this.persist(configuration);
        return configuration;
    }

    private void remove(Configuration configuration) {
        block2: {
            try {
                this.em.getTransaction().begin();
                this.em.remove((Object)configuration);
                this.em.getTransaction().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.em.getTransaction().isActive()) break block2;
                this.em.getTransaction().rollback();
            }
        }
    }

    private void persist(Configuration config) {
        block2: {
            try {
                this.em.getTransaction().begin();
                this.em.persist((Object)config);
                this.em.getTransaction().commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.em.getTransaction().isActive()) break block2;
                this.em.getTransaction().rollback();
            }
        }
    }

    public void close() {
        this.em.getEntityManagerFactory().close();
        DatabaseManager.closeDatabases((int)2);
    }

    private Configuration importCfg(File file) {
        if (file.exists()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                Object obj = unmarshaller.unmarshal(file);
                if (obj instanceof Configuration) {
                    Configuration detachedConfig = (Configuration)obj;
                    if (detachedConfig.getSidplay2Section().getVersion() == 20) {
                        Configuration mergedConfig = (Configuration)this.em.merge((Object)detachedConfig);
                        this.persist(mergedConfig);
                        return mergedConfig;
                    }
                    File configPath = this.getConfigPath();
                    this.createBackup(detachedConfig, configPath);
                }
            }
            catch (JAXBException e) {
                System.err.println(e.getMessage());
            }
        }
        return this.create();
    }

    private void exportCfg(Configuration configuration, File file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)configuration, file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private File getConfigPath() {
        for (String s : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
            File configPlace = new File(s, "jsidplay2.xml");
            if (!configPlace.exists()) continue;
            return configPlace;
        }
        return new File(System.getProperty("user.home"), "jsidplay2.xml");
    }

    private void createBackup(Configuration configuration, File configPath) {
        File file = new File(configPath.getParentFile(), configPath.getName() + ".bak");
        this.exportCfg(configuration, file);
    }

    public static enum ConfigurationType {
        XML,
        DATABASE;

    }
}

