/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.util.StringConverter;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Transient;
import libsidplay.config.ISidPlay2Section;
import sidplay.ini.IniDefaults;
import ui.common.FileToStringConverter;
import ui.favorites.PlaybackType;

@Embeddable
public class SidPlay2Section
implements ISidPlay2Section {
    boolean DEFAULT_ENABLE_PROXY = false;
    public static final int DEFAULT_PROXY_PORT = 80;
    public static final PlaybackType DEFAULT_PLAYBACK_TYPE = PlaybackType.PLAYBACK_OFF;
    public static final int DEFAULT_FRAME_WIDTH = 1126;
    public static final int DEFAULT_FRAME_HEIGHT = 996;
    public static final boolean DEFAULT_FULL_SCREEN = false;
    public static final float DEFAULT_VIDEO_SCALING = 2.5f;
    public static final boolean DEFAULT_SHOW_MONITOR = true;
    private int version;
    private BooleanProperty enableDatabaseProperty = new SimpleBooleanProperty(IniDefaults.DEFAULT_ENABLE_DATABASE);
    private IntegerProperty defaultPlayLengthProperty = new SimpleIntegerProperty(IniDefaults.DEFAULT_PLAY_LENGTH);
    private IntegerProperty fadeInTimeProperty = new SimpleIntegerProperty(IniDefaults.DEFAULT_FADE_IN_TIME);
    private IntegerProperty fadeOutTimeProperty = new SimpleIntegerProperty(IniDefaults.DEFAULT_FADE_OUT_TIME);
    private PlaybackType playbackType = DEFAULT_PLAYBACK_TYPE;
    private boolean loop = IniDefaults.DEFAULT_LOOP;
    private BooleanProperty singleProperty = new SimpleBooleanProperty(IniDefaults.DEFAULT_SINGLE_TRACK);
    private ObjectProperty<File> HVMECFile = new SimpleObjectProperty();
    private StringProperty HVMEC = new SimpleStringProperty();
    private ObjectProperty<File> demosFile = new SimpleObjectProperty();
    private StringProperty demos = new SimpleStringProperty();
    private ObjectProperty<File> magsFile = new SimpleObjectProperty();
    private StringProperty mags = new SimpleStringProperty();
    private ObjectProperty<File> cgscFile = new SimpleObjectProperty();
    private StringProperty cgsc = new SimpleStringProperty();
    private ObjectProperty<File> hvscFile = new SimpleObjectProperty();
    private StringProperty hvsc = new SimpleStringProperty();
    private ObjectProperty<File> gameBase64File = new SimpleObjectProperty();
    private StringProperty gameBase64 = new SimpleStringProperty();
    private boolean enableProxy = this.DEFAULT_ENABLE_PROXY;
    private String proxyHostname;
    private int proxyPort = 80;
    private String lastDirectory;
    private String tmpDir = System.getProperty("user.home") + System.getProperty("file.separator") + ".jsidplay2";
    private int frameX;
    private int frameY;
    private int frameWidth = 1126;
    private int frameHeight = 996;
    private Boolean fullScreen = false;
    private FloatProperty videoScalingProperty = new SimpleFloatProperty(2.5f);
    private ObjectProperty<Boolean> showMonitorProperty = new SimpleObjectProperty((Object)true);
    private FloatProperty brightnessProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_BRIGHTNESS);
    private FloatProperty contrastProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_CONTRAST);
    private FloatProperty gammaProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_GAMMA);
    private FloatProperty saturationProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_SATURATION);
    private FloatProperty phaseShiftProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_PHASE_SHIFT);
    private FloatProperty offsetProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_OFFSET);
    private FloatProperty tintProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_TINT);
    private FloatProperty blurProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_BLUR);
    private FloatProperty bleedProperty = new SimpleFloatProperty(IniDefaults.DEFAULT_BLEED);
    private BooleanProperty turboTapeProperty = new SimpleBooleanProperty(IniDefaults.DEFAULT_TURBO_TAPE);

    public SidPlay2Section() {
        Bindings.bindBidirectional((Property)this.demos, this.demosFile, (StringConverter)new FileToStringConverter());
        Bindings.bindBidirectional((Property)this.HVMEC, this.HVMECFile, (StringConverter)new FileToStringConverter());
        Bindings.bindBidirectional((Property)this.mags, this.magsFile, (StringConverter)new FileToStringConverter());
        Bindings.bindBidirectional((Property)this.hvsc, this.hvscFile, (StringConverter)new FileToStringConverter());
        Bindings.bindBidirectional((Property)this.cgsc, this.cgscFile, (StringConverter)new FileToStringConverter());
        Bindings.bindBidirectional((Property)this.gameBase64, this.gameBase64File, (StringConverter)new FileToStringConverter());
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean isEnableDatabase() {
        return this.enableDatabaseProperty.get();
    }

    @Override
    public void setEnableDatabase(boolean isEnableDatabase) {
        this.enableDatabaseProperty.set(isEnableDatabase);
    }

    public BooleanProperty enableDatabaseProperty() {
        return this.enableDatabaseProperty;
    }

    @Override
    public int getDefaultPlayLength() {
        return this.defaultPlayLengthProperty.get();
    }

    @Override
    public void setDefaultPlayLength(int defaultPlayLength) {
        this.defaultPlayLengthProperty.set(defaultPlayLength);
    }

    public IntegerProperty defaultPlayLengthProperty() {
        return this.defaultPlayLengthProperty;
    }

    @Override
    public int getFadeInTime() {
        return this.fadeInTimeProperty.get();
    }

    public void setFadeInTime(int fadeInTime) {
        this.fadeInTimeProperty.set(fadeInTime);
    }

    public IntegerProperty fadeInTimeProperty() {
        return this.fadeInTimeProperty;
    }

    @Override
    public int getFadeOutTime() {
        return this.fadeOutTimeProperty.get();
    }

    public void setFadeOutTime(int fadeOutTime) {
        this.fadeOutTimeProperty.set(fadeOutTime);
    }

    public IntegerProperty fadeOutTimeProperty() {
        return this.fadeOutTimeProperty;
    }

    @Enumerated(value=EnumType.STRING)
    public PlaybackType getPlaybackType() {
        return this.playbackType;
    }

    public void setPlaybackType(PlaybackType playbackType) {
        this.playbackType = playbackType;
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public boolean isSingle() {
        return this.singleProperty.get();
    }

    @Override
    public void setSingle(boolean isSingle) {
        this.singleProperty.set(isSingle);
    }

    public BooleanProperty singleProperty() {
        return this.singleProperty;
    }

    @Transient
    public File getHVMECFile() {
        return (File)this.HVMECFile.get();
    }

    public String getHVMEC() {
        return (String)this.HVMEC.get();
    }

    public void setHVMEC(String hVMEC) {
        this.HVMEC.set((Object)hVMEC);
    }

    @Transient
    public File getDemosFile() {
        return (File)this.demosFile.get();
    }

    public String getDemos() {
        return (String)this.demos.get();
    }

    public void setDemos(String demos) {
        this.demos.set((Object)demos);
    }

    public String getMags() {
        return (String)this.mags.get();
    }

    @Transient
    public File getMagsFile() {
        return (File)this.magsFile.get();
    }

    public void setMags(String mags) {
        this.mags.set((Object)mags);
    }

    @Transient
    public File getCgscFile() {
        return (File)this.cgscFile.get();
    }

    public String getCgsc() {
        return (String)this.cgsc.get();
    }

    public void setCgsc(String cgsc) {
        this.cgsc.set((Object)cgsc);
    }

    @Transient
    public File getHvscFile() {
        return (File)this.hvscFile.get();
    }

    @Override
    public String getHvsc() {
        return (String)this.hvsc.get();
    }

    @Override
    public void setHvsc(String hvsc) {
        this.hvsc.set((Object)hvsc);
    }

    @Transient
    public File getGameBase64File() {
        return (File)this.gameBase64File.get();
    }

    public String getGameBase64() {
        return (String)this.gameBase64.get();
    }

    public void setGameBase64(String gameBase64) {
        this.gameBase64.set((Object)gameBase64);
    }

    public boolean isEnableProxy() {
        return this.enableProxy;
    }

    public void setEnableProxy(boolean isEnableProxy) {
        this.enableProxy = isEnableProxy;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public String getLastDirectory() {
        return this.lastDirectory;
    }

    @Override
    public void setLastDirectory(String lastDirectory) {
        this.lastDirectory = lastDirectory;
    }

    @Transient
    public File getLastDirectoryFolder() {
        if (this.lastDirectory != null && new TFile(this.lastDirectory).isDirectory()) {
            return new TFile(this.lastDirectory);
        }
        return null;
    }

    @Override
    public String getTmpDir() {
        return this.tmpDir;
    }

    @Override
    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    public int getFrameX() {
        return this.frameX;
    }

    public void setFrameX(int frameX) {
        this.frameX = frameX;
    }

    public int getFrameY() {
        return this.frameY;
    }

    public void setFrameY(int frameY) {
        this.frameY = frameY;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public void setFrameWidth(int frameWidth) {
        this.frameWidth = frameWidth;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public void setFrameHeight(int frameHeight) {
        this.frameHeight = frameHeight;
    }

    public Boolean getFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(Boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    public float getVideoScaling() {
        return this.videoScalingProperty.get();
    }

    public void setVideoScaling(float videoScaling) {
        this.videoScalingProperty.set(videoScaling);
    }

    public FloatProperty videoScalingProperty() {
        return this.videoScalingProperty;
    }

    public boolean isShowMonitor() {
        return (Boolean)this.showMonitorProperty.get();
    }

    public void setShowMonitor(boolean showMonitor) {
        this.showMonitorProperty.set((Object)showMonitor);
    }

    public ObjectProperty<Boolean> showMonitorProperty() {
        return this.showMonitorProperty;
    }

    @Override
    public float getBrightness() {
        return this.brightnessProperty.get();
    }

    @Override
    public void setBrightness(float brightness) {
        this.brightnessProperty.set(brightness);
    }

    public final FloatProperty brightnessProperty() {
        return this.brightnessProperty;
    }

    @Override
    public float getContrast() {
        return this.contrastProperty.get();
    }

    @Override
    public void setContrast(float contrast) {
        this.contrastProperty.set(contrast);
    }

    public final FloatProperty contrastProperty() {
        return this.contrastProperty;
    }

    @Override
    public float getGamma() {
        return this.gammaProperty.get();
    }

    @Override
    public void setGamma(float gamma) {
        this.gammaProperty.set(gamma);
    }

    public final FloatProperty gammaProperty() {
        return this.gammaProperty;
    }

    @Override
    public float getSaturation() {
        return this.saturationProperty.get();
    }

    @Override
    public void setSaturation(float saturation) {
        this.saturationProperty.set(saturation);
    }

    public final FloatProperty saturationProperty() {
        return this.saturationProperty;
    }

    @Override
    public float getPhaseShift() {
        return this.phaseShiftProperty.get();
    }

    @Override
    public void setPhaseShift(float phaseShift) {
        this.phaseShiftProperty.set(phaseShift);
    }

    public final FloatProperty phaseShiftProperty() {
        return this.phaseShiftProperty;
    }

    @Override
    public float getOffset() {
        return this.offsetProperty.get();
    }

    @Override
    public void setOffset(float offset) {
        this.offsetProperty.set(offset);
    }

    public final FloatProperty offsetProperty() {
        return this.offsetProperty;
    }

    @Override
    public float getTint() {
        return this.tintProperty.get();
    }

    @Override
    public void setTint(float tint) {
        this.tintProperty.set(tint);
    }

    public final FloatProperty tintProperty() {
        return this.tintProperty;
    }

    @Override
    public float getBlur() {
        return this.blurProperty.get();
    }

    @Override
    public void setBlur(float blur) {
        this.blurProperty.set(blur);
    }

    public final FloatProperty blurProperty() {
        return this.blurProperty;
    }

    @Override
    public float getBleed() {
        return this.bleedProperty.get();
    }

    @Override
    public void setBleed(float bleed) {
        this.bleedProperty.set(bleed);
    }

    public final FloatProperty bleedProperty() {
        return this.bleedProperty;
    }

    @Override
    public boolean isTurboTape() {
        return this.turboTapeProperty.get();
    }

    @Override
    public void setTurboTape(boolean turboTape) {
        this.turboTapeProperty.set(turboTape);
    }
}

