/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.persistence.metamodel.SingularAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import ui.entities.collection.HVSCEntry;
import ui.entities.collection.HVSCEntry_;
import ui.entities.config.FavoriteColumn;

@Entity
@Access(value=AccessType.PROPERTY)
public class FavoritesSection {
    private Integer id;
    private String name;
    private Double width;
    private Integer selectedRowFrom = -1;
    private Integer selectedRowTo = -1;
    private List<FavoriteColumn> columns;
    protected List<HVSCEntry> favorites;
    protected ObservableList<HVSCEntry> observableFavorites;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @XmlTransient
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Integer getSelectedRowFrom() {
        return this.selectedRowFrom;
    }

    public void setSelectedRowFrom(Integer selectedRowFrom) {
        this.selectedRowFrom = selectedRowFrom;
    }

    public Integer getSelectedRowTo() {
        return this.selectedRowTo;
    }

    public void setSelectedRowTo(Integer selectedRowTo) {
        this.selectedRowTo = selectedRowTo;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<FavoriteColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<FavoriteColumn>();
            FavoriteColumn dbFavoriteColumn = new FavoriteColumn();
            SingularAttribute<HVSCEntry, String> attribute = HVSCEntry_.title;
            dbFavoriteColumn.setColumnProperty(attribute.getName());
            this.columns.add(dbFavoriteColumn);
            dbFavoriteColumn = new FavoriteColumn();
            attribute = HVSCEntry_.author;
            dbFavoriteColumn.setColumnProperty(attribute.getName());
            this.columns.add(dbFavoriteColumn);
            dbFavoriteColumn = new FavoriteColumn();
            attribute = HVSCEntry_.released;
            dbFavoriteColumn.setColumnProperty(attribute.getName());
            this.columns.add(dbFavoriteColumn);
        }
        return this.columns;
    }

    public void setColumns(List<FavoriteColumn> columns) {
        this.columns = columns;
    }

    public void setFavorites(List<HVSCEntry> favorites) {
        this.favorites = favorites;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @XmlElement(name="favorite")
    public List<HVSCEntry> getFavorites() {
        if (this.favorites == null) {
            this.favorites = new ArrayList<HVSCEntry>();
        }
        return this.getObservableFavorites();
    }

    @Transient
    public ObservableList<HVSCEntry> getObservableFavorites() {
        if (this.observableFavorites == null) {
            this.observableFavorites = FXCollections.observableArrayList(this.favorites);
            Bindings.bindContent(this.favorites, this.observableFavorites);
        }
        return this.observableFavorites;
    }
}

