/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.input.KeyCode;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import libsidplay.components.keyboard.KeyTableEntry;
import libsidplay.config.IConfig;
import sidplay.ini.IniDefaults;
import ui.entities.config.AudioSection;
import ui.entities.config.C1541Section;
import ui.entities.config.EmulationSection;
import ui.entities.config.FavoritesSection;
import ui.entities.config.FilterSection;
import ui.entities.config.JoystickSection;
import ui.entities.config.KeyTableEntity;
import ui.entities.config.OnlineSection;
import ui.entities.config.PrinterSection;
import ui.entities.config.SidPlay2Section;
import ui.entities.config.ViewEntity;

@Entity
@Access(value=AccessType.PROPERTY)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class Configuration
implements IConfig {
    private final List<FilterSection> INITIAL_FILTERS = new ArrayList<FilterSection>();
    private final List<ViewEntity> INITIAL_VIEWS;
    private final List<KeyTableEntity> INITIAL_KEYCODES;
    private final List<FavoritesSection> INITIAL_FAVORITES;
    private Integer id;
    private SidPlay2Section sidplay2;
    private OnlineSection online;
    private C1541Section c1541;
    private PrinterSection printer;
    private JoystickSection joystickSection;
    private AudioSection audioSection;
    private EmulationSection emulationSection;
    private String currentFavorite;
    protected List<FavoritesSection> favorites;
    private ObservableList<FavoritesSection> observableFavorites;
    protected List<ViewEntity> views;
    private ObservableList<ViewEntity> observableViews;
    private List<FilterSection> filter;
    private List<KeyTableEntity> keyCodeMap;

    public Configuration() {
        IniDefaults.DEFAULTS.getFilterSection().forEach(f -> {
            FilterSection dbFilterSection = new FilterSection();
            if (f.isReSIDFilter8580()) {
                dbFilterSection.setName(f.getName());
                dbFilterSection.setFilter8580CurvePosition(f.getFilter8580CurvePosition());
            } else if (f.isReSIDFilter6581()) {
                dbFilterSection.setName(f.getName());
                dbFilterSection.setFilter6581CurvePosition(f.getFilter6581CurvePosition());
            } else if (f.isReSIDfpFilter8580()) {
                dbFilterSection.setName(f.getName());
                dbFilterSection.setK(f.getK());
                dbFilterSection.setB(f.getB());
                dbFilterSection.setVoiceNonlinearity(f.getVoiceNonlinearity());
                dbFilterSection.setResonanceFactor(f.getResonanceFactor());
            } else if (f.isReSIDfpFilter6581()) {
                dbFilterSection.setName(f.getName());
                dbFilterSection.setAttenuation(f.getAttenuation());
                dbFilterSection.setNonlinearity(f.getNonlinearity());
                dbFilterSection.setVoiceNonlinearity(f.getVoiceNonlinearity());
                dbFilterSection.setBaseresistance(f.getBaseresistance());
                dbFilterSection.setOffset(f.getOffset());
                dbFilterSection.setSteepness(f.getSteepness());
                dbFilterSection.setMinimumfetresistance(f.getMinimumfetresistance());
                dbFilterSection.setResonanceFactor(f.getResonanceFactor());
            }
            this.INITIAL_FILTERS.add(dbFilterSection);
        });
        this.INITIAL_VIEWS = new ArrayList<ViewEntity>();
        this.INITIAL_VIEWS.add(new ViewEntity("CONSOLE"));
        this.INITIAL_VIEWS.add(new ViewEntity("VIDEO"));
        this.INITIAL_KEYCODES = new ArrayList<KeyTableEntity>();
        List<KeyTableEntity> keyCodes = Arrays.asList(new KeyTableEntity(KeyCode.A.getName(), KeyTableEntry.A), new KeyTableEntity(KeyCode.BACK_SLASH.getName(), KeyTableEntry.ARROW_LEFT), new KeyTableEntity(KeyCode.DIGIT1.getName(), KeyTableEntry.ONE), new KeyTableEntity(KeyCode.DIGIT2.getName(), KeyTableEntry.TWO), new KeyTableEntity(KeyCode.DIGIT3.getName(), KeyTableEntry.THREE), new KeyTableEntity(KeyCode.DIGIT4.getName(), KeyTableEntry.FOUR), new KeyTableEntity(KeyCode.DIGIT5.getName(), KeyTableEntry.FIVE), new KeyTableEntity(KeyCode.DIGIT6.getName(), KeyTableEntry.SIX), new KeyTableEntity(KeyCode.DIGIT7.getName(), KeyTableEntry.SEVEN), new KeyTableEntity(KeyCode.DIGIT8.getName(), KeyTableEntry.EIGHT), new KeyTableEntity(KeyCode.DIGIT9.getName(), KeyTableEntry.NINE), new KeyTableEntity(KeyCode.DIGIT0.getName(), KeyTableEntry.ZERO), new KeyTableEntity(KeyCode.OPEN_BRACKET.getName(), KeyTableEntry.PLUS), new KeyTableEntity(KeyCode.CLOSE_BRACKET.getName(), KeyTableEntry.MINUS), new KeyTableEntity(KeyCode.POUND.getName(), KeyTableEntry.POUND), new KeyTableEntity(KeyCode.HOME.getName(), KeyTableEntry.CLEAR_HOME), new KeyTableEntity(KeyCode.BACK_SPACE.getName(), KeyTableEntry.INS_DEL), new KeyTableEntity(KeyCode.Q.getName(), KeyTableEntry.Q), new KeyTableEntity(KeyCode.W.getName(), KeyTableEntry.W), new KeyTableEntity(KeyCode.E.getName(), KeyTableEntry.E), new KeyTableEntity(KeyCode.R.getName(), KeyTableEntry.R), new KeyTableEntity(KeyCode.T.getName(), KeyTableEntry.T), new KeyTableEntity(KeyCode.Y.getName(), KeyTableEntry.Y), new KeyTableEntity(KeyCode.U.getName(), KeyTableEntry.U), new KeyTableEntity(KeyCode.I.getName(), KeyTableEntry.I), new KeyTableEntity(KeyCode.O.getName(), KeyTableEntry.O), new KeyTableEntity(KeyCode.P.getName(), KeyTableEntry.P), new KeyTableEntity(KeyCode.SEMICOLON.getName(), KeyTableEntry.AT), new KeyTableEntity(KeyCode.PLUS.getName(), KeyTableEntry.STAR), new KeyTableEntity(KeyCode.LESS.getName(), KeyTableEntry.ARROW_UP), new KeyTableEntity(KeyCode.ESCAPE.getName(), KeyTableEntry.RUN_STOP), new KeyTableEntity(KeyCode.A.getName(), KeyTableEntry.A), new KeyTableEntity(KeyCode.S.getName(), KeyTableEntry.S), new KeyTableEntity(KeyCode.D.getName(), KeyTableEntry.D), new KeyTableEntity(KeyCode.F.getName(), KeyTableEntry.F), new KeyTableEntity(KeyCode.G.getName(), KeyTableEntry.G), new KeyTableEntity(KeyCode.H.getName(), KeyTableEntry.H), new KeyTableEntity(KeyCode.J.getName(), KeyTableEntry.J), new KeyTableEntity(KeyCode.K.getName(), KeyTableEntry.K), new KeyTableEntity(KeyCode.L.getName(), KeyTableEntry.L), new KeyTableEntity(KeyCode.BACK_QUOTE.getName(), KeyTableEntry.COLON), new KeyTableEntity(KeyCode.QUOTE.getName(), KeyTableEntry.SEMICOLON), new KeyTableEntity(KeyCode.SLASH.getName(), KeyTableEntry.EQUALS), new KeyTableEntity(KeyCode.ENTER.getName(), KeyTableEntry.RETURN), new KeyTableEntity(KeyCode.Z.getName(), KeyTableEntry.Z), new KeyTableEntity(KeyCode.X.getName(), KeyTableEntry.X), new KeyTableEntity(KeyCode.C.getName(), KeyTableEntry.C), new KeyTableEntity(KeyCode.V.getName(), KeyTableEntry.V), new KeyTableEntity(KeyCode.B.getName(), KeyTableEntry.B), new KeyTableEntity(KeyCode.N.getName(), KeyTableEntry.N), new KeyTableEntity(KeyCode.M.getName(), KeyTableEntry.M), new KeyTableEntity(KeyCode.COMMA.getName(), KeyTableEntry.COMMA), new KeyTableEntity(KeyCode.PERIOD.getName(), KeyTableEntry.PERIOD), new KeyTableEntity(KeyCode.MINUS.getName(), KeyTableEntry.SLASH), new KeyTableEntity(KeyCode.DOWN.getName(), KeyTableEntry.CURSOR_UP_DOWN), new KeyTableEntity(KeyCode.UP.getName(), KeyTableEntry.CURSOR_UP_DOWN, true), new KeyTableEntity(KeyCode.RIGHT.getName(), KeyTableEntry.CURSOR_LEFT_RIGHT), new KeyTableEntity(KeyCode.LEFT.getName(), KeyTableEntry.CURSOR_LEFT_RIGHT, true), new KeyTableEntity(KeyCode.SPACE.getName(), KeyTableEntry.SPACE, true), new KeyTableEntity(KeyCode.F1.getName(), KeyTableEntry.F1), new KeyTableEntity(KeyCode.F3.getName(), KeyTableEntry.F3), new KeyTableEntity(KeyCode.F5.getName(), KeyTableEntry.F5), new KeyTableEntity(KeyCode.F7.getName(), KeyTableEntry.F7));
        this.INITIAL_KEYCODES.addAll(keyCodes);
        this.INITIAL_FAVORITES = new ArrayList<FavoritesSection>();
        this.INITIAL_FAVORITES.add(new FavoritesSection());
        this.sidplay2 = new SidPlay2Section();
        this.online = new OnlineSection();
        this.c1541 = new C1541Section();
        this.printer = new PrinterSection();
        this.joystickSection = new JoystickSection();
        this.audioSection = new AudioSection();
        this.emulationSection = new EmulationSection();
        this.favorites = this.INITIAL_FAVORITES;
        this.views = this.INITIAL_VIEWS;
        this.filter = this.INITIAL_FILTERS;
        this.keyCodeMap = this.INITIAL_KEYCODES;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @XmlTransient
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setSidplay2Section(SidPlay2Section sidplay2) {
        this.sidplay2 = sidplay2;
    }

    @Override
    @Embedded
    public SidPlay2Section getSidplay2Section() {
        return this.sidplay2;
    }

    @Embedded
    public OnlineSection getOnlineSection() {
        return this.online;
    }

    public void setOnlineSection(OnlineSection online) {
        this.online = online;
    }

    public void setC1541Section(C1541Section c1541) {
        this.c1541 = c1541;
    }

    @Override
    @Embedded
    public C1541Section getC1541Section() {
        return this.c1541;
    }

    public void setPrinterSection(PrinterSection printer) {
        this.printer = printer;
    }

    @Override
    @Embedded
    public PrinterSection getPrinterSection() {
        return this.printer;
    }

    public void setJoystickSection(JoystickSection joystick) {
        this.joystickSection = joystick;
    }

    @Embedded
    public JoystickSection getJoystickSection() {
        return this.joystickSection;
    }

    public void setAudioSection(AudioSection audio) {
        this.audioSection = audio;
    }

    @Override
    @Embedded
    public AudioSection getAudioSection() {
        return this.audioSection;
    }

    public void setEmulationSection(EmulationSection emulation) {
        this.emulationSection = emulation;
    }

    @Override
    @Embedded
    public EmulationSection getEmulationSection() {
        return this.emulationSection;
    }

    public void setCurrentFavorite(String currentFavorite) {
        this.currentFavorite = currentFavorite;
    }

    public String getCurrentFavorite() {
        return this.currentFavorite;
    }

    public void setFavorites(List<FavoritesSection> favorites) {
        this.favorites = favorites;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<FavoritesSection> getFavorites() {
        if (this.favorites == null) {
            this.favorites = new ArrayList<FavoritesSection>();
        }
        return this.getObservableFavorites();
    }

    @Transient
    public ObservableList<FavoritesSection> getObservableFavorites() {
        if (this.observableFavorites == null) {
            this.observableFavorites = FXCollections.observableArrayList(this.favorites);
            Bindings.bindContent(this.favorites, this.observableFavorites);
        }
        return this.observableFavorites;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<ViewEntity> getViews() {
        if (this.observableViews == null) {
            this.observableViews = FXCollections.observableArrayList(this.views);
            Bindings.bindContent(this.views, this.observableViews);
        }
        return this.observableViews;
    }

    public void setViews(List<ViewEntity> views) {
        this.views = views;
    }

    public void setFilterSection(List<FilterSection> filter) {
        this.filter = filter;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<FilterSection> getFilterSection() {
        if (this.filter == null) {
            this.filter = new ArrayList<FilterSection>();
        }
        return this.filter;
    }

    public void setKeyCodeMap(List<KeyTableEntity> keyCodeMap) {
        this.keyCodeMap = keyCodeMap;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<KeyTableEntity> getKeyCodeMap() {
        return this.keyCodeMap;
    }

    public KeyTableEntry getKeyTabEntry(String key) {
        for (KeyTableEntity keyCode : this.keyCodeMap) {
            if (!keyCode.getKeyCodeName().equals(key)) continue;
            return keyCode.getEntry();
        }
        return null;
    }
}

