/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.collection;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import libsidutils.stil.STIL;
import ui.entities.collection.HVSCEntry;

@Entity
@Access(value=AccessType.PROPERTY)
public class StilEntry {
    private int id;
    private HVSCEntry hvscEntry;
    private String stilName;
    private String stilAuthor;
    private String stilTitle;
    private String stilArtist;
    private String stilComment;

    public StilEntry() {
    }

    public StilEntry(STIL.Info info) {
        this.stilName = info.name;
        this.stilAuthor = info.author;
        this.stilTitle = info.title;
        this.stilArtist = info.artist;
        this.stilComment = info.comment;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @ManyToOne
    public HVSCEntry getHvscEntry() {
        return this.hvscEntry;
    }

    public void setHvscEntry(HVSCEntry hvscEntry) {
        this.hvscEntry = hvscEntry;
    }

    public String getStilName() {
        return this.stilName;
    }

    public void setStilName(String name) {
        this.stilName = name;
    }

    public String getStilAuthor() {
        return this.stilAuthor;
    }

    public void setStilAuthor(String author) {
        this.stilAuthor = author;
    }

    public String getStilTitle() {
        return this.stilTitle;
    }

    public void setStilTitle(String title) {
        this.stilTitle = title;
    }

    public String getStilArtist() {
        return this.stilArtist;
    }

    public void setStilArtist(String artist) {
        this.stilArtist = artist;
    }

    @Column(length=4096)
    public String getStilComment() {
        return this.stilComment;
    }

    public void setStilComment(String comment) {
        this.stilComment = comment;
    }
}

