/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.collection;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntSupplier;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlTransient;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneInfo;
import ui.entities.collection.StilEntry;

@Entity
@Access(value=AccessType.PROPERTY)
public class HVSCEntry {
    private Integer id;
    private String path;
    private String name;
    private String title;
    private String author;
    private String released;
    private String format;
    private String playerId;
    private Integer noOfSongs;
    private Integer startSong;
    private SidTune.Clock clockFreq;
    private SidTune.Speed speed;
    private SidTune.Model sidModel1;
    private SidTune.Model sidModel2;
    private SidTune.Model sidModel3;
    private SidTune.Compatibility compatibility;
    private Long tuneLength;
    private String audio;
    private Integer sidChipBase1;
    private Integer sidChipBase2;
    private Integer sidChipBase3;
    private Integer driverAddress;
    private Integer loadAddress;
    private Integer loadLength;
    private Integer initAddress;
    private Integer playerAddress;
    private Date fileDate;
    private Long fileSizeKb;
    private Long tuneSizeB;
    private Short relocStartPage;
    private Short relocNoPages;
    private String stilGlbComment;
    private List<StilEntry> stil;

    public HVSCEntry() {
    }

    public HVSCEntry(IntSupplier lengthFnct, String path, File tuneFile, SidTune tune) {
        this.name = tuneFile.getName();
        String string = this.path = path.length() > 0 ? path : tuneFile.getPath();
        if (tune != null) {
            SidTuneInfo info = tune.getInfo();
            info.setSelectedSong(1);
            Iterator<String> descriptionIt = info.getInfoString().iterator();
            if (descriptionIt.hasNext()) {
                this.title = descriptionIt.next();
            }
            if (descriptionIt.hasNext()) {
                this.author = descriptionIt.next();
            }
            if (descriptionIt.hasNext()) {
                this.released = descriptionIt.next();
            }
            this.format = tune.getClass().getSimpleName();
            StringBuilder ids = new StringBuilder();
            tune.identify().stream().forEach(id -> ids.append(',').append((String)id));
            this.playerId = ids.length() > 0 ? ids.substring(1) : ids.toString();
            this.noOfSongs = info.getSongs();
            this.startSong = info.getStartSong();
            this.clockFreq = info.getClockSpeed();
            this.speed = tune.getSongSpeed(1);
            this.sidModel1 = info.getSIDModel(0);
            this.sidModel2 = info.getSIDModel(1);
            this.sidModel3 = info.getSIDModel(2);
            this.compatibility = info.getCompatibility();
            this.tuneLength = lengthFnct.getAsInt();
            this.audio = info.getSIDChipBase(1) != 0 ? (info.getSIDChipBase(2) != 0 ? "3-SID" : "Stereo") : "Mono";
            this.sidChipBase1 = info.getSIDChipBase(0);
            this.sidChipBase2 = info.getSIDChipBase(1);
            this.sidChipBase3 = info.getSIDChipBase(2);
            this.driverAddress = info.getDeterminedDriverAddr();
            this.loadAddress = info.getLoadAddr();
            this.loadLength = info.getC64dataLen();
            this.initAddress = info.getInitAddr();
            this.playerAddress = info.getPlayAddr();
            this.fileDate = new Date(tuneFile.lastModified());
            this.fileSizeKb = tuneFile.length() >> 10;
            this.tuneSizeB = tuneFile.length();
            this.relocStartPage = info.getRelocStartPage();
            this.relocNoPages = info.getRelocPages();
        }
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @XmlTransient
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getReleased() {
        return this.released;
    }

    public void setReleased(String released) {
        this.released = released;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Column(length=2048)
    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public Integer getNoOfSongs() {
        return this.noOfSongs;
    }

    public void setNoOfSongs(Integer noOfSongs) {
        this.noOfSongs = noOfSongs;
    }

    public Integer getStartSong() {
        return this.startSong;
    }

    public void setStartSong(Integer startSong) {
        this.startSong = startSong;
    }

    @Enumerated(value=EnumType.STRING)
    public SidTune.Clock getClockFreq() {
        return this.clockFreq;
    }

    public void setClockFreq(SidTune.Clock clockFreq) {
        this.clockFreq = clockFreq;
    }

    @Enumerated(value=EnumType.STRING)
    public SidTune.Speed getSpeed() {
        return this.speed;
    }

    public void setSpeed(SidTune.Speed speed) {
        this.speed = speed;
    }

    @Enumerated(value=EnumType.STRING)
    public SidTune.Model getSidModel1() {
        return this.sidModel1;
    }

    public void setSidModel1(SidTune.Model sidModel1) {
        this.sidModel1 = sidModel1;
    }

    @Enumerated(value=EnumType.STRING)
    public SidTune.Model getSidModel2() {
        return this.sidModel2;
    }

    public void setSidModel2(SidTune.Model sidModel2) {
        this.sidModel2 = sidModel2;
    }

    @Enumerated(value=EnumType.STRING)
    public SidTune.Model getSidModel3() {
        return this.sidModel3;
    }

    public void setSidModel3(SidTune.Model sidModel3) {
        this.sidModel3 = sidModel3;
    }

    @Enumerated(value=EnumType.STRING)
    public SidTune.Compatibility getCompatibility() {
        return this.compatibility;
    }

    public void setCompatibility(SidTune.Compatibility compatibility) {
        this.compatibility = compatibility;
    }

    public Long getTuneLength() {
        return this.tuneLength;
    }

    public void setTuneLength(Long tuneLength) {
        this.tuneLength = tuneLength;
    }

    public String getAudio() {
        return this.audio;
    }

    public void setAudio(String audio) {
        this.audio = audio;
    }

    public Integer getSidChipBase1() {
        return this.sidChipBase1;
    }

    public void setSidChipBase1(Integer sidChipBase1) {
        this.sidChipBase1 = sidChipBase1;
    }

    public Integer getSidChipBase2() {
        return this.sidChipBase2;
    }

    public void setSidChipBase2(Integer sidChipBase2) {
        this.sidChipBase2 = sidChipBase2;
    }

    public Integer getSidChipBase3() {
        return this.sidChipBase3;
    }

    public void setSidChipBase3(Integer sidChipBase3) {
        this.sidChipBase3 = sidChipBase3;
    }

    public Integer getDriverAddress() {
        return this.driverAddress;
    }

    public void setDriverAddress(Integer driverAddress) {
        this.driverAddress = driverAddress;
    }

    public Integer getLoadAddress() {
        return this.loadAddress;
    }

    public void setLoadAddress(Integer loadAddress) {
        this.loadAddress = loadAddress;
    }

    public Integer getLoadLength() {
        return this.loadLength;
    }

    public void setLoadLength(Integer loadLength) {
        this.loadLength = loadLength;
    }

    public Integer getInitAddress() {
        return this.initAddress;
    }

    public void setInitAddress(Integer initAddress) {
        this.initAddress = initAddress;
    }

    public Integer getPlayerAddress() {
        return this.playerAddress;
    }

    public void setPlayerAddress(Integer playerAddress) {
        this.playerAddress = playerAddress;
    }

    public Date getFileDate() {
        return this.fileDate;
    }

    public void setFileDate(Date fileDate) {
        this.fileDate = fileDate;
    }

    public Long getFileSizeKb() {
        return this.fileSizeKb;
    }

    public void setFileSizeKb(Long fileSizeInKb) {
        this.fileSizeKb = fileSizeInKb;
    }

    public Long getTuneSizeB() {
        return this.tuneSizeB;
    }

    public void setTuneSizeB(Long tuneSizeInB) {
        this.tuneSizeB = tuneSizeInB;
    }

    public Short getRelocStartPage() {
        return this.relocStartPage;
    }

    public void setRelocStartPage(Short relocStartPage) {
        this.relocStartPage = relocStartPage;
    }

    public Short getRelocNoPages() {
        return this.relocNoPages;
    }

    public void setRelocNoPages(Short relocNoPages) {
        this.relocNoPages = relocNoPages;
    }

    @Column(length=4096)
    public String getStilGlbComment() {
        return this.stilGlbComment;
    }

    public void setStilGlbComment(String stilComment) {
        this.stilGlbComment = stilComment;
    }

    @OneToMany(mappedBy="hvscEntry", fetch=FetchType.LAZY)
    public List<StilEntry> getStil() {
        if (this.stil == null) {
            this.stil = new ArrayList<StilEntry>();
        }
        return this.stil;
    }

    public void setStil(List<StilEntry> stil) {
        this.stil = stil;
    }
}

