/*
 * Decompiled with CFR 0.152.
 */
package ui.emulationsettings;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.chart.ValueAxis;

public class LogarithmicAxis
extends ValueAxis<Number> {
    private final DoubleProperty logUpperBound = new SimpleDoubleProperty();
    private final DoubleProperty logLowerBound = new SimpleDoubleProperty();

    public LogarithmicAxis() {
        super(0.0, 2048.0);
        this.bindLogBoundsToDefaultBounds();
    }

    public LogarithmicAxis(double lowerBound, double upperBound) {
        super(lowerBound, upperBound);
        try {
            this.validateBounds(lowerBound, upperBound);
            this.bindLogBoundsToDefaultBounds();
        }
        catch (IllegalLogarithmicRangeException illegalLogarithmicRangeException) {
            // empty catch block
        }
    }

    private void bindLogBoundsToDefaultBounds() {
        this.logLowerBound.bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return Math.log10(LogarithmicAxis.this.lowerBoundProperty().get());
            }
        });
        this.logUpperBound.bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return Math.log10(LogarithmicAxis.this.upperBoundProperty().get());
            }
        });
    }

    private void validateBounds(double lowerBound, double upperBound) throws IllegalLogarithmicRangeException {
        if (lowerBound < 0.0 || upperBound < 0.0 || lowerBound > upperBound) {
            throw new IllegalLogarithmicRangeException("The logarithmic range should be include to ]0,Double.MAX_VALUE] and the lowerBound should be less than the upperBound");
        }
    }

    protected List<Number> calculateMinorTickMarks() {
        Number[] range = this.getRange();
        ArrayList<Number> minorTickMarksPositions = new ArrayList<Number>();
        if (range != null) {
            Number lowerBound = range[0];
            Number upperBound = range[1];
            double logUpperBound = Math.log10(upperBound.doubleValue());
            double logLowerBound = Math.log10(lowerBound.doubleValue());
            int minorTickMarkCount = this.getMinorTickCount();
            for (double i = logLowerBound; i <= logUpperBound; i += 1.0) {
                for (double j = 0.0; j <= 10.0; j += 1.0 / (double)minorTickMarkCount) {
                    double value = j * Math.pow(10.0, i);
                    minorTickMarksPositions.add(value);
                }
            }
        }
        return minorTickMarksPositions;
    }

    protected List<Number> calculateTickValues(double length, Object range) {
        ArrayList<Number> tickPositions = new ArrayList<Number>();
        if (range != null) {
            Number lowerBound = ((Number[])range)[0];
            Number upperBound = ((Number[])range)[1];
            double logLowerBound = Math.log10(lowerBound.doubleValue());
            double logUpperBound = Math.log10(upperBound.doubleValue());
            for (double i = logLowerBound; i <= logUpperBound; i += 1.0) {
                for (double j = 1.0; j <= 10.0; j += 1.0) {
                    double value = j * Math.pow(10.0, i);
                    tickPositions.add(value);
                }
            }
        }
        return tickPositions;
    }

    protected Number[] getRange() {
        return new Number[]{this.lowerBoundProperty().get(), this.upperBoundProperty().get()};
    }

    protected String getTickMarkLabel(Number value) {
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumIntegerDigits(6);
        formatter.setMinimumIntegerDigits(1);
        return formatter.format(value);
    }

    protected void setRange(Object range, boolean animate) {
        if (range != null) {
            Number lowerBound = ((Number[])range)[0];
            Number upperBound = ((Number[])range)[1];
            try {
                this.validateBounds(lowerBound.doubleValue(), upperBound.doubleValue());
            }
            catch (IllegalLogarithmicRangeException illegalLogarithmicRangeException) {
                // empty catch block
            }
            this.lowerBoundProperty().set(lowerBound.doubleValue());
            this.upperBoundProperty().set(upperBound.doubleValue());
        }
    }

    public Number getValueForDisplay(double displayPosition) {
        double delta = this.logUpperBound.get() - this.logLowerBound.get();
        if (this.getSide().isVertical()) {
            return Math.pow(10.0, (displayPosition - this.getHeight()) / -this.getHeight() * delta + this.logLowerBound.get());
        }
        return Math.pow(10.0, displayPosition / this.getWidth() * delta + this.logLowerBound.get());
    }

    public double getDisplayPosition(Number value) {
        double delta = this.logUpperBound.get() - this.logLowerBound.get();
        double deltaV = Math.log10(value.doubleValue()) - this.logLowerBound.get();
        if (this.getSide().isVertical()) {
            return (1.0 - deltaV / delta) * this.getHeight();
        }
        return deltaV / delta * this.getWidth();
    }

    public class IllegalLogarithmicRangeException
    extends Exception {
        private static final long serialVersionUID = -1874700637219400970L;

        public IllegalLogarithmicRangeException(String message) {
            super(message);
        }
    }
}

