/*
 * Decompiled with CFR 0.152.
 */
package ui.emulationsettings;

import java.util.ArrayList;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.config.IFilterSection;
import libsidplay.sidtune.SidTune;
import netsiddev_builder.commands.TrySetSidModel;
import resid_builder.residfp.FilterModelConfig;
import sidplay.Player;
import sidplay.player.State;
import ui.common.C64Window;
import ui.common.EnumToString;
import ui.common.HexNumberToString;
import ui.common.NumberToString;
import ui.entities.config.AudioSection;
import ui.entities.config.EmulationSection;
import ui.entities.config.FilterSection;

public class EmulationSettings
extends C64Window {
    @FXML
    private ComboBox<Emulation> sid1Emulation;
    @FXML
    private ComboBox<Emulation> sid2Emulation;
    @FXML
    private ComboBox<Emulation> sid3Emulation;
    @FXML
    private ComboBox<Emulation> defaultEmulation;
    @FXML
    private ComboBox<ChipModel> sid1Model;
    @FXML
    private ComboBox<ChipModel> sid2Model;
    @FXML
    private ComboBox<ChipModel> sid3Model;
    @FXML
    private ComboBox<ChipModel> defaultModel;
    @FXML
    private ComboBox<String> mainFilter;
    @FXML
    private ComboBox<String> secondFilter;
    @FXML
    private ComboBox<String> thirdFilter;
    @FXML
    private ComboBox<SidReads> sidToRead;
    @FXML
    private ComboBox<StereoMode> stereoMode;
    @FXML
    private TextField baseAddress;
    @FXML
    private TextField thirdAddress;
    @FXML
    private CheckBox boosted8580;
    @FXML
    private CheckBox fakeStereo;
    @FXML
    private Slider mainVolume;
    @FXML
    private Slider secondVolume;
    @FXML
    private Slider thirdVolume;
    @FXML
    private Slider mainBalance;
    @FXML
    private Slider secondBalance;
    @FXML
    private Slider thirdBalance;
    @FXML
    Label mainVolumeValue;
    @FXML
    Label secondVolumeValue;
    @FXML
    Label thirdVolumeValue;
    @FXML
    private LineChart<Number, Number> mainFilterCurve;
    @FXML
    private LineChart<Number, Number> secondFilterCurve;
    @FXML
    private LineChart<Number, Number> thirdFilterCurve;
    private ObservableList<Emulation> sid1Emulations;
    private ObservableList<Emulation> sid2Emulations;
    private ObservableList<Emulation> sid3Emulations;
    private ObservableList<Emulation> defaultEmulations;
    private ObservableList<ChipModel> sid1Models;
    private ObservableList<ChipModel> sid2Models;
    private ObservableList<ChipModel> sid3Models;
    private ObservableList<ChipModel> defaultModels;
    private ObservableList<String> mainFilters;
    private ObservableList<String> secondFilters;
    private ObservableList<String> thirdFilters;
    private ObservableList<SidReads> sidReads;
    private ObservableList<StereoMode> stereoModes;
    private ChangeListener<State> emulationChange;
    private boolean duringInitialization;

    public EmulationSettings(Player player) {
        super(player);
    }

    @FXML
    private void initialize() {
        this.duringInitialization = true;
        ResourceBundle bundle = this.util.getBundle();
        AudioSection audioSection = this.util.getConfig().getAudioSection();
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        this.mainFilterCurve.setAnimated(false);
        this.mainFilterCurve.setCreateSymbols(false);
        this.mainFilterCurve.setLegendVisible(false);
        this.secondFilterCurve.setAnimated(false);
        this.secondFilterCurve.setCreateSymbols(false);
        this.secondFilterCurve.setLegendVisible(false);
        this.thirdFilterCurve.setAnimated(false);
        this.thirdFilterCurve.setCreateSymbols(false);
        this.thirdFilterCurve.setLegendVisible(false);
        this.mainFilters = FXCollections.observableArrayList();
        this.mainFilter.setItems(this.mainFilters);
        this.secondFilters = FXCollections.observableArrayList();
        this.secondFilter.setItems(this.secondFilters);
        this.thirdFilters = FXCollections.observableArrayList();
        this.thirdFilter.setItems(this.thirdFilters);
        this.mainBalance.setLabelFormatter(new NumberToString(1));
        this.mainBalance.valueProperty().bindBidirectional((Property)audioSection.mainBalanceProperty());
        this.mainBalance.valueProperty().addListener((observable, oldValue, newValue) -> this.util.getPlayer().configureMixer(m -> m.setBalance(0, newValue.floatValue())));
        this.secondBalance.setLabelFormatter(new NumberToString(1));
        this.secondBalance.valueProperty().bindBidirectional((Property)audioSection.secondBalanceProperty());
        this.secondBalance.valueProperty().addListener((observable, oldValue, newValue) -> this.util.getPlayer().configureMixer(m -> m.setBalance(1, newValue.floatValue())));
        this.thirdBalance.setLabelFormatter(new NumberToString(1));
        this.thirdBalance.valueProperty().bindBidirectional((Property)audioSection.thirdBalanceProperty());
        this.thirdBalance.valueProperty().addListener((observable, oldValue, newValue) -> this.util.getPlayer().configureMixer(m -> m.setBalance(2, newValue.floatValue())));
        this.mainVolume.valueProperty().bindBidirectional((Property)audioSection.mainVolumeProperty());
        this.mainVolumeValue.textProperty().bindBidirectional((Property)audioSection.mainVolumeProperty(), new NumberToString(2));
        this.mainVolume.valueProperty().addListener((observable, oldValue, newValue) -> this.util.getPlayer().configureMixer(m -> m.setVolume(0, newValue.floatValue())));
        this.secondVolume.valueProperty().bindBidirectional((Property)audioSection.secondVolumeProperty());
        this.secondVolumeValue.textProperty().bindBidirectional((Property)audioSection.secondVolumeProperty(), new NumberToString(2));
        this.secondVolume.valueProperty().addListener((observable, oldValue, newValue) -> this.util.getPlayer().configureMixer(b -> b.setVolume(1, newValue.floatValue())));
        this.thirdVolume.valueProperty().bindBidirectional((Property)audioSection.thirdVolumeProperty());
        this.thirdVolumeValue.textProperty().bindBidirectional((Property)audioSection.thirdVolumeProperty(), new NumberToString(2));
        this.thirdVolume.valueProperty().addListener((observable, oldValue, newValue) -> this.util.getPlayer().configureMixer(b -> b.setVolume(2, newValue.floatValue())));
        this.stereoModes = FXCollections.observableArrayList((Object[])StereoMode.values());
        this.stereoMode.setConverter(new EnumToString(bundle));
        this.stereoMode.setItems(this.stereoModes);
        this.baseAddress.textProperty().bindBidirectional((Property)emulationSection.dualSidBaseProperty(), (StringConverter)new HexNumberToString());
        this.thirdAddress.textProperty().bindBidirectional((Property)emulationSection.thirdSIDBaseProperty(), (StringConverter)new HexNumberToString());
        this.sidReads = FXCollections.observableArrayList((Object[])SidReads.values());
        this.sidToRead.setConverter(new EnumToString(bundle));
        this.sidToRead.setItems(this.sidReads);
        this.sidToRead.getSelectionModel().select(emulationSection.getSidNumToRead());
        this.sid1Emulations = FXCollections.observableArrayList((Object[])Emulation.values());
        this.sid1Emulation.setConverter(new EnumToString(bundle));
        this.sid1Emulation.valueProperty().bindBidirectional(emulationSection.userEmulationProperty());
        this.sid1Emulation.setItems(this.sid1Emulations);
        this.sid2Emulations = FXCollections.observableArrayList((Object[])Emulation.values());
        this.sid2Emulation.setConverter(new EnumToString(bundle));
        this.sid2Emulation.valueProperty().bindBidirectional(emulationSection.stereoEmulationProperty());
        this.sid2Emulation.setItems(this.sid2Emulations);
        this.sid3Emulations = FXCollections.observableArrayList((Object[])Emulation.values());
        this.sid3Emulation.setConverter(new EnumToString(bundle));
        this.sid3Emulation.valueProperty().bindBidirectional(emulationSection.thirdEmulationProperty());
        this.sid3Emulation.setItems(this.sid3Emulations);
        this.sid1Models = FXCollections.observableArrayList((Object[])ChipModel.values());
        this.sid1Model.setConverter(new EnumToString(bundle));
        this.sid1Model.valueProperty().bindBidirectional(emulationSection.userSidModelProperty());
        this.sid1Model.setItems(this.sid1Models);
        this.sid2Models = FXCollections.observableArrayList((Object[])ChipModel.values());
        this.sid2Model.setConverter(new EnumToString(bundle));
        this.sid2Model.valueProperty().bindBidirectional(emulationSection.stereoSidModelProperty());
        this.sid2Model.setItems(this.sid2Models);
        this.sid3Models = FXCollections.observableArrayList((Object[])ChipModel.values());
        this.sid3Model.setConverter(new EnumToString(bundle));
        this.sid3Model.valueProperty().bindBidirectional(emulationSection.thirdSIDModelProperty());
        this.sid3Model.setItems(this.sid3Models);
        this.defaultModels = FXCollections.observableArrayList((Object[])new ChipModel[]{ChipModel.MOS6581, ChipModel.MOS8580});
        this.defaultModel.setConverter(new EnumToString(bundle));
        this.defaultModel.valueProperty().bindBidirectional(emulationSection.defaultSidModelProperty());
        this.defaultModel.setItems(this.defaultModels);
        this.defaultEmulations = FXCollections.observableArrayList((Object[])new Emulation[]{Emulation.RESID, Emulation.RESIDFP});
        this.defaultEmulation.setConverter(new EnumToString(bundle));
        this.defaultEmulation.valueProperty().bindBidirectional(emulationSection.defaultEmulationProperty());
        this.defaultEmulation.setItems(this.defaultEmulations);
        this.boosted8580.selectedProperty().bindBidirectional((Property)emulationSection.digiBoosted8580Property());
        this.fakeStereo.selectedProperty().bindBidirectional((Property)emulationSection.fakeStereoProperty());
        this.emulationChange = new EmulationChange();
        this.util.getPlayer().stateProperty().addListener(this.emulationChange);
        Platform.runLater(() -> {
            this.updateSettingsForTune(this.util.getPlayer().getTune());
            this.duringInitialization = false;
        });
    }

    private void updateSettingsForTune(SidTune tune) {
        this.addFilters(tune, 0, this.mainFilters, this.mainFilter);
        this.addFilters(tune, 1, this.secondFilters, this.secondFilter);
        this.addFilters(tune, 2, this.thirdFilters, this.thirdFilter);
        this.enableStereoSettings(tune);
    }

    private void enableStereoSettings(SidTune tune) {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        boolean second = SidTune.isSIDUsed(emulationSection, tune, 1);
        boolean third = SidTune.isSIDUsed(emulationSection, tune, 2);
        boolean isForcedStereo = emulationSection.isForceStereoTune();
        boolean isForced3Sid = emulationSection.isForce3SIDTune();
        if (isForced3Sid) {
            this.stereoMode.getSelectionModel().select((Object)StereoMode.THREE_SID);
        } else if (isForcedStereo) {
            this.stereoMode.getSelectionModel().select((Object)StereoMode.STEREO);
        } else {
            this.stereoMode.getSelectionModel().select((Object)StereoMode.AUTO);
        }
        this.mainBalance.setDisable(!second);
        this.secondVolume.setDisable(!second);
        this.secondBalance.setDisable(!second);
        this.sid2Emulation.setDisable(!second);
        this.sid2Model.setDisable(!second);
        this.secondFilter.setDisable(!second);
        this.secondFilterCurve.setDisable(!second);
        this.thirdVolume.setDisable(!third);
        this.thirdBalance.setDisable(!third);
        this.sid3Emulation.setDisable(!third);
        this.sid3Model.setDisable(!third);
        this.thirdFilter.setDisable(!third);
        this.thirdFilterCurve.setDisable(!third);
        this.sidToRead.setDisable(!emulationSection.isFakeStereo());
        this.baseAddress.setDisable(!isForcedStereo && !isForced3Sid);
        this.thirdAddress.setDisable(!isForced3Sid);
        this.fakeStereo.setDisable(emulationSection.getEngine() == Engine.HARDSID);
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.emulationChange);
    }

    @FXML
    private void setSid1Emulation() {
        this.addFilters(this.util.getPlayer().getTune(), 0, this.mainFilters, this.mainFilter);
        this.updateSIDChipConfiguration();
    }

    @FXML
    private void setSid2Emulation() {
        this.addFilters(this.util.getPlayer().getTune(), 1, this.secondFilters, this.secondFilter);
        this.updateSIDChipConfiguration();
    }

    @FXML
    private void setSid3Emulation() {
        this.addFilters(this.util.getPlayer().getTune(), 2, this.thirdFilters, this.thirdFilter);
        this.updateSIDChipConfiguration();
    }

    @FXML
    private void setDefaultEmulation() {
        this.setSid1Emulation();
        this.setSid2Emulation();
        this.setSid3Emulation();
    }

    @FXML
    private void setSid1Model() {
        this.addFilters(this.util.getPlayer().getTune(), 0, this.mainFilters, this.mainFilter);
        this.updateSIDChipConfiguration();
        this.setSid2Model();
        this.setSid3Model();
    }

    @FXML
    private void setSid2Model() {
        this.addFilters(this.util.getPlayer().getTune(), 1, this.secondFilters, this.secondFilter);
        this.updateSIDChipConfiguration();
    }

    @FXML
    private void setSid3Model() {
        this.addFilters(this.util.getPlayer().getTune(), 2, this.thirdFilters, this.thirdFilter);
        this.updateSIDChipConfiguration();
    }

    @FXML
    private void setDefaultModel() {
        this.setSid1Model();
    }

    @FXML
    private void setBaseAddress() {
        this.enableStereoSettings(this.util.getPlayer().getTune());
        this.updateSIDChipConfiguration();
    }

    @FXML
    private void setThirdAddress() {
        this.enableStereoSettings(this.util.getPlayer().getTune());
        this.updateSIDChipConfiguration();
    }

    @FXML
    private void setFakeStereo() {
        this.enableStereoSettings(this.util.getPlayer().getTune());
        this.setMainFilter();
        this.setSecondFilter();
    }

    @FXML
    private void setStereoMode() {
        StereoMode mode = (StereoMode)((Object)this.stereoMode.getSelectionModel().getSelectedItem());
        if (mode == StereoMode.THREE_SID) {
            this.util.getConfig().getEmulationSection().setForceStereoTune(true);
            this.util.getConfig().getEmulationSection().setForce3SIDTune(true);
        } else if (mode == StereoMode.STEREO) {
            this.util.getConfig().getEmulationSection().setForceStereoTune(true);
            this.util.getConfig().getEmulationSection().setForce3SIDTune(false);
        } else {
            this.util.getConfig().getEmulationSection().setForceStereoTune(false);
            this.util.getConfig().getEmulationSection().setForce3SIDTune(false);
        }
        this.enableStereoSettings(this.util.getPlayer().getTune());
        this.setMainFilter();
        this.setSecondFilter();
        this.setThirdFilter();
    }

    @FXML
    private void setSidToRead() {
        int sidNumToRead = this.sidToRead.getSelectionModel().getSelectedIndex();
        this.util.getConfig().getEmulationSection().setSidNumToRead(sidNumToRead);
    }

    @FXML
    private void setDigiBoost() {
        this.util.getPlayer().configureSIDs((num, sid) -> sid.input(this.util.getConfig().getEmulationSection().isDigiBoosted8580() ? sid.getInputDigiBoost() : 0));
    }

    @FXML
    private void setMainFilter() {
        this.setFilter(0, this.mainFilter);
        this.updateSIDChipConfiguration();
        this.drawFilterCurve(this.mainFilter, this.mainFilterCurve);
    }

    @FXML
    private void setSecondFilter() {
        this.setFilter(1, this.secondFilter);
        this.updateSIDChipConfiguration();
        this.drawFilterCurve(this.secondFilter, this.secondFilterCurve);
    }

    @FXML
    private void setThirdFilter() {
        this.setFilter(2, this.thirdFilter);
        this.updateSIDChipConfiguration();
        this.drawFilterCurve(this.thirdFilter, this.thirdFilterCurve);
    }

    private void setFilter(int sidNum, ComboBox<String> filterBox) {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        String filterName = (String)filterBox.getSelectionModel().getSelectedItem();
        boolean filterDisabled = "".equals(filterName);
        emulationSection.setFilterEnable(sidNum, !filterDisabled);
        SidTune tune = this.util.getPlayer().getTune();
        Engine engine = emulationSection.getEngine();
        Emulation emulation = Emulation.getEmulation(emulationSection, tune, sidNum);
        ChipModel model = ChipModel.getChipModel(emulationSection, tune, sidNum);
        emulationSection.setFilterName(sidNum, engine, emulation, model, !filterDisabled ? filterName : null);
    }

    private void updateSIDChipConfiguration() {
        if (!this.duringInitialization) {
            this.util.getPlayer().updateSIDChipConfiguration();
        }
    }

    private void drawFilterCurve(ComboBox<String> filterBox, LineChart<Number, Number> filterCurve) {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        SidTune tune = this.util.getPlayer().getTune();
        boolean second = SidTune.isSIDUsed(emulationSection, tune, 1);
        boolean third = SidTune.isSIDUsed(emulationSection, tune, 2);
        ArrayList<XYChart.Data> dataList = new ArrayList<XYChart.Data>();
        Optional<FilterSection> optFilter = this.util.getConfig().getFilterSection().stream().filter(f -> f.getName().equals(filterBox.getSelectionModel().getSelectedItem())).findFirst();
        if (optFilter.isPresent()) {
            FilterSection filter = optFilter.get();
            if ((filterCurve != this.secondFilterCurve || second) && (filterCurve != this.thirdFilterCurve || third)) {
                for (int fc = 0; fc < 2048; ++fc) {
                    double data;
                    if (filter.isReSIDFilter6581() || filter.isReSIDFilter8580()) {
                        data = resid_builder.resid.FilterModelConfig.estimateFrequency(filter, fc);
                        dataList.add(new XYChart.Data((Object)fc, (Object)data));
                        continue;
                    }
                    if (!filter.isReSIDfpFilter6581() && !filter.isReSIDfpFilter8580()) continue;
                    data = FilterModelConfig.estimateFrequency(filter, fc);
                    dataList.add(new XYChart.Data((Object)fc, (Object)data));
                }
            }
        }
        XYChart.Series series = new XYChart.Series();
        series.setData(FXCollections.observableArrayList(dataList));
        ArrayList<XYChart.Series> seriesList = new ArrayList<XYChart.Series>();
        seriesList.add(series);
        filterCurve.setData(FXCollections.observableArrayList(seriesList));
    }

    private void addFilters(SidTune tune, int num, ObservableList<String> filters, ComboBox<String> filter) {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        Engine engine = emulationSection.getEngine();
        Emulation emulation = Emulation.getEmulation(emulationSection, tune, num);
        ChipModel model = ChipModel.getChipModel(emulationSection, tune, num);
        String filterName = emulationSection.getFilterName(num, engine, emulation, model);
        boolean filterEnable = emulationSection.isFilterEnable(num);
        filters.clear();
        if (engine == Engine.NETSID) {
            filters.addAll(TrySetSidModel.getFilterNames(model));
        } else {
            filters.add((Object)"");
            for (IFilterSection iFilterSection : this.util.getConfig().getFilterSection()) {
                if (emulation.equals((Object)Emulation.RESIDFP)) {
                    if (iFilterSection.isReSIDfpFilter6581() && model == ChipModel.MOS6581) {
                        filters.add((Object)iFilterSection.getName());
                        continue;
                    }
                    if (!iFilterSection.isReSIDfpFilter8580() || model != ChipModel.MOS8580) continue;
                    filters.add((Object)iFilterSection.getName());
                    continue;
                }
                if (iFilterSection.isReSIDFilter6581() && model == ChipModel.MOS6581) {
                    filters.add((Object)iFilterSection.getName());
                    continue;
                }
                if (!iFilterSection.isReSIDFilter8580() || model != ChipModel.MOS8580) continue;
                filters.add((Object)iFilterSection.getName());
            }
        }
        if (filterEnable) {
            filter.getSelectionModel().select((Object)filterName);
        } else {
            filter.getSelectionModel().select(0);
        }
    }

    private static enum SidReads {
        FIRST_SID,
        SECOND_SID,
        THIRD_SID;

    }

    private static enum StereoMode {
        AUTO,
        STEREO,
        THREE_SID;

    }

    protected final class EmulationChange
    implements ChangeListener<State> {
        protected EmulationChange() {
        }

        public void changed(ObservableValue<? extends State> observable, State oldValue, State newValue) {
            if (newValue == State.START) {
                Platform.runLater(() -> EmulationSettings.this.updateSettingsForTune(EmulationSettings.this.util.getPlayer().getTune()));
            }
        }
    }
}

