/*
 * Decompiled with CFR 0.152.
 */
package ui.download;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import ui.download.RBCWrapperDelegate;

final class RBCWrapper
implements ReadableByteChannel {
    private RBCWrapperDelegate delegate;
    private long expectedSize;
    private ReadableByteChannel rbc;
    private long readSoFar;

    RBCWrapper(ReadableByteChannel rbc, long expectedSize, RBCWrapperDelegate delegate) {
        this.delegate = delegate;
        this.expectedSize = expectedSize;
        this.rbc = rbc;
    }

    @Override
    public void close() throws IOException {
        this.rbc.close();
    }

    @Override
    public boolean isOpen() {
        return this.rbc.isOpen();
    }

    @Override
    public int read(ByteBuffer bb) throws IOException {
        int n = this.rbc.read(bb);
        if (n > 0) {
            this.readSoFar += (long)n;
            double progress = this.expectedSize > 0L ? (double)this.readSoFar / (double)this.expectedSize * 100.0 : 0.0;
            this.delegate.rbcProgressCallback(this, progress);
        }
        return n;
    }
}

