/*
 * Decompiled with CFR 0.152.
 */
package ui.download;

import java.io.File;
import javafx.application.Platform;
import javafx.scene.Node;
import ui.common.UIUtil;
import ui.download.IDownloadListener;

public abstract class ProgressListener
implements IDownloadListener {
    protected UIUtil util;
    private Node node;

    public ProgressListener(UIUtil util, Node node) {
        this.util = util;
        this.node = node;
    }

    @Override
    public void downloadStep(int pct) {
        Platform.runLater(() -> this.util.progressProperty(this.node).set((double)pct / 100.0));
    }

    @Override
    public void downloadStop(File downloadedFile) {
        if (downloadedFile == null) {
            Platform.runLater(() -> this.util.progressProperty(this.node).set(0.0));
        }
        this.downloaded(downloadedFile);
    }

    public abstract void downloaded(File var1);
}

