/*
 * Decompiled with CFR 0.152.
 */
package ui.download;

import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import ui.download.IDownloadListener;
import ui.download.RBCWrapper;
import ui.download.RBCWrapperDelegate;
import ui.entities.config.Configuration;

public class DownloadThread
extends Thread
implements RBCWrapperDelegate {
    private static final String UTF_8 = "UTF-8";
    private static final String ILLEGAL_FILENAME_CHARS = "[?:]";
    private static final String REPLACEMENT_ILLEGAL_CHAR = "_";
    public static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MAX_TRY_COUNT = 3;
    private final Configuration config;
    private final URL url;
    private final IDownloadListener listener;
    private Proxy proxy;
    private boolean handleCrcAndSplits;

    public DownloadThread(Configuration cfg, IDownloadListener listener, URL url) {
        this(cfg, listener, url, true);
    }

    public DownloadThread(Configuration cfg, IDownloadListener listener, URL url, boolean handleCrcAndSplits) {
        this.config = cfg;
        this.url = url;
        this.listener = listener;
        this.proxy = this.getProxy();
        this.handleCrcAndSplits = handleCrcAndSplits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            File availableFile = this.createLocalFile(this.url);
            if (this.alreadyAvailable(availableFile)) {
                this.listener.downloadStop(availableFile);
                return;
            }
        }
        catch (IOException availableFile) {
            // empty catch block
        }
        File downloadedFile = null;
        try {
            boolean isSplittedInChunks;
            boolean bl = isSplittedInChunks = this.handleCrcAndSplits && this.isSplittedInChunks();
            downloadedFile = isSplittedInChunks ? this.downloadAndMergeChunks() : this.download(this.url, true);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            this.listener.downloadStop(null);
            return;
        }
        try {
            if (this.handleCrcAndSplits) {
                File crcFile = this.download(this.getCrcUrl(), false);
                boolean checkCrc = this.checkCrc(crcFile, downloadedFile);
                if (!checkCrc) {
                    System.err.println("CRC32 check failed!");
                    downloadedFile = null;
                } else {
                    System.out.println("CRC32 check OK for download: " + this.url);
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.listener.downloadStop(downloadedFile);
        }
    }

    private boolean alreadyAvailable(File file) throws IOException {
        if (!this.handleCrcAndSplits) {
            return file.exists() && file.canRead() && file.length() > 0L;
        }
        File crcFile = this.download(this.getCrcUrl(), false);
        boolean checkCrc = this.checkCrc(crcFile, file);
        if (!checkCrc) {
            System.err.println("Online file contents has changed, re-download!");
            return false;
        }
        return true;
    }

    private Proxy getProxy() {
        if (this.config.getSidplay2Section().isEnableProxy()) {
            InetSocketAddress addr = new InetSocketAddress(this.config.getSidplay2Section().getProxyHostname(), this.config.getSidplay2Section().getProxyPort());
            return new Proxy(Proxy.Type.HTTP, addr);
        }
        return Proxy.NO_PROXY;
    }

    private boolean isSplittedInChunks() throws IOException {
        return this.checkExistingURL(this.getURL(1));
    }

    private File downloadAndMergeChunks() throws IOException, MalformedURLException {
        ArrayList<File> chunks = new ArrayList<File>();
        int part = 1;
        do {
            File chunk = this.download(this.getURL(part), true);
            chunk.deleteOnExit();
            chunks.add(chunk);
        } while (this.hasNextPart(++part));
        File downloadedFile = this.mergeChunks(chunks);
        return downloadedFile;
    }

    private URL getURL(int part) throws MalformedURLException {
        return new URL(this.getURLUsingExt("." + String.format("%03d", part)));
    }

    private boolean checkExistingURL(URL currentURL) throws IOException {
        HttpURLConnection connection = this.getConnection(currentURL);
        return connection.getResponseCode() == 200 && connection.getContentLength() >= 0;
    }

    private HttpURLConnection getConnection(URL currentURL) throws IOException, ProtocolException {
        HttpURLConnection.setFollowRedirects(true);
        HttpURLConnection connection = (HttpURLConnection)currentURL.openConnection(this.proxy);
        connection.setRequestMethod("HEAD");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File download(URL currentURL, boolean retry) throws IOException {
        String decoded;
        try {
            decoded = URLDecoder.decode(currentURL.toString(), UTF_8);
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
        int tries = 0;
        do {
            ++tries;
            File file = this.createLocalFile(currentURL);
            FileOutputStream fos = null;
            try {
                long contentLength = this.getConnection(currentURL).getContentLength();
                URLConnection connection = currentURL.openConnection(this.proxy);
                RBCWrapper rbc = new RBCWrapper(Channels.newChannel(connection.getInputStream()), contentLength, this);
                fos = new FileOutputStream(file);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                if (file.length() == contentLength) {
                    File file2 = file;
                    return file2;
                }
            }
            catch (IOException e) {
                if (retry) {
                    System.err.println(String.format("Download failed for %s, next try!", decoded));
                    continue;
                }
                throw e;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } while (tries != 3);
        throw new IOException(String.format("Download error for %s, i have tried %d times! ", decoded, 3));
    }

    private boolean hasNextPart(int part) throws IOException {
        return this.checkExistingURL(this.getURL(part));
    }

    private File createLocalFile(URL currentURL) {
        try {
            String decoded = URLDecoder.decode(currentURL.getFile(), UTF_8);
            String name = new File(decoded).getName();
            return new File(this.config.getSidplay2Section().getTmpDir(), name.replaceAll(ILLEGAL_FILENAME_CHARS, REPLACEMENT_ILLEGAL_CHAR));
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    private File mergeChunks(List<File> chunks) throws IOException {
        File mergedFile = null;
        for (File chunk : chunks) {
            if (mergedFile == null) {
                mergedFile = chunk;
                continue;
            }
            mergedFile = this.merge(mergedFile, chunk);
        }
        File resultFile = this.createLocalFile(this.url);
        TFile.cp((File)mergedFile, (File)resultFile);
        return resultFile;
    }

    private File merge(File resultFile, File chunk) throws IOException {
        File tmp = File.createTempFile("jsidplay2", "tmp");
        tmp.deleteOnExit();
        try (BufferedInputStream is = new BufferedInputStream(new SequenceInputStream(new FileInputStream(resultFile), new FileInputStream(chunk)));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmp));){
            int bytesRead;
            byte[] buffer = new byte[0x100000];
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        return tmp;
    }

    private URL getCrcUrl() throws MalformedURLException {
        return new URL(this.getURLUsingExt(".crc"));
    }

    private boolean checkCrc(File crcFile, File download) throws IOException {
        Properties properties = new Properties();
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(crcFile));){
            properties.load(stream);
        }
        try {
            long crc = Long.valueOf(properties.getProperty("crc32"), 16);
            long fileLength = Integer.valueOf(properties.getProperty("size")).intValue();
            String filename = properties.getProperty("filename");
            if (!download.getName().equals(filename)) {
                return false;
            }
            if (download.length() != fileLength) {
                return false;
            }
            return DownloadThread.calculateCRC32(download) == crc;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static long calculateCRC32(File file) throws IOException {
        try (CheckedInputStream cis = new CheckedInputStream(new FileInputStream(file), new CRC32());){
            byte[] buffer = new byte[0x100000];
            while (cis.read(buffer) >= 0) {
            }
            long l = cis.getChecksum().getValue();
            return l;
        }
    }

    private String getURLUsingExt(String ext) {
        String path = this.url.toExternalForm();
        int extIdx = path.lastIndexOf(46);
        if (extIdx != -1) {
            return path.substring(0, extIdx) + ext;
        }
        throw new RuntimeException("filename must have a file extension");
    }

    @Override
    public void rbcProgressCallback(RBCWrapper rbc, double progress) {
        this.listener.downloadStep((int)progress);
    }

    public static void main(String[] args) {
        try {
            long checksum = DownloadThread.calculateCRC32(new File(args[0]));
            System.out.println(String.format("%8X", checksum).replace(' ', '0'));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }
}

