/*
 * Decompiled with CFR 0.152.
 */
package ui.diskcollection;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;

public class DiskCollectionTreeItem
extends TreeItem<File> {
    private File rootFile;
    private FileFilter fileFilter;
    private boolean hasLoadedChildren;
    private boolean isLeaf;

    public DiskCollectionTreeItem(File file, File rootFile, FileFilter fileFilter) {
        super((Object)file);
        this.rootFile = rootFile;
        this.isLeaf = file.isFile();
        this.fileFilter = fileFilter;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public ObservableList<TreeItem<File>> getChildren() {
        if (!this.hasLoadedChildren) {
            this.loadChildren();
        }
        return super.getChildren();
    }

    private void loadChildren() {
        this.hasLoadedChildren = true;
        ArrayList<DiskCollectionTreeItem> children = new ArrayList<DiskCollectionTreeItem>();
        File[] listFiles = ((File)this.getValue()).listFiles(this.fileFilter);
        if (listFiles != null) {
            Arrays.sort(listFiles, (a, b) -> {
                Integer bw;
                Integer aw = a.isFile() ? 1 : 0;
                if (aw.equals(bw = Integer.valueOf(b.isFile() ? 1 : 0))) {
                    return a.getName().toLowerCase(Locale.ENGLISH).compareTo(b.getName().toLowerCase(Locale.ENGLISH));
                }
                return aw.compareTo(bw);
            });
            for (File file : listFiles) {
                children.add(new DiskCollectionTreeItem(file, this.rootFile, this.fileFilter));
            }
        }
        super.getChildren().setAll(children);
    }
}

