/*
 * Decompiled with CFR 0.152.
 */
package ui.diskcollection;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.awt.Desktop;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.stage.DirectoryChooser;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.directory.Directory;
import ui.diskcollection.DiskCollectionTreeItem;
import ui.diskcollection.DiskCollectionType;
import ui.download.DownloadThread;
import ui.download.ProgressListener;
import ui.entities.config.SidPlay2Section;
import ui.filefilter.DiskFileFilter;
import ui.filefilter.DocsFileFilter;
import ui.filefilter.ScreenshotFileFilter;
import ui.filefilter.TapeFileFilter;

public class DiskCollection
extends Tab
implements UIPart {
    public static final String MAGS_ID = "MAGS";
    public static final String DEMOS_ID = "DEMOS";
    public static final String HVMEC_ID = "HVMEC";
    private static final String HVMEC_DATA = "DATA";
    private static final String HVMEC_CONTROL = "CONTROL";
    @FXML
    private CheckBox autoConfiguration;
    @FXML
    private Directory directory;
    @FXML
    private ImageView screenshot;
    @FXML
    private TreeView<File> fileBrowser;
    @FXML
    private ContextMenu contextMenu;
    @FXML
    private MenuItem start;
    @FXML
    private MenuItem attachDisk;
    @FXML
    private TextField collectionDir;
    private UIUtil util;
    private Convenience convenience;
    private ObjectProperty<DiskCollectionType> type;
    private String downloadUrl;
    private final FileFilter screenshotsFileFilter = new ScreenshotFileFilter();
    protected final FileFilter diskFileFilter = new DiskFileFilter();
    private final FileFilter fileBrowserFileFilter = new FileFilter(){
        private final TapeFileFilter tapeFileFilter = new TapeFileFilter();
        private final DocsFileFilter docsFileFilter = new DocsFileFilter();

        @Override
        public boolean accept(File file) {
            if (DiskCollection.this.getType() == DiskCollectionType.HVMEC && file.isDirectory() && file.getName().equals(DiskCollection.HVMEC_CONTROL)) {
                return false;
            }
            return DiskCollection.this.diskFileFilter.accept(file = DiskCollection.this.extractGZip(file)) || this.tapeFileFilter.accept(file) || this.docsFileFilter.accept(file);
        }
    };

    public DiskCollectionType getType() {
        return (DiskCollectionType)((Object)this.type.get());
    }

    public void setType(DiskCollectionType type) {
        switch (type) {
            case HVMEC: {
                this.setId(HVMEC_ID);
                break;
            }
            case DEMOS: {
                this.setId(DEMOS_ID);
                break;
            }
            case MAGS: {
                this.setId(MAGS_ID);
                break;
            }
        }
        this.setText(this.util.getBundle().getString(this.getId()));
        this.type.set((Object)type);
    }

    public DiskCollection(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
    }

    @FXML
    private void initialize() {
        this.convenience = new Convenience(this.util.getPlayer());
        this.directory.setPrefHeight(Double.MAX_VALUE);
        this.directory.getAutoStartFileProperty().addListener(observable -> this.attachAndRunDemo((File)((TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem()).getValue(), (File)this.directory.getAutoStartFileProperty().get()));
        this.fileBrowser.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && ((File)newValue.getValue()).isFile()) {
                File file = (File)newValue.getValue();
                this.showScreenshot(file);
                try {
                    this.directory.loadPreview(this.extract(file));
                }
                catch (Exception e) {
                    System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
                }
            }
        });
        this.fileBrowser.setOnKeyPressed(event -> {
            File file;
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            if (event.getCode() == KeyCode.ENTER && selectedItem != null && ((File)selectedItem.getValue()).isFile() && (file = (File)selectedItem.getValue()).isFile()) {
                this.attachAndRunDemo((File)selectedItem.getValue(), null);
            }
        });
        this.fileBrowser.setOnMousePressed(event -> {
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            if (selectedItem != null && ((File)selectedItem.getValue()).isFile() && event.isPrimaryButtonDown() && event.getClickCount() > 1) {
                this.attachAndRunDemo((File)((TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem()).getValue(), null);
            }
        });
        this.contextMenu.setOnShown(event -> {
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            boolean disable = selectedItem == null || !((File)selectedItem.getValue()).isFile();
            this.start.setDisable(disable);
            this.attachDisk.setDisable(disable);
        });
        this.type = new SimpleObjectProperty();
        this.type.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            File initialRoot;
            switch (this.getType()) {
                case HVMEC: {
                    this.downloadUrl = this.util.getConfig().getOnlineSection().getHvmecUrl();
                    initialRoot = this.util.getConfig().getSidplay2Section().getHVMECFile();
                    break;
                }
                case DEMOS: {
                    this.downloadUrl = this.util.getConfig().getOnlineSection().getDemosUrl();
                    initialRoot = this.util.getConfig().getSidplay2Section().getDemosFile();
                    break;
                }
                case MAGS: {
                    this.downloadUrl = this.util.getConfig().getOnlineSection().getMagazinesUrl();
                    initialRoot = this.util.getConfig().getSidplay2Section().getMagsFile();
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal disk collection type : " + this.type);
                }
            }
            if (initialRoot != null) {
                this.setRootFile(initialRoot);
            }
        }));
    }

    @FXML
    private void doAutoConfiguration() {
        if (this.autoConfiguration.isSelected()) {
            this.autoConfiguration.setDisable(true);
            try {
                DownloadThread downloadThread = new DownloadThread(this.util.getConfig(), new ProgressListener(this.util, (Node)this.fileBrowser){

                    @Override
                    public void downloaded(File downloadedFile) {
                        Platform.runLater(() -> {
                            DiskCollection.this.autoConfiguration.setDisable(false);
                            if (downloadedFile != null) {
                                DiskCollection.this.setRootFile(downloadedFile);
                            }
                        });
                    }
                }, new URL(this.downloadUrl));
                downloadThread.start();
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
        }
    }

    @FXML
    private void attachDisk() {
        File file = (File)((TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem()).getValue();
        try {
            File extractedFile = this.extract(file);
            this.util.getPlayer().insertDisk(extractedFile);
        }
        catch (IOException | SidTuneError e) {
            System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
        }
    }

    @FXML
    private void start() {
        this.attachAndRunDemo((File)((TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem()).getValue(), null);
    }

    @FXML
    private void doBrowse() {
        DirectoryChooser fileDialog = new DirectoryChooser();
        SidPlay2Section sidplay2 = this.util.getConfig().getSidplay2Section();
        fileDialog.setInitialDirectory(sidplay2.getLastDirectoryFolder());
        File directory = fileDialog.showDialog(this.autoConfiguration.getScene().getWindow());
        if (directory != null) {
            sidplay2.setLastDirectory(directory.getAbsolutePath());
            this.setRootFile(directory);
        }
    }

    protected void setRootFile(File rootFile) {
        if (rootFile.exists()) {
            this.collectionDir.setText(rootFile.getAbsolutePath());
            TFile theRootFile = new TFile(rootFile);
            this.fileBrowser.setRoot((TreeItem)new DiskCollectionTreeItem((File)theRootFile, (File)theRootFile, this.fileBrowserFileFilter));
            if (this.getType() == DiskCollectionType.HVMEC) {
                this.util.getConfig().getSidplay2Section().setHVMEC(rootFile.getAbsolutePath());
            } else if (this.getType() == DiskCollectionType.DEMOS) {
                this.util.getConfig().getSidplay2Section().setDemos(rootFile.getAbsolutePath());
            } else if (this.getType() == DiskCollectionType.MAGS) {
                this.util.getConfig().getSidplay2Section().setMags(rootFile.getAbsolutePath());
            }
        }
    }

    protected void attachAndRunDemo(File file, File autoStartFile) {
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".pdf")) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("Awt Desktop is not supported!");
            }
        } else {
            try {
                File extractedFile = this.extract(file);
                if (this.convenience.autostart(extractedFile, Convenience.LEXICALLY_FIRST_MEDIA, autoStartFile)) {
                    this.util.setPlayingTab(this);
                }
            }
            catch (IOException | URISyntaxException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    protected void showScreenshot(File file) {
        Image image = this.createImage(file);
        if (image != null) {
            this.screenshot.setImage(image);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Image createImage(File file) {
        try {
            File screenshot = this.findScreenshot(file);
            if (screenshot == null) return null;
            if (!screenshot.exists()) return null;
            try (TFileInputStream is = new TFileInputStream(screenshot);){
                Image image = new Image((InputStream)is);
                return image;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private File findScreenshot(File file) {
        TreeItem rootItem = this.fileBrowser.getRoot();
        if (rootItem == null) {
            return null;
        }
        String parentPath = this.getType() == DiskCollectionType.HVMEC ? file.getParentFile().getPath().replace(HVMEC_DATA, HVMEC_CONTROL) : file.getParentFile().getPath();
        List<File> parentFiles = PathUtils.getFiles(parentPath, (File)rootItem.getValue(), null);
        if (parentFiles.size() > 0) {
            File parentFile = parentFiles.get(parentFiles.size() - 1);
            File[] listFiles = parentFile.listFiles();
            if (listFiles == null) {
                return null;
            }
            for (File photoFile : listFiles) {
                if (photoFile.isDirectory() || !this.screenshotsFileFilter.accept(photoFile)) continue;
                return photoFile;
            }
        }
        return null;
    }

    private File extract(File file) throws IOException {
        if (file.getName().toLowerCase(Locale.US).endsWith(".gz")) {
            return this.extractGZip(file);
        }
        String tmpDir = this.util.getConfig().getSidplay2Section().getTmpDir();
        File dst = new File(tmpDir, file.getName());
        if (!dst.exists()) {
            TFile.cp((File)file, (File)dst);
        }
        dst.deleteOnExit();
        return dst;
    }

    private File extractGZip(File file) {
        if (file.getName().toLowerCase(Locale.US).endsWith(".gz")) {
            String tmpDir = this.util.getConfig().getSidplay2Section().getTmpDir();
            File dst = new File(tmpDir, PathUtils.getFilenameWithoutSuffix(file.getName()));
            try (GZIPInputStream is = new GZIPInputStream((InputStream)new TFileInputStream(file));){
                if (!dst.exists()) {
                    TFile.cp((InputStream)is, (File)dst);
                }
            }
            catch (IOException e) {
                return file;
            }
            dst.deleteOnExit();
            return dst;
        }
        return file;
    }
}

