/*
 * Decompiled with CFR 0.152.
 */
package ui.disassembler;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.disassembler.CPUCommand;
import libsidutils.disassembler.SimpleDisassembler;
import sidplay.Player;
import sidplay.player.State;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.disassembler.AssemblyLine;
import ui.entities.config.SidPlay2Section;

public class Disassembler
extends Tab
implements UIPart {
    public static final String ID = "DISASSEMBLER";
    @FXML
    private TextField address;
    @FXML
    private TextField startAddress;
    @FXML
    private TextField endAddress;
    @FXML
    private Button driverAddress;
    @FXML
    private Button loadAddress;
    @FXML
    private Button initAddress;
    @FXML
    private Button playerAddress;
    @FXML
    private Button save;
    @FXML
    private TableView<AssemblyLine> memoryTable;
    private ObservableList<AssemblyLine> assemblyLines;
    private DisassemblerRefresh disassemblerRefresh;
    private static final Map<Integer, CPUCommand> fCommands = SimpleDisassembler.getCpuCommands();
    private UIUtil util;

    public Disassembler(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.setContent((Node)this.util.parse());
        this.setId(ID);
        this.setText(this.util.getBundle().getString(this.getId()));
    }

    @FXML
    private void initialize() {
        this.assemblyLines = FXCollections.observableArrayList();
        this.memoryTable.setItems(this.assemblyLines);
        this.disassemble(0);
        this.setTune();
        this.disassemblerRefresh = new DisassemblerRefresh();
        this.util.getPlayer().stateProperty().addListener((ChangeListener)this.disassemblerRefresh);
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener((ChangeListener)this.disassemblerRefresh);
    }

    protected void setTune() {
        if (this.util.getPlayer().getTune() == null) {
            return;
        }
        Platform.runLater(() -> {
            SidTuneInfo tuneInfo = this.util.getPlayer().getTune().getInfo();
            this.driverAddress.setText(this.getDriverAddress(tuneInfo));
            this.loadAddress.setText(this.getLoadAddress(tuneInfo));
            this.initAddress.setText(this.getInitAddress(tuneInfo));
            this.playerAddress.setText(this.getPlayerAddress(tuneInfo));
        });
    }

    private String getPlayerAddress(SidTuneInfo tuneInfo) {
        if (tuneInfo.getPlayAddr() == 65535) {
            return "N/A";
        }
        return String.format("0x%04x", tuneInfo.getPlayAddr());
    }

    private String getInitAddress(SidTuneInfo tuneInfo) {
        return String.format("0x%04x", tuneInfo.getInitAddr());
    }

    private String getLoadAddress(SidTuneInfo tuneInfo) {
        return String.format("0x%04x - 0x%04x", tuneInfo.getLoadAddr(), tuneInfo.getLoadAddr() + tuneInfo.getC64dataLen() - 1);
    }

    private String getDriverAddress(SidTuneInfo tuneInfo) {
        if (tuneInfo.getDeterminedDriverAddr() == 0) {
            return "N/A";
        }
        return String.format("0x%04x - 0x%04x", tuneInfo.getDeterminedDriverAddr(), tuneInfo.getDeterminedDriverAddr() + tuneInfo.getDeterminedDriverLength() - 1);
    }

    private void disassemble(int startAddr) {
        CPUCommand cmd;
        this.assemblyLines.clear();
        byte[] ram = this.util.getPlayer().getC64().getRAM();
        int offset = startAddr;
        do {
            cmd = fCommands.get(ram[offset & 0xFFFF] & 0xFF);
            AssemblyLine assemblyLine = this.createAssemblyLine(ram, offset & 0xFFFF, cmd);
            this.assemblyLines.add((Object)assemblyLine);
        } while ((offset += cmd.getByteCount()) <= 65535);
    }

    protected AssemblyLine createAssemblyLine(byte[] ram, int startAddr, CPUCommand cmd) {
        AssemblyLine assemblyLine = new AssemblyLine();
        assemblyLine.setAddress(String.format("%04X", startAddr & 0xFFFF));
        StringBuilder hexBytes = new StringBuilder();
        for (int i = 0; i < cmd.getByteCount(); ++i) {
            hexBytes.append(String.format("%02X ", ram[startAddr + i & 0xFFFF]));
        }
        assemblyLine.setBytes(hexBytes.toString());
        String[] parts = SimpleDisassembler.getInstance().getDisassembly(ram, startAddr).split(":", 2);
        assemblyLine.setMnemonic(parts[0]);
        if (parts.length == 2) {
            assemblyLine.setOperands(parts[1]);
        }
        assemblyLine.setCycles(cmd.getCycles());
        return assemblyLine;
    }

    @FXML
    private void gotoMemStart() {
        this.disassemble(0);
    }

    @FXML
    private void gotoAddress() {
        this.gotoMem(this.address.getText());
    }

    @FXML
    private void gotoDriverAddress() {
        this.gotoMem(this.driverAddress.getText());
    }

    @FXML
    private void gotoLoadAddress() {
        this.gotoMem(this.loadAddress.getText());
    }

    @FXML
    private void gotoInitAddress() {
        this.gotoMem(this.initAddress.getText());
    }

    @FXML
    private void gotoPlayerAddress() {
        this.gotoMem(this.playerAddress.getText());
    }

    private void gotoMem(String destination) {
        try {
            this.disassemble((int)(Integer.decode(destination.substring(0, 6)) & 0xFFFF));
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
    }

    @FXML
    private void saveMemory() {
        FileChooser fileDialog = new FileChooser();
        SidPlay2Section sidplay2 = this.util.getConfig().getSidplay2Section();
        fileDialog.setInitialDirectory(sidplay2.getLastDirectoryFolder());
        File file = fileDialog.showSaveDialog(this.save.getScene().getWindow());
        if (file != null) {
            sidplay2.setLastDirectory(file.getParent());
            try (FileOutputStream fos = new FileOutputStream(file);){
                int start = Integer.decode(this.startAddress.getText());
                int end = Integer.decode(this.endAddress.getText()) + 1;
                end &= 0xFFFF;
                fos.write((start &= 0xFFFF) & 0xFF);
                fos.write(start >> 8);
                byte[] ram = this.util.getPlayer().getC64().getRAM();
                while (start != end) {
                    fos.write(ram[start]);
                    start = start + 1 & 0xFFFF;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private final class DisassemblerRefresh
    implements ChangeListener<State> {
        private DisassemblerRefresh() {
        }

        public void changed(ObservableValue<? extends State> observable, State oldValue, State newValue) {
            if (newValue == State.START) {
                Platform.runLater(() -> Disassembler.this.setTune());
            }
        }
    }
}

