/*
 * Decompiled with CFR 0.152.
 */
package ui.directory;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import libsidplay.config.IConfig;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.PathUtils;
import libsidutils.directory.CartridgeDirectory;
import libsidutils.directory.DirEntry;
import libsidutils.directory.Directory;
import libsidutils.directory.DiskDirectory;
import libsidutils.directory.T64Directory;
import sidplay.Player;
import ui.entities.collection.HVSCEntry;
import ui.entities.config.SidPlay2Section;
import ui.filefilter.DiskFileFilter;
import ui.filefilter.TuneFileFilter;

public class PseudoDirectory {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    private static TuneFileFilter tuneFilter = new TuneFileFilter();
    private static DiskFileFilter diskFilter = new DiskFileFilter();

    public static final Directory getDirectory(Player player, File file, IConfig cfg) throws IOException {
        if (diskFilter.accept(file)) {
            return DiskDirectory.getDirectory(file);
        }
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".t64")) {
            return T64Directory.getDirectory(file);
        }
        if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".crt")) {
            return CartridgeDirectory.getDirectory(file);
        }
        if (tuneFilter.accept(file)) {
            return PseudoDirectory.getTuneAsDirectory(player, file, cfg);
        }
        return null;
    }

    private static Directory getTuneAsDirectory(Player player, File file, IConfig cfg) throws IOException {
        SidTune tune;
        Directory dir = new Directory();
        try {
            tune = SidTune.load(file);
        }
        catch (SidTuneError e) {
            throw new IOException();
        }
        SidPlay2Section sidPlay2Section = (SidPlay2Section)player.getConfig().getSidplay2Section();
        String collectionName = PathUtils.getCollectionName(sidPlay2Section.getHvscFile(), file);
        HVSCEntry entry = new HVSCEntry(() -> player.getSidDatabaseInfo(db -> db.getTuneLength(tune), 0), collectionName, file, tune);
        String title = entry.getTitle() != null ? entry.getTitle() : entry.getName();
        dir.setTitle(DirEntry.asciiTopetscii(title, 16));
        dir.setId((String.valueOf(entry.getStartSong()) + "/" + String.valueOf(Math.max(1, entry.getNoOfSongs()))).getBytes(ISO88591));
        Collection<DirEntry> entries = dir.getDirEntries();
        PseudoDirectory.addProperty(entries, "TITLE", entry.getTitle());
        PseudoDirectory.addProperty(entries, "AUTHOR", entry.getAuthor());
        PseudoDirectory.addProperty(entries, "RELEASED", entry.getReleased());
        PseudoDirectory.addProperty(entries, "FORMAT", entry.getFormat());
        PseudoDirectory.addProperty(entries, "PLAYERID", entry.getPlayerId());
        PseudoDirectory.addProperty(entries, "NO_SONGS", String.valueOf(entry.getNoOfSongs()));
        PseudoDirectory.addProperty(entries, "STARTSONG", String.valueOf(entry.getStartSong()));
        PseudoDirectory.addProperty(entries, "CLOCKFREQ", String.valueOf((Object)entry.getClockFreq()));
        PseudoDirectory.addProperty(entries, "SPEED", String.valueOf((Object)entry.getSpeed()));
        PseudoDirectory.addProperty(entries, "SIDMODEL1", String.valueOf((Object)entry.getSidModel1()));
        PseudoDirectory.addProperty(entries, "SIDMODEL2", String.valueOf((Object)entry.getSidModel2()));
        PseudoDirectory.addProperty(entries, "SIDMODEL3", String.valueOf((Object)entry.getSidModel3()));
        PseudoDirectory.addProperty(entries, "COMPAT", String.valueOf((Object)entry.getCompatibility()));
        PseudoDirectory.addProperty(entries, "TUNE_LGTH", String.valueOf(entry.getTuneLength()));
        PseudoDirectory.addProperty(entries, "AUDIO", entry.getAudio());
        PseudoDirectory.addProperty(entries, "CHIP_BASE1", String.valueOf(entry.getSidChipBase1()));
        PseudoDirectory.addProperty(entries, "CHIP_BASE2", String.valueOf(entry.getSidChipBase2()));
        PseudoDirectory.addProperty(entries, "CHIP_BASE3", String.valueOf(entry.getSidChipBase3()));
        PseudoDirectory.addProperty(entries, "DRV_ADDR", String.valueOf(entry.getDriverAddress()));
        PseudoDirectory.addProperty(entries, "LOAD_ADDR", String.valueOf(entry.getLoadAddress()));
        PseudoDirectory.addProperty(entries, "LOAD_LGTH", String.valueOf(entry.getLoadLength()));
        PseudoDirectory.addProperty(entries, "INIT_ADDR", String.valueOf(entry.getInitAddress()));
        PseudoDirectory.addProperty(entries, "PLY_ADDR", String.valueOf(entry.getPlayerAddress()));
        PseudoDirectory.addProperty(entries, "FILE_DATE", String.valueOf(entry.getFileDate()));
        PseudoDirectory.addProperty(entries, "SIZE_KB", String.valueOf(entry.getFileSizeKb()));
        PseudoDirectory.addProperty(entries, "SIZE_B", String.valueOf(entry.getTuneSizeB()));
        PseudoDirectory.addProperty(entries, "RELOC_PAGE", String.valueOf(entry.getRelocStartPage()));
        PseudoDirectory.addProperty(entries, "RELOC_PAGES", String.valueOf(entry.getRelocNoPages()));
        return dir;
    }

    private static void addProperty(Collection<DirEntry> entries, String property, String value) {
        byte[] filename = DirEntry.asciiTopetscii(property + "=" + value, 20);
        entries.add(new DirEntry(0, filename, -1){

            @Override
            public void save(File autostartFile) throws IOException {
            }
        });
    }
}

