/*
 * Decompiled with CFR 0.152.
 */
package ui.directory;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import libsidutils.directory.DirEntry;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.UIUtil;
import ui.directory.DirectoryItem;
import ui.directory.PseudoDirectory;

public class Directory
extends VBox
implements UIPart {
    private static final int TRUE_TYPE_FONT_BIG = 57344;
    private static final int TRUE_TYPE_FONT_SMALL = 57600;
    private static final int TRUE_TYPE_FONT_INVERSE_BIG = 57856;
    private static final int TRUE_TYPE_FONT_INVERSE_SMALL = 58112;
    @FXML
    protected TableView<DirectoryItem> directory;
    @FXML
    private TableColumn<DirectoryItem, String> dirColumn;
    private UIUtil util;
    private ObservableList<DirectoryItem> directoryEntries;
    private ObjectProperty<File> autoStartFileProperty = new SimpleObjectProperty();
    private int fontSet = 57344;
    private int fontSetHeader = 57856;
    private File previewFile;

    public Directory(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.getChildren().add((Object)((Node)this.util.parse()));
    }

    @FXML
    private void initialize() {
        this.dirColumn.prefWidthProperty().bind((ObservableValue)this.directory.widthProperty());
        this.directoryEntries = FXCollections.observableArrayList();
        this.directory.setItems(this.directoryEntries);
        this.directory.setOnKeyPressed(event -> {
            DirectoryItem selectedItem = (DirectoryItem)this.directory.getSelectionModel().getSelectedItem();
            if (event.getCode() == KeyCode.ENTER && selectedItem != null) {
                this.autoStartProgram();
            }
        });
        this.directory.setOnMousePressed(event -> {
            if (event.isPrimaryButtonDown() && event.getClickCount() > 1) {
                this.autoStartProgram();
            }
        });
    }

    @FXML
    private void doSwitchFont() {
        this.fontSet = this.fontSet == 57344 ? 57600 : 57344;
        this.fontSetHeader = this.fontSetHeader == 57856 ? 58112 : 57856;
        this.loadPreview(this.previewFile);
    }

    public ObjectProperty<File> getAutoStartFileProperty() {
        return this.autoStartFileProperty;
    }

    protected void autoStartProgram() {
        try {
            DirectoryItem dirItem = (DirectoryItem)this.directory.getSelectionModel().getSelectedItem();
            if (dirItem == null) {
                return;
            }
            DirEntry dirEntry = dirItem.getDirEntry();
            if (dirEntry != null) {
                File autoStartFile = new File(this.util.getConfig().getSidplay2Section().getTmpDir(), dirEntry.getValidFilename() + ".prg");
                autoStartFile.deleteOnExit();
                dirEntry.save(autoStartFile);
                this.autoStartFileProperty.set((Object)autoStartFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadPreview(File previewFile) {
        block6: {
            if (previewFile == null) {
                return;
            }
            this.previewFile = previewFile;
            this.dirColumn.setText(previewFile.getName());
            this.directoryEntries.clear();
            try {
                libsidutils.directory.Directory dir = PseudoDirectory.getDirectory(this.util.getPlayer(), previewFile, this.util.getConfig());
                if (dir != null) {
                    DirectoryItem headerItem = new DirectoryItem();
                    headerItem.setText(this.print(dir.toString(), this.fontSetHeader));
                    this.directoryEntries.add((Object)headerItem);
                    Collection<DirEntry> dirEntries = dir.getDirEntries();
                    for (DirEntry dirEntry : dirEntries) {
                        DirectoryItem dirItem = new DirectoryItem();
                        dirItem.setText(this.print(dirEntry.toString(), this.fontSet));
                        dirItem.setDirEntry(dirEntry);
                        this.directoryEntries.add((Object)dirItem);
                    }
                    if (dir.getStatusLine() != null) {
                        DirectoryItem dirItem = new DirectoryItem();
                        dirItem.setText(this.print(dir.getStatusLine(), this.fontSet));
                        this.directoryEntries.add((Object)dirItem);
                    }
                    break block6;
                }
                throw new IOException();
            }
            catch (IOException ioE) {
                DirectoryItem dirItem = new DirectoryItem();
                dirItem.setText(this.print("SORRY, NO PREVIEW AVAILABLE!", 57344));
                this.directoryEntries.add((Object)dirItem);
            }
        }
        DirectoryItem dirItem = new DirectoryItem();
        dirItem.setText(this.print("READY.", 57344));
        this.directoryEntries.add((Object)dirItem);
    }

    private String print(String s, int fontSet) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            buf.append(this.print(s.charAt(i), fontSet));
        }
        return buf.toString();
    }

    private String print(char c, int fontSet) {
        if ((c & 0x60) == 0) {
            return String.valueOf((char)(c | 0x40 | fontSet ^ 0x200));
        }
        return String.valueOf((char)(c | fontSet));
    }
}

