/*
 * Decompiled with CFR 0.152.
 */
package ui.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.UIUtil;

public class ConsoleOutput
extends VBox
implements UIPart {
    private StringBuilder output = new StringBuilder();
    @FXML
    protected TextArea console;
    @FXML
    private TitledPane titledPane;
    private UIUtil util;

    public ConsoleOutput(C64Window window, Player player) {
        this.util = new UIUtil(window, player, this);
        this.getChildren().add((Object)((Node)this.util.parse()));
    }

    @FXML
    private void clearConsole() {
        this.console.clear();
        this.output.setLength(0);
    }

    public PrintStream getPrintStream(final OutputStream original) {
        return new PrintStream(new OutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                original.write(b, off, len);
                this.print(new String(b, off, len));
            }

            @Override
            public synchronized void write(int ch) throws IOException {
                original.write(ch);
                this.print(String.valueOf((char)ch));
            }

            private void print(String str) {
                ConsoleOutput.this.output.append(str);
                if (str.indexOf(10) != -1) {
                    Platform.runLater(() -> {
                        ConsoleOutput.this.console.setText(ConsoleOutput.this.output.toString());
                        ConsoleOutput.this.console.setScrollTop(Double.MAX_VALUE);
                    });
                }
            }
        });
    }

    public TitledPane getTitledPane() {
        return this.titledPane;
    }

    public TextArea getConsole() {
        return this.console;
    }
}

