/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.DoubleProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.BuilderFactory;
import sidplay.Player;
import ui.JSidPlay2Main;
import ui.common.C64Window;
import ui.common.UIBuilder;
import ui.common.UIPart;
import ui.entities.config.Configuration;

public class UIUtil {
    private static final Image PLAYED_ICON = new Image(JSidPlay2Main.class.getResource("icons/play.png").toString());
    private C64Window window;
    private Player player;
    private ResourceBundle bundle;
    private UIPart controller;
    private DoubleProperty progressProperty;

    public UIUtil(C64Window window, Player player, UIPart controller) {
        this.window = window;
        this.player = player;
        this.controller = controller;
        this.bundle = ResourceBundle.getBundle(controller.getBundleName());
        window.getUiParts().add(controller);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object parse() {
        FXMLLoader fxmlLoader = new FXMLLoader();
        URL fxml = this.controller.getFxml();
        fxmlLoader.setLocation(fxml);
        fxmlLoader.setBuilderFactory((BuilderFactory)new UIBuilder(this.window, this.player));
        fxmlLoader.setResources(this.bundle);
        fxmlLoader.setController((Object)this.controller);
        try (InputStream is = fxml.openStream();){
            Object object = fxmlLoader.load(is);
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException("Unparsable View: " + fxml, e);
        }
    }

    public final void setPlayingTab(Tab tab) {
        this.resetPlayingTab((Node)tab.getTabPane().getScene().getRoot());
        tab.setGraphic((Node)new ImageView(PLAYED_ICON));
        for (Parent p = tab.getTabPane().getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof TabPane)) continue;
            TabPane tabPane = (TabPane)p;
            ((Tab)tabPane.getSelectionModel().selectedItemProperty().get()).setGraphic((Node)new ImageView(PLAYED_ICON));
        }
    }

    private void resetPlayingTab(Node n) {
        if (n instanceof TabPane) {
            TabPane tabPane = (TabPane)n;
            for (Tab tab : tabPane.getTabs()) {
                tab.setGraphic(null);
            }
        }
        if (n instanceof Parent) {
            for (Node c : ((Parent)n).getChildrenUnmodifiable()) {
                this.resetPlayingTab(c);
            }
        }
    }

    public final DoubleProperty progressProperty(Node node) {
        ProgressBar progressBar;
        if (this.progressProperty == null && node.getScene() != null && (progressBar = (ProgressBar)node.getScene().lookup("#progress")) != null) {
            this.progressProperty = progressBar.progressProperty();
        }
        return this.progressProperty;
    }

    public final Player getPlayer() {
        return this.player;
    }

    public final Configuration getConfig() {
        return (Configuration)this.player.getConfig();
    }

    public final ResourceBundle getBundle() {
        return this.bundle;
    }
}

