/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TextField;

public class TypeTextField
extends TextField {
    private static final String NUMBERS = "[\\-0-9]";
    private static final String FLOATS = "[\\-0-9.]";
    private StringProperty type = new SimpleStringProperty();
    private String pattern;

    public String getType() {
        return (String)this.type.get();
    }

    public void setType(String type) {
        this.type.set((Object)type);
        this.setPattern(type);
    }

    private void setPattern(String type) {
        if (type.equals("Long") || type.equals("Integer") || type.equals("Date") || type.equals("Short")) {
            this.pattern = NUMBERS;
        } else if (type.equals("Float")) {
            this.pattern = FLOATS;
        } else if (type.equals("String")) {
            this.pattern = null;
        } else {
            throw new RuntimeException("Unsupported data type: " + type);
        }
    }

    public void replaceText(int start, int end, String text) {
        if (this.pattern == null || text.isEmpty() || text.matches(this.pattern)) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        if (this.pattern == null || text.isEmpty() || text.matches(this.pattern)) {
            super.replaceSelection(text);
        }
    }

    public Object getValue() {
        if (((String)this.type.get()).equals("Long")) {
            try {
                return Long.parseLong(this.getText());
            }
            catch (NumberFormatException e) {
                return new Long(0L);
            }
        }
        if (((String)this.type.get()).equals("Integer") || ((String)this.type.get()).equals("Date")) {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException e) {
                return new Integer(0);
            }
        }
        if (((String)this.type.get()).equals("Short")) {
            try {
                return Short.parseShort(this.getText());
            }
            catch (NumberFormatException e) {
                return new Short(0);
            }
        }
        if (((String)this.type.get()).equals("Float")) {
            try {
                return Float.valueOf(Float.parseFloat(this.getText()));
            }
            catch (NumberFormatException e) {
                return new Float(0.0f);
            }
        }
        return this.getText();
    }

    public void setValue(Object value) {
        if (((String)this.type.get()).equals("Long")) {
            this.setText(String.valueOf((Long)value));
        } else if (((String)this.type.get()).equals("Integer") || ((String)this.type.get()).equals("Date")) {
            this.setText(String.valueOf((Integer)value));
        } else if (((String)this.type.get()).equals("Short")) {
            this.setText(String.valueOf((Short)value));
        } else if (((String)this.type.get()).equals("Float")) {
            this.setText(String.valueOf((Float)value));
        }
        this.setText(value.toString());
    }
}

