/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import javafx.util.StringConverter;

public final class NumberToString<T extends Number>
extends StringConverter<T> {
    private int factor;
    private int decimalPlaces;

    public NumberToString(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        this.factor = (int)Math.pow(10.0, decimalPlaces);
    }

    public String toString(T d) {
        double rounded = (double)Math.round(((Number)d).doubleValue() * (double)this.factor) / (double)this.factor;
        return String.format("%." + this.decimalPlaces + "f", rounded);
    }

    public T fromString(String string) {
        throw new RuntimeException("Unsupported conversion of string to number: " + string);
    }
}

