/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import com.sun.javafx.scene.control.behavior.SliderBehavior;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.layout.StackPane;

public class KnobSkin
extends SkinBase<Slider> {
    private double knobRadius;
    private double minAngle = -140.0;
    private double maxAngle = 140.0;
    protected double dragOffset;
    protected StackPane knob;
    private StackPane knobOverlay;
    protected StackPane knobDot;

    public KnobSkin(Slider slider) {
        super((Control)slider);
        this.initialize();
    }

    private void initialize() {
        this.knob = new StackPane(){

            protected void layoutChildren() {
                KnobSkin.this.knobDot.setLayoutX((KnobSkin.this.knob.getWidth() - KnobSkin.this.knobDot.getWidth()) / 2.0);
                KnobSkin.this.knobDot.setLayoutY(5.0 + KnobSkin.this.knobDot.getHeight() / 2.0);
            }
        };
        this.knob.getStyleClass().setAll((Object[])new String[]{"knob"});
        this.knobOverlay = new StackPane();
        this.knobOverlay.getStyleClass().setAll((Object[])new String[]{"knobOverlay"});
        this.knobDot = new StackPane();
        this.knobDot.getStyleClass().setAll((Object[])new String[]{"knobDot"});
        this.getChildren().setAll((Object[])new Node[]{this.knob, this.knobOverlay});
        this.knob.getChildren().add((Object)this.knobDot);
        SliderBehavior behavior = new SliderBehavior((Slider)this.getSkinnable());
        ((Slider)this.getSkinnable()).setOnKeyPressed(ke -> ((Slider)this.getSkinnable()).requestLayout());
        ((Slider)this.getSkinnable()).setOnKeyReleased(ke -> ((Slider)this.getSkinnable()).requestLayout());
        ((Slider)this.getSkinnable()).setOnMousePressed(me -> {
            double dragStart = this.mouseToValue(me.getX(), me.getY());
            double zeroOneValue = (((Slider)this.getSkinnable()).getValue() - ((Slider)this.getSkinnable()).getMin()) / (((Slider)this.getSkinnable()).getMax() - ((Slider)this.getSkinnable()).getMin());
            this.dragOffset = zeroOneValue - dragStart;
            behavior.thumbPressed(me, dragStart);
            behavior.trackPress(me, dragStart);
            ((Slider)this.getSkinnable()).requestLayout();
        });
        ((Slider)this.getSkinnable()).setOnMouseReleased(me -> behavior.thumbReleased(me));
        ((Slider)this.getSkinnable()).setOnMouseDragged(me -> {
            behavior.thumbDragged(me, this.mouseToValue(me.getX(), me.getY()) + this.dragOffset);
            ((Slider)this.getSkinnable()).requestLayout();
        });
        ((Slider)this.getSkinnable()).valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ((Slider)KnobSkin.this.getSkinnable()).requestLayout();
            }
        });
    }

    private double mouseToValue(double mouseX, double mouseY) {
        double cx = ((Slider)this.getSkinnable()).getWidth() / 2.0;
        double cy = ((Slider)this.getSkinnable()).getHeight() / 2.0;
        double mouseAngle = Math.toDegrees(Math.atan((mouseY - cy) / (mouseX - cx)));
        double topZeroAngle = mouseX < cx ? 90.0 - mouseAngle : -(90.0 + mouseAngle);
        double value = 1.0 - (topZeroAngle - this.minAngle) / (this.maxAngle - this.minAngle);
        return value;
    }

    private void rotateKnob() {
        Slider s = (Slider)this.getSkinnable();
        double zeroOneValue = (s.getValue() - s.getMin()) / (s.getMax() - s.getMin());
        double angle = this.minAngle + (this.maxAngle - this.minAngle) * zeroOneValue;
        this.knob.setRotate(angle);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double knobWidth = this.knob.prefWidth(-1.0);
        double knobHeight = this.knob.prefHeight(-1.0);
        this.knobRadius = Math.max(knobWidth, knobHeight) / 2.0;
        this.knob.resize(knobWidth, knobHeight);
        this.knob.setLayoutX(cx - this.knobRadius);
        this.knob.setLayoutY(cy - this.knobRadius);
        this.knobOverlay.resize(knobWidth, knobHeight);
        this.knobOverlay.setLayoutX(cx - this.knobRadius);
        this.knobOverlay.setLayoutY(cy - this.knobRadius);
        this.rotateKnob();
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.knob.minWidth(-1.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.knob.minHeight(-1.0) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.knob.prefWidth(-1.0) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.knob.prefHeight(-1.0) + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }
}

