/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.cart.supported.REU;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import sidplay.Player;
import ui.filefilter.CartFileFilter;
import ui.filefilter.DiskFileFilter;
import ui.filefilter.TapeFileFilter;
import ui.filefilter.TuneFileFilter;

public class Convenience {
    private static final String MACOSX = "__MACOSX";
    private static final TuneFileFilter tuneFileFilter = new TuneFileFilter();
    private static final DiskFileFilter diskFileFilter = new DiskFileFilter();
    private static final TapeFileFilter tapeFileFilter = new TapeFileFilter();
    private static final CartFileFilter cartFileFilter = new CartFileFilter();
    public static final BiPredicate<File, File> LEXICALLY_FIRST_MEDIA = (file, toAttach) -> toAttach == null || !tuneFileFilter.accept((File)file) && file.getName().compareTo(toAttach.getName()) < 0;
    private static final String LOAD_8_1_RUN = "LOAD\"*\",8,1\rRUN\r";
    private static final String LOAD_RUN = "LOAD\rRUN\r";
    private Player player;
    private Consumer<File> autoStartedFile = file -> {};

    public Convenience(Player player) {
        this.player = player;
    }

    public void setAutoStartedFile(Consumer<File> autoStartedFile) {
        this.autoStartedFile = autoStartedFile;
    }

    public boolean autostart(File file, BiPredicate<File, File> isMediaToAttach, File autoStartFile) throws IOException, SidTuneError, URISyntaxException {
        String tmpDir = this.player.getConfig().getSidplay2Section().getTmpDir();
        TFile zip = new TFile(file);
        File toAttach = null;
        if (zip.isArchive()) {
            TFile.cp_rp((File)zip, (File)new File(tmpDir), (TArchiveDetector)TArchiveDetector.ALL);
            toAttach = this.getToAttach(tmpDir, (File)zip, isMediaToAttach, null);
            TFile.rm_r((File)zip);
        } else if (this.isSupportedMedia(file)) {
            toAttach = file;
        }
        if (toAttach != null) {
            if (tuneFileFilter.accept(toAttach)) {
                if (!(this.player.getC64().getCartridge() instanceof REU)) {
                    this.player.getC64().ejectCartridge();
                }
                this.player.play(SidTune.load(toAttach));
                this.autoStartedFile.accept(toAttach);
                return true;
            }
            if (diskFileFilter.accept(toAttach)) {
                this.player.getC64().ejectCartridge();
                this.player.insertDisk(toAttach);
                this.autoStart(autoStartFile, LOAD_8_1_RUN);
                return true;
            }
            if (tapeFileFilter.accept(toAttach)) {
                this.player.getC64().ejectCartridge();
                this.player.insertTape(toAttach);
                this.autoStart(autoStartFile, LOAD_RUN);
                return true;
            }
            if (cartFileFilter.accept(toAttach)) {
                this.player.insertCartridge(CartridgeType.CRT, toAttach);
                this.autoStart(autoStartFile, null);
                return true;
            }
        }
        return false;
    }

    private void autoStart(File file, String command) throws IOException, SidTuneError {
        if (file != null) {
            this.player.play(SidTune.load(file));
            this.autoStartedFile.accept(file);
        } else {
            this.player.resetC64(command);
        }
    }

    private File getToAttach(String dir, File file, BiPredicate<File, File> mediaTester, File toAttach) {
        File[] listFiles = file.listFiles();
        if (listFiles == null) {
            return toAttach;
        }
        for (File member : listFiles) {
            File toAttachChild;
            File memberFile = new File(dir, member.getName());
            memberFile.deleteOnExit();
            if (memberFile.isFile() && this.isSupportedMedia(memberFile) && mediaTester.test(memberFile, toAttach)) {
                if (memberFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".reu")) {
                    try {
                        this.player.insertCartridge(CartridgeType.REU, memberFile);
                    }
                    catch (IOException | SidTuneError e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                toAttach = memberFile;
                continue;
            }
            if (!memberFile.isDirectory() || memberFile.getName().equals(MACOSX) || (toAttachChild = this.getToAttach(memberFile.getPath(), (File)new TFile(memberFile), mediaTester, toAttach)) == null) continue;
            toAttach = toAttachChild;
        }
        return toAttach;
    }

    public boolean isSupportedMedia(File file) {
        return cartFileFilter.accept(file) || tuneFileFilter.accept(file) || diskFileFilter.accept(file) || tapeFileFilter.accept(file);
    }
}

