/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import sidplay.Player;
import ui.common.UIPart;
import ui.common.UIUtil;

public abstract class C64Window
implements UIPart {
    protected UIUtil util;
    private Stage stage;
    private Scene scene;
    private boolean wait;
    private final Collection<UIPart> uiParts = new ArrayList<UIPart>();

    public C64Window(Player player) {
        this(new Stage(), player);
        Platform.runLater(() -> this.stage.centerOnScreen());
    }

    public C64Window(Stage stage, Player player) {
        this.stage = stage;
        this.util = new UIUtil(this, player, this);
        this.scene = (Scene)this.util.parse();
        this.scene.setOnKeyPressed(ke -> {
            if (ke.getCode() == KeyCode.ESCAPE) {
                this.close();
            }
        });
        stage.getIcons().add((Object)new Image(this.util.getBundle().getString("ICON")));
        if (stage.getTitle() == null) {
            stage.setTitle(this.util.getBundle().getString("TITLE"));
        }
        stage.setOnCloseRequest(event -> this.close());
        stage.setScene(this.scene);
    }

    public void open() {
        if (this.wait) {
            this.stage.showAndWait();
        } else {
            this.stage.show();
        }
    }

    protected void close() {
        this.stage.close();
        for (UIPart part : this.uiParts) {
            part.doClose();
        }
    }

    public void close(UIPart part) {
        part.doClose();
        this.uiParts.remove(part);
    }

    public Stage getStage() {
        return this.stage;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    Collection<UIPart> getUiParts() {
        return this.uiParts;
    }

    public UIUtil getUtil() {
        return this.util;
    }
}

