/*
 * Decompiled with CFR 0.152.
 */
package ui;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import libsidplay.components.c1541.C1541;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import sidplay.Player;
import ui.JSidPlay2;
import ui.common.Convenience;
import ui.entities.config.Configuration;
import ui.entities.config.SidPlay2Section;
import ui.entities.config.service.ConfigService;

@Parameters(resourceBundle="ui.JSidPlay2Main")
public class JSidPlay2Main
extends Application {
    @Parameter(names={"--help", "-h"}, descriptionKey="USAGE", help=true)
    private Boolean help = Boolean.FALSE;
    @Parameter(names={"--configurationType", "-c"}, descriptionKey="CONFIGURATION_TYPE")
    private ConfigService.ConfigurationType configurationType = ConfigService.ConfigurationType.XML;
    @Parameter(description="filename")
    private List<String> filenames = new ArrayList<String>();
    private Player player;
    private Consumer<Player> menuHook = player -> {
        if (player.getTune() != SidTune.RESET) {
            String path;
            SidTuneInfo info = player.getTune().getInfo();
            Iterator<String> detail = info.getInfoString().iterator();
            System.out.print("Playing: ");
            while (detail.hasNext()) {
                System.out.print(detail.next());
                if (!detail.hasNext()) continue;
                System.out.print(", ");
            }
            if (info.getSongs() > 1) {
                System.out.print(", sub-song: ");
                System.out.print(info.getCurrentSong());
            }
            if ((path = player.getSidDatabaseInfo(db -> db.getPath(player.getTune()), "")).length() > 0) {
                System.out.print(", ");
                System.out.print(path);
            }
            System.out.println();
        }
    };
    private ConfigService configService;
    private static JSidPlay2 testInstance;

    public void start(Stage primaryStage) {
        this.player = new Player(this.getConfigurationFromCommandLineArgs());
        this.player.setMenuHook(this.menuHook);
        Optional filename = this.filenames.stream().findFirst();
        if (filename.isPresent()) {
            try {
                new Convenience(this.player).autostart(new File((String)filename.get()), Convenience.LEXICALLY_FIRST_MEDIA, null);
            }
            catch (IOException | URISyntaxException | SidTuneError e) {
                System.err.println(e.getMessage());
            }
        }
        JSidPlay2 jSidplay2 = new JSidPlay2(primaryStage, this.player);
        SidPlay2Section section = (SidPlay2Section)this.player.getConfig().getSidplay2Section();
        if (section.getFullScreen() != null) {
            primaryStage.setFullScreen(section.getFullScreen().booleanValue());
        }
        primaryStage.fullScreenProperty().addListener((observable, oldValue, newValue) -> section.setFullScreen((Boolean)newValue));
        Scene scene = primaryStage.getScene();
        if (scene != null) {
            Window window = scene.getWindow();
            window.setX((double)section.getFrameX());
            window.setY((double)section.getFrameY());
            window.setWidth((double)section.getFrameWidth());
            window.setHeight((double)section.getFrameHeight());
            window.widthProperty().addListener((observable, oldValue, newValue) -> section.setFrameWidth(newValue.intValue()));
            window.heightProperty().addListener((observable, oldValue, newValue) -> section.setFrameHeight(newValue.intValue()));
            window.xProperty().addListener((observable, oldValue, newValue) -> section.setFrameX(newValue.intValue()));
            window.yProperty().addListener((observable, oldValue, newValue) -> section.setFrameY(newValue.intValue()));
        }
        jSidplay2.open();
        testInstance = jSidplay2;
    }

    private Configuration getConfigurationFromCommandLineArgs() {
        try {
            Application.Parameters parameters = this.getParameters();
            if (parameters != null) {
                JCommander commander = new JCommander((Object)this, parameters.getRaw().toArray(new String[0]));
                commander.setProgramName(((Object)((Object)this)).getClass().getName());
                commander.setCaseSensitiveOptions(true);
                if (this.help.booleanValue()) {
                    commander.usage();
                    System.out.println("Press <enter> to exit!");
                    System.in.read();
                    System.exit(0);
                }
            }
        }
        catch (ParameterException | IOException e) {
            System.err.println(e.getMessage());
        }
        return this.getConfiguration();
    }

    public void stop() {
        this.player.stopC64();
        for (C1541 floppy : this.player.getFloppies()) {
            try {
                floppy.getDiskController().ejectDisk();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.player.getDatasette().ejectTape();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configService.save((Configuration)this.player.getConfig());
        this.configService.close();
    }

    private Configuration getConfiguration() {
        this.configService = new ConfigService(this.configurationType);
        return this.configService.load();
    }

    public static void main(String[] args) {
        JSidPlay2Main.launch((String[])args);
    }

    public static JSidPlay2 getInstance() {
        return testInstance;
    }
}

